/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.Stub;
import com.vmware.vim.vmomi.client.common.impl.MethodInvocationHandlerImpl;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.types.ManagedObjectFactory;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ManagedObjectFactoryImpl
implements ManagedObjectFactory {
    ProtocolBinding _binding;
    RequestContext _requestContext;
    ResultInterceptor _resultInterceptor;
    RequestRetryCallback _requestRetryCallback;

    public ManagedObjectFactoryImpl(ProtocolBinding binding, RequestContext requestContext) {
        this(binding, requestContext, null, null);
    }

    public ManagedObjectFactoryImpl(ProtocolBinding binding, RequestContext requestContext, ResultInterceptor resultInterceptor, RequestRetryCallback requestRetryCallback) {
        this._binding = binding;
        this._requestContext = requestContext;
        this._resultInterceptor = resultInterceptor;
        this._requestRetryCallback = requestRetryCallback;
    }

    public ManagedObject createManagedObject(VmodlContext context, VmodlTypeMap typeMap, VmodlVersion version, ManagedObjectReference moRef) {
        ManagedObjectType moType = (ManagedObjectType)typeMap.getVmodlType(moRef.getType());
        if (moType == null) {
            throw new IllegalArgumentException(String.format("Unable to resolve type of %s", moRef.getType()));
        }
        return (ManagedObject)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{moType.getTypeClass(), Stub.class}, this.createInvocationHandler(version, moRef, moType));
    }

    private InvocationHandler createInvocationHandler(VmodlVersion version, ManagedObjectReference moRef, ManagedObjectType moType) {
        MethodInvocationHandlerImpl handler = new MethodInvocationHandlerImpl(moRef, moType, version, this._binding, this, this._resultInterceptor, this._requestRetryCallback);
        if (this._requestContext != null) {
            handler._setRequestContext(this._requestContext.clone());
        }
        return handler;
    }
}

