/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.common.impl.ManagedObjectFactoryImpl;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.HttpClient;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpSchemeUtils;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientFactory {
    private static final Log LOG = LogFactory.getLog(ClientFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient createHttpClient(URI endPoint, Class<?> version, HttpClientConfiguration config, VmodlVersionMap versionMap) {
        VmodlVersion vmodlVersion = versionMap.getVersion(version);
        config.getHttpConfigurationCompiler().compile(config.getHttpConfiguration());
        CompiledHttpConfiguration compiledHttpConfiguration = ((HttpConfigurationImpl)config.getHttpConfiguration()).getCompiledConfiguration();
        synchronized (compiledHttpConfiguration) {
            ClientFactory.validate(endPoint, vmodlVersion, ((HttpConfigurationImpl)config.getHttpConfiguration()).getCompiledConfiguration());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating HTTP client with following properties:\nEnd point: " + endPoint + "\nThread pool: " + config.getExecutor() + "\nResult interceptor: " + config.getResulInterceptor()));
            }
            HttpProtocolBindingImpl binding = new HttpProtocolBindingImpl(endPoint, config.getExecutor(), config.getHttpConfiguration());
            binding.setInvocationInterceptor(config.getInvocationInterceptor());
            HttpClient client = new HttpClient(vmodlVersion, binding, config.getManagedObjectFactory() == null ? new ManagedObjectFactoryImpl(binding, config.getRequestContext(), config.getResulInterceptor(), config.getRequestRetryCallback()) : config.getManagedObjectFactory());
            return client;
        }
    }

    private static void validate(URI endPoint, VmodlVersion version, CompiledHttpConfiguration config) {
        if (!config.isActive()) {
            throw new IllegalStateException("The specified http configuration is already shutdown.");
        }
        if (version == null) {
            throw new IllegalStateException("Client version not specified");
        }
        if (endPoint == null) {
            throw new IllegalStateException("Client endpoint not specified");
        }
        if (!HttpSchemeUtils.checkSchema(endPoint)) {
            throw new IllegalStateException("Unknown scheme " + endPoint.getScheme());
        }
    }
}

