/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.idp.exception;

import com.vmware.vim.idp.exception.ServiceException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;

public final class IdpNotFoundException
extends ServiceException {
    private static final long serialVersionUID = 7421750026093775687L;
    private final String _idpName;

    public IdpNotFoundException(Throwable cause, String idpName) {
        super(IdpNotFoundException.getDefaultMessage(idpName), cause);
        ValidateUtil.validateNotEmpty(idpName, "IDP name");
        this._idpName = idpName;
    }

    public IdpNotFoundException(String idpName) {
        super(IdpNotFoundException.getDefaultMessage(idpName));
        ValidateUtil.validateNotEmpty(idpName, "IDP name");
        this._idpName = idpName;
    }

    public String getIdpName() {
        return this._idpName;
    }

    private static String getDefaultMessage(String idpName) {
        return String.format("Cannot find IDP with name '%s'.", idpName);
    }
}

