/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;

public final class AboutInfo {
    private final String version;
    private final String build;
    private final String apiRevision;
    private final String clusterId;
    private final String deploymentId;

    public AboutInfo(String version, String build, String apiRevision, String clusterId, String deploymentId) {
        ValidateUtil.validateNotEmpty(version, "version");
        ValidateUtil.validateNotEmpty(build, "build");
        ValidateUtil.validateNotEmpty(apiRevision, "apiRevision");
        ValidateUtil.validateNotEmpty(clusterId, "instanceId ");
        ValidateUtil.validateNotEmpty(deploymentId, "deploymentId");
        this.clusterId = clusterId;
        this.deploymentId = deploymentId;
        this.version = version;
        this.build = build;
        this.apiRevision = apiRevision;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    public String getApiRevision() {
        return this.apiRevision;
    }

    public String toString() {
        StringBuilder toStrBuilder = new StringBuilder();
        toStrBuilder.append("{").append(this.getClass().getSimpleName()).append(" | ").append("version: ").append(this.version).append("; build: ").append(this.build).append("; api revision: ").append(this.apiRevision).append("; clusterId: ").append(this.clusterId).append("; deploymentId: ").append(this.deploymentId).append("}");
        return toStrBuilder.toString();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }
}

