/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.Domain;
import com.vmware.vim.sso.admin.IdentitySource;
import com.vmware.vim.sso.admin.LdapIdentitySourceDetails;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.util.NamedValue;
import java.util.Collections;

public final class LdapIdentitySource
extends IdentitySource {
    private final Type _type;
    private final LdapIdentitySourceDetails _details;
    private final AuthenticationDetails _authenticationDetails;

    public LdapIdentitySource(Domain domain, Type type, LdapIdentitySourceDetails details, AuthenticationDetails authenticationDetails) {
        super(LdapIdentitySource.getName(domain), Collections.singleton(domain));
        ValidateUtil.validateNotNull(type, "type");
        ValidateUtil.validateNotNull(details, "details");
        ValidateUtil.validateNotNull(authenticationDetails, "authenticationDetails");
        this._type = type;
        this._details = details;
        this._authenticationDetails = authenticationDetails;
    }

    public Type getType() {
        return this._type;
    }

    public LdapIdentitySourceDetails getDetails() {
        return this._details;
    }

    public AuthenticationDetails getAuthenticationDetails() {
        return this._authenticationDetails;
    }

    @Override
    public String toString() {
        StringBuilder objString = new StringBuilder(100);
        objString.append(super.toString());
        objString.append(", type=");
        objString.append(this.getType());
        objString.append(", authenticationDetails=(");
        objString.append(this.getAuthenticationDetails());
        objString.append("), details=(");
        objString.append(this.getDetails());
        objString.append(")");
        return objString.toString();
    }

    private static String getName(Domain domain) {
        ValidateUtil.validateNotNull(domain, "domain");
        return domain.getName();
    }

    public static final class AuthenticationDetails {
        private final AuthenticationType _authenticationType;
        private final String _username;

        public AuthenticationDetails(AuthenticationType authenticationType, String username) {
            ValidateUtil.validateNotNull(authenticationType, "authenticationType");
            if (KnownAuthenticationType.password.equals(authenticationType)) {
                ValidateUtil.validateNotEmpty(username, "username");
            }
            this._authenticationType = authenticationType;
            this._username = username;
        }

        public AuthenticationType getAuthenticationType() {
            return this._authenticationType;
        }

        public String getUsername() {
            return this._username;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(70);
            objString.append(super.toString());
            objString.append(", type=");
            objString.append(this.getAuthenticationType());
            objString.append(", userName=");
            objString.append(this.getUsername());
            return objString.toString();
        }
    }

    public static final class OtherAuthType
    extends NamedValue
    implements AuthenticationType {
        private OtherAuthType(String name) {
            super(name);
        }

        public static AuthenticationType valueOf(String name) {
            return NamedValue.valueOf(name, KnownAuthenticationType.class, new OtherAuthType(name));
        }
    }

    public static enum KnownAuthenticationType implements AuthenticationType
    {
        anonymous,
        password,
        reuseSession;

    }

    public static interface AuthenticationType {
        public String name();
    }

    public static final class OtherType
    extends NamedValue
    implements Type {
        private OtherType(String name) {
            super(name);
        }

        public static Type valueOf(String name) {
            return NamedValue.valueOf(name, KnownType.class, new OtherType(name));
        }
    }

    public static enum KnownType implements Type
    {
        ActiveDirectory,
        OpenLdap;

    }

    public static interface Type {
        public String name();
    }
}

