/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.PersonDetails;
import com.vmware.vim.sso.admin.Principal;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;

public final class PersonUser
extends Principal {
    private final PersonDetails _details;
    private final boolean _disabled;
    private final boolean _locked;

    public PersonUser(PrincipalId id, PersonDetails details, boolean disabled, boolean locked) {
        this(id, null, details, disabled, locked);
    }

    public PersonUser(PrincipalId id, PrincipalId alias, PersonDetails details, boolean disabled, boolean locked) {
        super(id, alias);
        ValidateUtil.validateNotNull(details, "Person Details");
        this._disabled = disabled;
        this._locked = locked;
        this._details = details;
    }

    @Override
    public PersonDetails getDetails() {
        return this._details;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public boolean isLocked() {
        return this._locked;
    }

    @Override
    public final String getCanonicalName() {
        PrincipalId id = this.getId();
        return String.format("%s@%s", id.getName(), id.getDomain().toUpperCase());
    }
}

