/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.GroupDetails;
import com.vmware.vim.sso.admin.PersonDetails;
import com.vmware.vim.sso.admin.RoleManagement;
import com.vmware.vim.sso.admin.SolutionDetails;
import com.vmware.vim.sso.admin.exception.DuplicateSolutionCertificateException;
import com.vmware.vim.sso.admin.exception.GroupCyclicDependencyException;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.PasswordPolicyViolationException;

public interface PrincipalManagement {
    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public PrincipalId createLocalPersonUser(String var1, PersonDetails var2, char[] var3) throws InvalidPrincipalException, PasswordPolicyViolationException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public PrincipalId createLocalSolutionUser(String var1, SolutionDetails var2) throws InvalidPrincipalException, DuplicateSolutionCertificateException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public PrincipalId createLocalSolutionUser(String var1, SolutionDetails var2, boolean var3) throws InvalidPrincipalException, DuplicateSolutionCertificateException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public PrincipalId createLocalGroup(String var1, GroupDetails var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void deleteLocalPrincipal(String var1) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean removeFromLocalGroup(PrincipalId var1, String var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean[] removeFromLocalGroup(PrincipalId[] var1, String var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean addUserToLocalGroup(PrincipalId var1, String var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean[] addUsersToLocalGroup(PrincipalId[] var1, String var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean addGroupToLocalGroup(PrincipalId var1, String var2) throws InvalidPrincipalException, GroupCyclicDependencyException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean[] addGroupsToLocalGroup(PrincipalId[] var1, String var2) throws InvalidPrincipalException, GroupCyclicDependencyException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public PrincipalId updateLocalPersonUserDetails(String var1, PersonDetails var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public PrincipalId updateLocalSolutionUserDetails(String var1, SolutionDetails var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public PrincipalId updateLocalGroupDetails(String var1, GroupDetails var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void resetLocalPersonUserPassword(String var1, char[] var2) throws InvalidPrincipalException, PasswordPolicyViolationException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.NoPrivilege
    public void resetLocalPersonUserPassword(String var1, char[] var2, char[] var3) throws InvalidPrincipalException, PasswordPolicyViolationException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean unlockUserAccount(PrincipalId var1) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean enableUserAccount(PrincipalId var1) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean disableUserAccount(PrincipalId var1) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public int getDaysRemainingUntilPasswordExpiration(PrincipalId var1) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean registerExternalUser(PrincipalId var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public boolean removeExternalUser(PrincipalId var1) throws NotAuthenticatedException, NoPermissionException, InvalidPrincipalException;
}

