/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.exception;

import com.vmware.vim.sso.admin.exception.ADIDPRegistrationServiceException;

public class ADIDSAlreadyExistException
extends ADIDPRegistrationServiceException {
    final String domainName;
    private static final long serialVersionUID = -4284865881381641922L;

    public ADIDSAlreadyExistException(String message, String name) {
        super(message);
        this.domainName = name;
    }

    public ADIDSAlreadyExistException(String domainName) {
        super(ADIDSAlreadyExistException.getDefaultMessage(domainName));
        assert (null != domainName && !domainName.trim().isEmpty());
        this.domainName = domainName;
    }

    public ADIDSAlreadyExistException(Throwable t, String domainName) {
        super(ADIDSAlreadyExistException.getDefaultMessage(domainName), t);
        assert (null != domainName && !domainName.trim().isEmpty());
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    private static String getDefaultMessage(String name) {
        return String.format("There is already one IdentitySource of AD type registered: name '%s'. Only one IDS of AD type is allowed", name);
    }
}

