/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.exception;

import com.vmware.vim.sso.admin.exception.ServiceException;

public class DuplicateDomainNameException
extends ServiceException {
    private final String domainName;
    private final String domainAlias;
    private static final long serialVersionUID = -4284865881381641922L;

    public DuplicateDomainNameException(String name) {
        this(name, (String)null);
    }

    public DuplicateDomainNameException(String name, String alias) {
        super(DuplicateDomainNameException.getDefaultMessage(name, alias));
        assert (null != name && !name.trim().isEmpty());
        this.domainName = name;
        this.domainAlias = alias;
    }

    public DuplicateDomainNameException(String message, String name, String alias) {
        super(message);
        assert (null != name && !name.trim().isEmpty());
        this.domainName = name;
        this.domainAlias = alias;
    }

    public DuplicateDomainNameException(Throwable t, String name) {
        super(DuplicateDomainNameException.getDefaultMessage(name, null), t);
        assert (null != name && !name.trim().isEmpty());
        this.domainName = name;
        this.domainAlias = null;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDomainAlias() {
        return this.domainAlias;
    }

    private static String getDefaultMessage(String name, String alias) {
        return String.format("Domain with name '%s' and alias '%s' already exists.", name, alias);
    }
}

