/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.util;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.client.util.codec.Base64;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertificateUtil {
    private static final String FINGERPRINT_ALGORITHM = "SHA-1";
    private static final String CERT_PROVIDER_TYPE = "X.509";

    public static X509Certificate decodeCertificate(byte[] certificateDer) {
        CertificateFactory certFactory;
        ValidateUtil.validateNotEmpty(certificateDer, "certificateDer");
        ByteArrayInputStream stream = new ByteArrayInputStream(certificateDer);
        try {
            certFactory = CertificateFactory.getInstance(CERT_PROVIDER_TYPE);
        }
        catch (CertificateException e) {
            throw new IllegalStateException(String.format("Internal error: %s Certificate Factory is not available (uncompliant JRE?)", CERT_PROVIDER_TYPE), e);
        }
        try {
            return (X509Certificate)certFactory.generateCertificate(stream);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Invalid certificate bytes", e);
        }
    }

    public static X509Certificate decodeCertificate(String base64Cert) {
        ValidateUtil.validateNotEmpty(base64Cert, "base64Cert");
        return CertificateUtil.decodeCertificate(Base64.decodeBase64((String)base64Cert));
    }

    public static X509Certificate[] decodeCertificates(String[] certStrings) {
        ValidateUtil.validateNotNull(certStrings, "certificates");
        X509Certificate[] certs = new X509Certificate[certStrings.length];
        for (int i = 0; i < certStrings.length; ++i) {
            certs[i] = CertificateUtil.decodeCertificate(certStrings[i]);
        }
        return certs;
    }

    public static String encodeCertificate(X509Certificate cert) {
        ValidateUtil.validateNotNull(cert, "certificate");
        try {
            return Base64.encodeBase64String((byte[])cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("Invalid certificate data", e);
        }
    }

    public static String[] encodeCertificates(X509Certificate[] certs) {
        ValidateUtil.validateNotNull(certs, "certificates");
        String[] certStrings = new String[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            certStrings[i] = CertificateUtil.encodeCertificate(certs[i]);
        }
        return certStrings;
    }

    public static String calculateFingerprint(byte[] certificateDer) {
        MessageDigest digest;
        ValidateUtil.validateNotEmpty(certificateDer, "DER certificate");
        try {
            digest = MessageDigest.getInstance(FINGERPRINT_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Internal error: digest %s is unavailable (uncompliant JRE?)", FINGERPRINT_ALGORITHM), e);
        }
        byte[] hash = digest.digest(certificateDer);
        int delimiter = 58;
        int len = hash.length * 2 + hash.length - 1;
        StringBuilder fingerprint = new StringBuilder(len);
        for (int i = 0; i < hash.length; ++i) {
            int n = i;
            hash[n] = (byte)(hash[n] & 0xFF);
            fingerprint.append(String.format("%02x", hash[i]));
            if (i >= hash.length - 1) continue;
            fingerprint.append(':');
        }
        return fingerprint.toString();
    }

    public static String calculateFingerprint(X509Certificate cert) {
        ValidateUtil.validateNotNull(cert, "certificate");
        try {
            return CertificateUtil.calculateFingerprint(cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("Certificate cannot be encoded to DER", e);
        }
    }
}

