/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg;

import com.vmware.sso.cfg.LoadCertificateChain;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.openssl.PEMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtractCA {
    private static final Logger executionLog = LoggerFactory.getLogger((String)"execution");
    private static final Logger log = LoggerFactory.getLogger(ExtractCA.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        executionLog.info("BEGIN Extract CA");
        int statusCode = 1;
        try {
            if (args.length != 2) {
                log.error("Exactly two parameters are required (certificate chain and destination) but {} are provided", (Object)args.length);
                statusCode = 3;
            } else {
                File fChain = new File(args[0]);
                File fDest = new File(args[1]);
                statusCode = ExtractCA.extractCaCert(fChain, fDest);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.debug("", (Throwable)e);
            statusCode = 1;
        }
        finally {
            executionLog.info("END Extract CA");
            System.exit(statusCode);
        }
    }

    private static int extractCaCert(File fChain, File fDest) {
        List<X509Certificate> chain = LoadCertificateChain.extractCertificates(fChain);
        X509Certificate root = chain.get(chain.size() - 1);
        return ExtractCA.persistToFile(root, fDest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int persistToFile(X509Certificate cert, File fDest) {
        int n;
        PEMWriter dest = null;
        try {
            dest = new PEMWriter((Writer)new FileWriter(fDest));
            dest.writeObject((Object)cert);
            dest.flush();
            n = 0;
        }
        catch (IOException e) {
            int n2;
            try {
                log.error("I/O error writing to destination file {}: {}", (Object)fDest.getAbsolutePath(), (Object)e.getMessage());
                log.debug("", (Throwable)e);
                n2 = 1;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(dest);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)dest);
            return n2;
        }
        IOUtils.closeQuietly((Writer)dest);
        return n;
    }
}

