/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg.components.impl;

import com.vmware.sso.cfg.components.IllegalSslConfigException;
import com.vmware.sso.cfg.components.ServerSslConfig;
import com.vmware.sso.cfg.components.ServerSslConfigFactory;
import com.vmware.sso.cfg.components.SystemTrustStore;
import com.vmware.sso.cfg.components.apache.http.conn.ssl.X509HostnameVerifier;
import com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.net.ssl.SSLException;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.openssl.PEMReader;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerSslConfigFactoryImpl
implements ServerSslConfigFactory,
GroovyObject {
    private static final String CRYPTO_PROV = "BC";
    private static final String CERTIFICATE_HEADER = "-----BEGIN CERTIFICATE-----";
    private static final String ERROR_CHAIN_NOT_CHAIN = "The certificate chain file does not contain a valid certification path";
    private static final String ERROR_CHAIN_NOT_VALID;
    private static final String ERROR_CHAIN_EXPAND_FAILED;
    private static final String ERROR_CHAIN_CORRUPT;
    private static final String GEN_ROOT_SUBJECT;
    private static final String GEN_LEAF_SUBJECT;
    private static final String OID_md2WithRSAEncryption = "1.2.840.113549.1.1.2";
    private static final String OID_md4WithRSAEncryption = "1.2.840.113549.1.1.3";
    private static final String OID_md5WithRSAEncryption = "1.2.840.113549.1.1.4";
    private static final String OID_sha1WithRSAEncryption = "1.2.840.113549.1.1.5";
    private static final Map<String, String> WEAK_HASHES;
    private static final int GEN_ROOT_KEY_SIZE = 3072;
    private static final int GEN_LEAF_KEY_SIZE = 2048;
    private static final int MIN_KEY_LENGTH = 1024;
    private static final String ENV_SKIP_SAN_CHECK = "ssl_tool_no_cert_san_check";
    private static final String ENV_SKIP_KEY_LEN_CHECK = "ssl_tool_no_key_len_check";
    private static final String ENV_SKIP_CLEANINESS_CHECK = "ssl_tool_no_pem_clean_check";
    private final Logger log;
    private final Provider<KeyStore> systemTrustStore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1378297898781;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$java$security$PrivateKey;
    private static /* synthetic */ Class $class$java$security$cert$X509Certificate;
    private static /* synthetic */ Class $class$org$bouncycastle$asn1$x509$KeyPurposeId;
    private static /* synthetic */ Class $class$org$bouncycastle$asn1$x509$X509Extension;
    private static /* synthetic */ Class $class$java$lang$String;
    private static /* synthetic */ Class $class$java$security$SecureRandom;
    private static /* synthetic */ Class $class$org$bouncycastle$cert$jcajce$JcaX509v3CertificateBuilder;
    private static /* synthetic */ Class $class$org$slf4j$Logger;
    private static /* synthetic */ Class $class$org$bouncycastle$operator$jcajce$JcaContentSignerBuilder;
    private static /* synthetic */ Class $class$java$net$NetworkInterface;
    private static /* synthetic */ Class $class$javax$inject$Provider;
    private static /* synthetic */ Class $class$java$util$Set;
    private static /* synthetic */ Class $class$javax$security$auth$x500$X500Principal;
    private static /* synthetic */ Class $class$java$security$cert$X509CertSelector;
    private static /* synthetic */ Class $class$java$util$Iterator;
    private static /* synthetic */ Class $class$org$bouncycastle$asn1$x509$GeneralNames;
    private static /* synthetic */ Class $class$org$apache$commons$io$IOUtils;
    private static /* synthetic */ Class $class$org$bouncycastle$asn1$x509$BasicConstraints;
    private static /* synthetic */ Class $class$java$util$Date;
    private static /* synthetic */ Class $class$java$util$HashMap;
    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl;
    private static /* synthetic */ Class $class$java$security$cert$CertStore;
    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$ServerSslConfig;
    private static /* synthetic */ Class $class$org$bouncycastle$cert$jcajce$JcaX509CertificateConverter;
    private static /* synthetic */ Class $class$java$net$InetAddress;
    private static /* synthetic */ Class $class$java$io$BufferedReader;
    private static /* synthetic */ Class $class$org$slf4j$LoggerFactory;
    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$apache$http$conn$ssl$X509HostnameVerifier;
    private static /* synthetic */ Class $class$java$util$Collections;
    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes;
    private static /* synthetic */ Class $class$java$util$Random;
    private static /* synthetic */ Class $class$java$util$List;
    private static /* synthetic */ Class $class$java$util$TimeZone;
    private static /* synthetic */ Class $class$java$util$Map;
    private static /* synthetic */ Class $class$org$bouncycastle$asn1$x509$ExtendedKeyUsage;
    private static /* synthetic */ Class $class$com$vmware$sso$cfg$logging$LogConst;
    private static /* synthetic */ Class $class$java$security$interfaces$RSAPrivateCrtKey;
    private static /* synthetic */ Class $class$java$security$cert$CertPath;
    private static /* synthetic */ Class $class$org$bouncycastle$openssl$PEMReader;
    private static /* synthetic */ Class $class$java$io$Reader;
    private static /* synthetic */ Class $class$org$bouncycastle$cert$X509v3CertificateBuilder;
    private static /* synthetic */ Class $class$java$util$Calendar;
    private static /* synthetic */ Class $class$java$security$cert$CertPathValidator;
    private static /* synthetic */ Class $class$java$security$KeyPair;
    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$IllegalSslConfigException;
    private static /* synthetic */ Class $class$java$security$interfaces$RSAPublicKey;
    private static /* synthetic */ Class $class$java$security$cert$TrustAnchor;
    private static /* synthetic */ Class $class$java$security$cert$CollectionCertStoreParameters;
    private static /* synthetic */ Class $class$java$security$cert$CertificateFactory;
    private static /* synthetic */ Class $class$java$security$KeyPairGenerator;
    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$DNSResolver;
    private static /* synthetic */ Class $class$java$security$cert$PKIXCertPathBuilderResult;
    private static /* synthetic */ Class $class$org$bouncycastle$asn1$x509$GeneralName;
    private static /* synthetic */ Class $class$org$bouncycastle$asn1$x509$KeyUsage;
    private static /* synthetic */ Class array$$class$org$bouncycastle$asn1$x509$GeneralName;
    private static /* synthetic */ Class $class$java$lang$System;
    private static /* synthetic */ Class $class$java$security$cert$CertPathBuilder;
    private static /* synthetic */ Class $class$java$util$ArrayList;
    private static /* synthetic */ Class $class$java$io$FileReader;
    private static /* synthetic */ Class $class$java$security$cert$PKIXBuilderParameters;
    private static /* synthetic */ Class $class$java$security$PublicKey;
    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$apache$http$conn$ssl$StrictHostnameVerifier;
    private static /* synthetic */ Class $class$java$math$BigInteger;

    /*
     * WARNING - void declaration
     */
    @Inject
    public ServerSslConfigFactoryImpl(@SystemTrustStore Provider<KeyStore> provider) {
        void systemTrustStore;
        MetaClass metaClass;
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        Object object = callSiteArray[0].call((Object)ServerSslConfigFactoryImpl.$get$$class$org$slf4j$LoggerFactory(), callSiteArray[1].callGroovyObjectGetProperty((Object)this));
        this.log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$org$slf4j$Logger());
        this.metaClass = metaClass = this.$getStaticMetaClass();
        callSiteArray[2].call(WEAK_HASHES, (Object)OID_md2WithRSAEncryption, (Object)"MD2");
        callSiteArray[3].call(WEAK_HASHES, (Object)OID_md4WithRSAEncryption, (Object)"MD4");
        callSiteArray[4].call(WEAK_HASHES, (Object)OID_md5WithRSAEncryption, (Object)"MD5");
        callSiteArray[5].call(WEAK_HASHES, (Object)OID_sha1WithRSAEncryption, (Object)"SHA-1");
        Provider provider2 = (Provider)systemTrustStore;
        this.systemTrustStore = (Provider)ScriptBytecodeAdapter.castToType((Object)provider2, (Class)ServerSslConfigFactoryImpl.$get$$class$javax$inject$Provider());
    }

    @Override
    public ServerSslConfig load(File privateKeyFile, File chainFile) throws IllegalSslConfigException {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        PrivateKey key = (PrivateKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callCurrent((GroovyObject)this, (Object)privateKeyFile), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$PrivateKey());
        List chain = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callCurrent((GroovyObject)this, (Object)chainFile), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$List());
        X509Certificate leaf = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call((Object)chain), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$X509Certificate());
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callCurrent((GroovyObject)this, (Object)key, callSiteArray[10].callGetProperty((Object)leaf)))) {
            String msg = "Private key does not match the leaf certificate's public key.";
            throw (Throwable)callSiteArray[11].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[12].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
        }
        return (ServerSslConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfig(), (Object)key, (Object)chain), (Class)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfig());
    }

    @Override
    public ServerSslConfig generate(String ou, String hostname) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        callSiteArray[14].call((Object)this.log, (Object)"Generating auto certificate configuration for: {}", (Object)ou);
        Calendar startDateC = (Calendar)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Calendar(), callSiteArray[16].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$TimeZone(), (Object)"GMT")), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Calendar());
        callSiteArray[17].call((Object)startDateC, callSiteArray[18].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Calendar()), (Object)((Integer)DefaultTypeTransformation.box((int)-24)));
        Date startDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].call((Object)startDateC), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Date());
        int validityDays = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[20].call((Object)((Integer)DefaultTypeTransformation.box((int)365)), (Object)((Integer)DefaultTypeTransformation.box((int)15)));
            validityDays = DefaultTypeTransformation.intUnbox((Object)object);
        } else {
            int n;
            validityDays = n = 365 * 15;
        }
        ServerSslConfig rootCert = (ServerSslConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callCurrent((GroovyObject)this, (Object)startDate, (Object)((Integer)DefaultTypeTransformation.box((int)validityDays))), (Class)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfig());
        return (ServerSslConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)rootCert, (Object)ou, (Object)startDate, (Object)((Integer)DefaultTypeTransformation.box((int)validityDays)), (Object)hostname)), (Class)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfig());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrivateKey loadKeyFile(File keyFile) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        callSiteArray[23].call((Object)this.log, callSiteArray[24].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{callSiteArray[25].callGetProperty((Object)keyFile)}, new String[]{"Loading private key file ", ""}));
        try {
            PrivateKey key;
            Object keyObj;
            block13: {
                block14: {
                    block12: {
                        keyObj = callSiteArray[26].call((Object)keyFile, (Object)new GeneratedClosure(this, this){
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;
                            private static /* synthetic */ Class $class$org$bouncycastle$openssl$PEMReader;
                            private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadKeyFile_closure1;
                            {
                                CallSite[] callSiteArray = _loadKeyFile_closure1.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Reader r) {
                                CallSite[] callSiteArray = _loadKeyFile_closure1.$getCallSiteArray();
                                return callSiteArray[0].call(callSiteArray[1].callConstructor((Object)_loadKeyFile_closure1.$get$$class$org$bouncycastle$openssl$PEMReader(), (Object)r));
                            }

                            public Object call(Reader r) {
                                CallSite[] callSiteArray = _loadKeyFile_closure1.$getCallSiteArray();
                                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)r);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _loadKeyFile_closure1.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadKeyFile_closure1()) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                                CallSite[] callSiteArray = _loadKeyFile_closure1.$getCallSiteArray();
                                $callSiteArray = null;
                            }

                            static {
                                _loadKeyFile_closure1.__$swapInit();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "readObject";
                                stringArray[1] = "<$constructor$>";
                                stringArray[2] = "doCall";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[3];
                                _loadKeyFile_closure1.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_loadKeyFile_closure1.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadKeyFile_closure1(), stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _loadKeyFile_closure1.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            private static /* synthetic */ Class $get$$class$org$bouncycastle$openssl$PEMReader() {
                                Class clazz = $class$org$bouncycastle$openssl$PEMReader;
                                if (clazz == null) {
                                    clazz = $class$org$bouncycastle$openssl$PEMReader = _loadKeyFile_closure1.class$("org.bouncycastle.openssl.PEMReader");
                                }
                                return clazz;
                            }

                            private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadKeyFile_closure1() {
                                Class clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadKeyFile_closure1;
                                if (clazz == null) {
                                    clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadKeyFile_closure1 = _loadKeyFile_closure1.class$("com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl$_loadKeyFile_closure1");
                                }
                                return clazz;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        });
                        key = null;
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) break block12;
                        if (!ScriptBytecodeAdapter.compareEqual((Object)keyObj, null)) break block13;
                        break block14;
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)keyObj, null)) {
                        String msg = "Key file is empty, or contains an unsupported object type.";
                        throw (Throwable)callSiteArray[27].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[28].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
                    }
                    if (keyObj instanceof KeyPair) {
                        Object object = callSiteArray[29].callGetProperty((Object)((KeyPair)ScriptBytecodeAdapter.castToType((Object)keyObj, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$KeyPair())));
                        key = (PrivateKey)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$PrivateKey());
                        return key;
                    } else {
                        PrivateKey privateKey;
                        if (!(keyObj instanceof PrivateKey)) {
                            String msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(callSiteArray[31].call((Object)"Key file does not contain a private key, or the ", (Object)"private key is encoded using an unsupported scheme. Supported key "), (Object)"encoding schemas are: PKCS#1, PKCS#8."), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                            callSiteArray[32].call((Object)this.log, (Object)"Key file contains (unsupported) object type: {}", callSiteArray[33].callGetProperty(callSiteArray[34].callGetProperty(keyObj)));
                            throw (Throwable)callSiteArray[35].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[36].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
                        }
                        key = privateKey = (PrivateKey)ScriptBytecodeAdapter.castToType((Object)keyObj, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$PrivateKey());
                    }
                    return key;
                }
                String msg = "Key file is empty, or contains an unsupported object type.";
                throw (Throwable)callSiteArray[37].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[38].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
            }
            if (keyObj instanceof KeyPair) {
                Object object = callSiteArray[39].callGetProperty((Object)((KeyPair)ScriptBytecodeAdapter.castToType((Object)keyObj, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$KeyPair())));
                key = (PrivateKey)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$PrivateKey());
                return key;
            } else {
                PrivateKey privateKey;
                if (!(keyObj instanceof PrivateKey)) {
                    String msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call(callSiteArray[41].call((Object)"Key file does not contain a private key, or the ", (Object)"private key is encoded using an unsupported scheme. Supported key "), (Object)"encoding schemas are: PKCS#1, PKCS#8."), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                    callSiteArray[42].call((Object)this.log, (Object)"Key file contains (unsupported) object type: {}", callSiteArray[43].callGetProperty(callSiteArray[44].callGetProperty(keyObj)));
                    throw (Throwable)callSiteArray[45].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[46].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
                }
                key = privateKey = (PrivateKey)ScriptBytecodeAdapter.castToType((Object)keyObj, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$PrivateKey());
            }
            return key;
        }
        catch (IOException e) {
            String msg = (String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{callSiteArray[47].callGetProperty((Object)keyFile), callSiteArray[48].callGetProperty((Object)e)}, new String[]{"I/O error reading the key file ", ": ", "."}), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            throw (Throwable)callSiteArray[49].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[50].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()), (Object)e);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    private List<X509Certificate> loadCertChain(File chainFile) {
        Object object;
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        callSiteArray[51].call((Object)this.log, callSiteArray[52].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{callSiteArray[53].callGetProperty((Object)chainFile)}, new String[]{"Loading certificate chain file ", ""}));
        Reader chainReader = (Reader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$io$BufferedReader(), callSiteArray[55].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$io$FileReader(), (Object)chainFile)), (Class)ServerSslConfigFactoryImpl.$get$$class$java$io$Reader());
        try {
            callSiteArray[56].callCurrent((GroovyObject)this, (Object)chainReader);
            object = callSiteArray[57].callCurrent((GroovyObject)this, (Object)chainReader);
        }
        catch (Throwable throwable) {
            callSiteArray[60].call((Object)ServerSslConfigFactoryImpl.$get$$class$org$apache$commons$io$IOUtils(), (Object)chainReader);
            throw throwable;
        }
        callSiteArray[58].call((Object)ServerSslConfigFactoryImpl.$get$$class$org$apache$commons$io$IOUtils(), (Object)chainReader);
        return (List)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$List());
    }

    private List<X509Certificate> loadCertChainFromStream(Reader stream) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        List chain = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$ArrayList()), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$List());
        PEMReader reader = (PEMReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$openssl$PEMReader(), (Object)stream), (Class)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$openssl$PEMReader());
        try {
            Object certObj = null;
            while (true) {
                Object object;
                certObj = object = callSiteArray[63].call((Object)reader);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)object, null)) {
                    X509Certificate cert = (X509Certificate)ScriptBytecodeAdapter.asType((Object)certObj, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$X509Certificate());
                    callSiteArray[64].call((Object)this.log, callSiteArray[65].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{callSiteArray[66].callGetProperty((Object)cert)}, new String[]{"Loaded X.509 certificate for Subject: ", ""}));
                    callSiteArray[67].call((Object)chain, (Object)cert);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            callSiteArray[68].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[69].callGetProperty((Object)e)}, new String[]{"I/O exception while reading the certificate chain: ", ""}), (Object)e);
            throw (Throwable)callSiteArray[70].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)ERROR_CHAIN_CORRUPT, callSiteArray[71].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()), (Object)e);
        }
        catch (StringIndexOutOfBoundsException e) {
            callSiteArray[72].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[73].callGetProperty((Object)e)}, new String[]{"Possibly base64 decoding exception while reading the certificate chain: ", ""}), (Object)e);
            throw (Throwable)callSiteArray[74].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)ERROR_CHAIN_CORRUPT, callSiteArray[75].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()), (Object)e);
        }
        catch (ClassCastException e) {
            String msg = "Certificate chain contains non-certificate.";
            throw (Throwable)callSiteArray[76].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[77].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()), (Object)e);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].callGetProperty((Object)chain))) {
            String msg = "Certificate chain file is empty, or contains unsupported object type(s).";
            throw (Throwable)callSiteArray[79].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[80].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
        }
        callSiteArray[81].call((Object)this.log, callSiteArray[82].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{callSiteArray[83].call((Object)chain)}, new String[]{"Successfully loaded ", " certificate(s) from the chain file."}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].callCurrent((GroovyObject)this, callSiteArray[85].call((Object)chain, (Object)((Integer)DefaultTypeTransformation.box((int)-1)))))) {
            callSiteArray[86].call((Object)this.log, (Object)"Supplied chain does not end in a self-signed certificate. Trying to expand it using well-known authorities.");
            Object object = callSiteArray[87].callCurrent((GroovyObject)this, (Object)chain);
            chain = (List)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$List());
        }
        callSiteArray[88].callCurrent((GroovyObject)this, (Object)chain);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[89].callGetProperty((Object)this.log))) {
            callSiteArray[90].call((Object)this.log, callSiteArray[91].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)"The effective SSL certificate chain is:");
            callSiteArray[92].call((Object)chain, (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadCertChainFromStream_closure2;
                private static /* synthetic */ Class $class$com$vmware$sso$cfg$logging$LogConst;
                {
                    CallSite[] callSiteArray = _loadCertChainFromStream_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(X509Certificate cert, int idx) {
                    CallSite[] callSiteArray = _loadCertChainFromStream_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].callGetProperty((Object)_loadCertChainFromStream_closure2.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{(Integer)DefaultTypeTransformation.box((int)idx), callSiteArray[3].call(callSiteArray[4].callGetProperty((Object)cert))}, new String[]{"   [", "] ", ""}));
                }

                public Object call(X509Certificate cert, int idx) {
                    CallSite[] callSiteArray = _loadCertChainFromStream_closure2.$getCallSiteArray();
                    return callSiteArray[5].callCurrent((GroovyObject)this, (Object)cert, (Object)((Integer)DefaultTypeTransformation.box((int)idx)));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadCertChainFromStream_closure2.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadCertChainFromStream_closure2()) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                    CallSite[] callSiteArray = _loadCertChainFromStream_closure2.$getCallSiteArray();
                    $callSiteArray = null;
                }

                static {
                    _loadCertChainFromStream_closure2.__$swapInit();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "info";
                    stringArray[1] = "log";
                    stringArray[2] = "MARK_VERBOSE";
                    stringArray[3] = "toString";
                    stringArray[4] = "subjectX500Principal";
                    stringArray[5] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[6];
                    _loadCertChainFromStream_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_loadCertChainFromStream_closure2.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadCertChainFromStream_closure2(), stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _loadCertChainFromStream_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadCertChainFromStream_closure2() {
                    Class clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadCertChainFromStream_closure2;
                    if (clazz == null) {
                        clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_loadCertChainFromStream_closure2 = _loadCertChainFromStream_closure2.class$("com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl$_loadCertChainFromStream_closure2");
                    }
                    return clazz;
                }

                private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$logging$LogConst() {
                    Class clazz = $class$com$vmware$sso$cfg$logging$LogConst;
                    if (clazz == null) {
                        clazz = $class$com$vmware$sso$cfg$logging$LogConst = _loadCertChainFromStream_closure2.class$("com.vmware.sso.cfg.logging.LogConst");
                    }
                    return clazz;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
        callSiteArray[93].callCurrent((GroovyObject)this, (Object)chain);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[94].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$System(), (Object)ENV_SKIP_SAN_CHECK), (Object)"1")) {
                callSiteArray[95].callCurrent((GroovyObject)this, callSiteArray[96].call((Object)chain, (Object)((Integer)DefaultTypeTransformation.box((int)0))));
            } else {
                callSiteArray[97].call((Object)this.log, callSiteArray[98].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{ENV_SKIP_SAN_CHECK}, new String[]{"Skipping leaf certificate's subjectAltName check due to ", "=1"}));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[99].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$System(), (Object)ENV_SKIP_SAN_CHECK), (Object)"1")) {
            callSiteArray[100].callCurrent((GroovyObject)this, callSiteArray[101].call((Object)chain, (Object)((Integer)DefaultTypeTransformation.box((int)0))));
        } else {
            callSiteArray[102].call((Object)this.log, callSiteArray[103].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{ENV_SKIP_SAN_CHECK}, new String[]{"Skipping leaf certificate's subjectAltName check due to ", "=1"}));
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[104].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$System(), (Object)ENV_SKIP_KEY_LEN_CHECK), (Object)"1")) {
                callSiteArray[105].callCurrent((GroovyObject)this, callSiteArray[106].call((Object)chain, (Object)((Integer)DefaultTypeTransformation.box((int)0))));
            } else {
                callSiteArray[107].call((Object)this.log, callSiteArray[108].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{ENV_SKIP_KEY_LEN_CHECK}, new String[]{"Skipping leaf certificate public key's key length check due to ", "=1"}));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[109].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$System(), (Object)ENV_SKIP_KEY_LEN_CHECK), (Object)"1")) {
            callSiteArray[110].callCurrent((GroovyObject)this, callSiteArray[111].call((Object)chain, (Object)((Integer)DefaultTypeTransformation.box((int)0))));
        } else {
            callSiteArray[112].call((Object)this.log, callSiteArray[113].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{ENV_SKIP_KEY_LEN_CHECK}, new String[]{"Skipping leaf certificate public key's key length check due to ", "=1"}));
        }
        callSiteArray[114].callCurrent((GroovyObject)this, callSiteArray[115].call((Object)chain, (Object)((Integer)DefaultTypeTransformation.box((int)0))));
        return chain;
    }

    private boolean keyPairMatch(PrivateKey privateKey, PublicKey publicKey) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        boolean match = false;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[116].callGetProperty((Object)privateKey), (Object)callSiteArray[117].callGetProperty((Object)publicKey))) {
                boolean bl;
                match = bl = false;
            } else if (privateKey instanceof RSAPrivateCrtKey && publicKey instanceof RSAPublicKey) {
                boolean bl;
                boolean bl2;
                RSAPrivateCrtKey rsaPrivKey = (RSAPrivateCrtKey)ScriptBytecodeAdapter.castToType((Object)privateKey, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$interfaces$RSAPrivateCrtKey());
                RSAPublicKey rsaPubKey = (RSAPublicKey)ScriptBytecodeAdapter.castToType((Object)publicKey, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$interfaces$RSAPublicKey());
                match = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[118].callGetProperty((Object)rsaPrivKey), (Object)callSiteArray[119].callGetProperty((Object)rsaPubKey)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[120].callGetProperty((Object)rsaPrivKey), (Object)callSiteArray[121].callGetProperty((Object)rsaPubKey)) ? (bl2 = false) : (bl = true);
            } else {
                boolean bl;
                match = bl = true;
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[122].callGetProperty((Object)privateKey), (Object)callSiteArray[123].callGetProperty((Object)publicKey))) {
            boolean bl;
            match = bl = false;
        } else if (privateKey instanceof RSAPrivateCrtKey && publicKey instanceof RSAPublicKey) {
            boolean bl;
            boolean bl3;
            RSAPrivateCrtKey rsaPrivKey = (RSAPrivateCrtKey)ScriptBytecodeAdapter.castToType((Object)privateKey, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$interfaces$RSAPrivateCrtKey());
            RSAPublicKey rsaPubKey = (RSAPublicKey)ScriptBytecodeAdapter.castToType((Object)publicKey, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$interfaces$RSAPublicKey());
            match = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[124].callGetProperty((Object)rsaPrivKey), (Object)callSiteArray[125].callGetProperty((Object)rsaPubKey)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[126].callGetProperty((Object)rsaPrivKey), (Object)callSiteArray[127].callGetProperty((Object)rsaPubKey)) ? (bl3 = false) : (bl = true);
        } else {
            boolean bl;
            match = bl = true;
        }
        return match;
    }

    private void verifyChainFileIsClean(Reader stream) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[128].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$System(), (Object)ENV_SKIP_CLEANINESS_CHECK), (Object)"1")) {
                callSiteArray[129].call((Object)this.log, callSiteArray[130].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{ENV_SKIP_CLEANINESS_CHECK}, new String[]{"Skipping PEM cleanliness check due to ", "=1"}));
            } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[131].callCurrent((GroovyObject)this, (Object)stream, (Object)CERTIFICATE_HEADER))) {
                String msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[132].call(callSiteArray[133].call((Object)new GStringImpl(new Object[]{CERTIFICATE_HEADER}, new String[]{"Certificate chain file does not start with the expected header `", "'. "}), (Object)"Remove any text before that header to ensure compatibility with all components. "), (Object)new GStringImpl(new Object[]{ENV_SKIP_CLEANINESS_CHECK}, new String[]{"To skip this check, set the environment variable `", "' to 1."})), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                throw (Throwable)callSiteArray[134].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[135].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[136].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$System(), (Object)ENV_SKIP_CLEANINESS_CHECK), (Object)"1")) {
            callSiteArray[137].call((Object)this.log, callSiteArray[138].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)new GStringImpl(new Object[]{ENV_SKIP_CLEANINESS_CHECK}, new String[]{"Skipping PEM cleanliness check due to ", "=1"}));
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[139].callCurrent((GroovyObject)this, (Object)stream, (Object)CERTIFICATE_HEADER))) {
            String msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[140].call(callSiteArray[141].call((Object)new GStringImpl(new Object[]{CERTIFICATE_HEADER}, new String[]{"Certificate chain file does not start with the expected header `", "'. "}), (Object)"Remove any text before that header to ensure compatibility with all components. "), (Object)new GStringImpl(new Object[]{ENV_SKIP_CLEANINESS_CHECK}, new String[]{"To skip this check, set the environment variable `", "' to 1."})), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            throw (Throwable)callSiteArray[142].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[143].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
        }
    }

    private boolean pemIsClean(Reader stream, String expectedHeader) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        int headerLen = DefaultTypeTransformation.intUnbox((Object)callSiteArray[144].call((Object)expectedHeader));
        char[] actualHeader = new char[headerLen];
        callSiteArray[145].call((Object)stream, (Object)((Integer)DefaultTypeTransformation.box((int)headerLen)));
        callSiteArray[146].call((Object)stream, (Object)actualHeader);
        callSiteArray[147].call((Object)stream);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[148].call((Object)expectedHeader, callSiteArray[149].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$String(), (Object)actualHeader)));
    }

    private void validateChainIsChain(List<X509Certificate> chain) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        CertificateFactory cf = (CertificateFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[150].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CertificateFactory(), (Object)"X.509", (Object)CRYPTO_PROV), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CertificateFactory());
        CertPathValidator pathValidator = (CertPathValidator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CertPathValidator(), (Object)"PKIX", (Object)CRYPTO_PROV), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CertPathValidator());
        try {
            CertPath path = (CertPath)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].call((Object)cf, chain), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CertPath());
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareNotEqual(chain, (Object)callSiteArray[153].call((Object)path))) {
                    String msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[154].call((Object)new GStringImpl(new Object[]{ERROR_CHAIN_NOT_CHAIN}, new String[]{"", ": check that the file is ordered from leaf "}), (Object)"certificate (first) to self-signed certificate (last)."), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                    throw (Throwable)callSiteArray[155].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[156].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
                }
            } else if (ScriptBytecodeAdapter.compareNotEqual(chain, (Object)callSiteArray[157].call((Object)path))) {
                String msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[158].call((Object)new GStringImpl(new Object[]{ERROR_CHAIN_NOT_CHAIN}, new String[]{"", ": check that the file is ordered from leaf "}), (Object)"certificate (first) to self-signed certificate (last)."), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                throw (Throwable)callSiteArray[159].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[160].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
            }
            Set trustAnchors = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[161].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Collections(), callSiteArray[162].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$TrustAnchor(), callSiteArray[163].call(chain, (Object)((Integer)DefaultTypeTransformation.box((int)-1))), null)), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Set());
            X509CertSelector target = (X509CertSelector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$X509CertSelector()), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$X509CertSelector());
            callSiteArray[165].call((Object)target, callSiteArray[166].call(chain, (Object)((Integer)DefaultTypeTransformation.box((int)0))));
            PKIXBuilderParameters validationParams = (PKIXBuilderParameters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[167].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$PKIXBuilderParameters(), (Object)trustAnchors, (Object)target), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$PKIXBuilderParameters());
            callSiteArray[168].call((Object)validationParams, (Object)((Boolean)DefaultTypeTransformation.box((boolean)false)));
            callSiteArray[169].call((Object)pathValidator, (Object)path, (Object)validationParams);
        }
        catch (CertificateException e) {
            callSiteArray[170].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[171].callGetProperty(callSiteArray[172].callGetProperty((Object)e)), callSiteArray[173].callGetProperty((Object)e)}, new String[]{"CertPath creation exception: ", ": ", ""}), (Object)e);
            String msg = (String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{ERROR_CHAIN_NOT_VALID, callSiteArray[174].callGetProperty((Object)e)}, new String[]{"", " ", "."}), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            throw (Throwable)callSiteArray[175].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[176].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()), (Object)e);
        }
        catch (CertPathValidatorException e) {
            callSiteArray[177].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[178].callGetProperty(callSiteArray[179].callGetProperty((Object)e)), callSiteArray[180].callGetProperty((Object)e), callSiteArray[181].callGetProperty((Object)e)}, new String[]{"CertPath validation exception: ", ": ", " (depth = ", ")"}), (Object)e);
            String msg = (String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{ERROR_CHAIN_NOT_VALID, callSiteArray[182].callGetProperty((Object)e)}, new String[]{"", " ", ""}), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[183].callGetProperty((Object)e), (Object)((Integer)DefaultTypeTransformation.box((int)-1)))) {
                    msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].call((Object)msg, (Object)new GStringImpl(new Object[]{callSiteArray[185].call(callSiteArray[186].callGetProperty((Object)e), (Object)((Integer)DefaultTypeTransformation.box((int)1)))}, new String[]{" (at certificate #", ")"})), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                }
            } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[187].callGetProperty((Object)e), (Object)((Integer)DefaultTypeTransformation.box((int)-1)))) {
                msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[188].call((Object)msg, (Object)new GStringImpl(new Object[]{callSiteArray[189].call(callSiteArray[190].callGetProperty((Object)e), (Object)((Integer)DefaultTypeTransformation.box((int)1)))}, new String[]{" (at certificate #", ")"})), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            }
            throw (Throwable)callSiteArray[191].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[192].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()), (Object)e);
        }
    }

    private void verifyValidityPeriod(List<X509Certificate> chain) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        boolean valid = true;
        Date now = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[193].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Date()), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Date());
        callSiteArray[194].call((Object)this.log, callSiteArray[195].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)"Checking certificates validity period.");
        X509Certificate cert = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[196].call(chain), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Iterator());
        while (iterator.hasNext()) {
            cert = (X509Certificate)ScriptBytecodeAdapter.castToType(iterator.next(), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$X509Certificate());
            if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[197].call((Object)now, callSiteArray[198].call((Object)cert)), (Object)((Integer)DefaultTypeTransformation.box((int)0)))) {
                String msg = (String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{callSiteArray[199].callGetProperty((Object)cert)}, new String[]{"The certificate ", " is not yet valid."}), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                throw (Throwable)callSiteArray[200].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[201].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
            }
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[202].call((Object)now, callSiteArray[203].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Date(), callSiteArray[204].call(callSiteArray[205].call(callSiteArray[206].call((Object)cert)), (Object)((Integer)DefaultTypeTransformation.box((int)1)))))))) continue;
            String msg = (String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{callSiteArray[207].callGetProperty((Object)cert)}, new String[]{"The certificate ", " has already expired."}), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            throw (Throwable)callSiteArray[208].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[209].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
        }
    }

    private void verifyKeyLengths(X509Certificate cert) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        callSiteArray[210].call((Object)this.log, callSiteArray[211].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)"Checking the certificates key lengths.");
        PublicKey key = (PublicKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[212].callGetProperty((Object)cert), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$PublicKey());
        if (key instanceof RSAPublicKey) {
            int bitLen = DefaultTypeTransformation.intUnbox((Object)callSiteArray[213].call(callSiteArray[214].callGetProperty((Object)((RSAPublicKey)ScriptBytecodeAdapter.asType((Object)key, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$interfaces$RSAPublicKey())))));
            if (ScriptBytecodeAdapter.compareLessThanEqual((Object)((Integer)DefaultTypeTransformation.box((int)bitLen)), (Object)((Integer)DefaultTypeTransformation.box((int)MIN_KEY_LENGTH)))) {
                String msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[215].call(callSiteArray[216].call((Object)new GStringImpl(new Object[]{callSiteArray[217].callGetProperty((Object)cert)}, new String[]{"Key size of certificate `", "' is too low "}), (Object)new GStringImpl(new Object[]{(Integer)DefaultTypeTransformation.box((int)MIN_KEY_LENGTH)}, new String[]{"(must be greater than ", "). This certificate will not work on up-to-date "})), (Object)new GStringImpl(new Object[]{ENV_SKIP_KEY_LEN_CHECK}, new String[]{"Windows machines. To skip this check, set the environment variable `", "' to 1."})), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                throw (Throwable)callSiteArray[218].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[219].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
            }
        } else {
            callSiteArray[220].call((Object)this.log, callSiteArray[221].call((Object)new GStringImpl(new Object[]{callSiteArray[222].callGetProperty((Object)cert), callSiteArray[223].callGetProperty((Object)key)}, new String[]{"Certificate ", " has non-RSA key (key type is ", "). "}), (Object)"Only RSA keys should be used to ensure maximum interoperability."));
        }
    }

    private void verifySignatureAlgorithms(X509Certificate cert) {
        block1: {
            String weakHash;
            CallSite[] callSiteArray;
            block0: {
                callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
                callSiteArray[224].call((Object)this.log, (Object)"Checking certificates signature algortihm types.");
                weakHash = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[225].call(WEAK_HASHES, callSiteArray[226].call((Object)cert)), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                if (BytecodeInterface8.isOrigZ() && !__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) break block0;
                if (!ScriptBytecodeAdapter.compareNotEqual((Object)weakHash, null)) break block1;
                callSiteArray[227].call((Object)this.log, callSiteArray[228].call((Object)new GStringImpl(new Object[]{callSiteArray[229].callGetProperty((Object)cert), weakHash}, new String[]{"Certificate's `", "' signature uses weak one-way hash (", "). "}), (Object)"In a secure environment it is recommended to use SHA2-256 or a stronger hash algorithm."));
                break block1;
            }
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)weakHash, null)) break block1;
            callSiteArray[230].call((Object)this.log, callSiteArray[231].call((Object)new GStringImpl(new Object[]{callSiteArray[232].callGetProperty((Object)cert), weakHash}, new String[]{"Certificate's `", "' signature uses weak one-way hash (", "). "}), (Object)"In a secure environment it is recommended to use SHA2-256 or a stronger hash algorithm."));
        }
    }

    private void verifySubjectAltNames(X509Certificate cert) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        callSiteArray[233].call((Object)this.log, callSiteArray[234].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)"Checking leaf certificate's suitability for the current machine.");
        X509HostnameVerifier verifier = (X509HostnameVerifier)ScriptBytecodeAdapter.castToType((Object)callSiteArray[235].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$apache$http$conn$ssl$StrictHostnameVerifier()), (Class)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$apache$http$conn$ssl$X509HostnameVerifier());
        List candidateNames = null;
        String matchType = null;
        String hostname = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[236].callCurrent((GroovyObject)this);
            hostname = (String)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        } else {
            String string;
            hostname = string = this.getResolvableHostname();
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)hostname, null)) {
                String string;
                Object object = callSiteArray[237].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Collections(), (Object)hostname);
                candidateNames = (List)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$List());
                matchType = string = "the public";
            } else {
                String string;
                callSiteArray[238].call((Object)this.log, callSiteArray[239].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)"Trying to match leaf certificate's CN/subjectAltNames against machine's IP addresses.");
                Object object = callSiteArray[240].callCurrent((GroovyObject)this);
                candidateNames = (List)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$List());
                matchType = string = "any known IP";
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)hostname, null)) {
            String string;
            Object object = callSiteArray[241].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Collections(), (Object)hostname);
            candidateNames = (List)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$List());
            matchType = string = "the public";
        } else {
            String string;
            List list;
            callSiteArray[242].call((Object)this.log, callSiteArray[243].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$logging$LogConst()), (Object)"Trying to match leaf certificate's CN/subjectAltNames against machine's IP addresses.");
            candidateNames = list = this.getPublicIpAddresses();
            matchType = string = "any known IP";
        }
        boolean success = false;
        String candidate = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[244].call((Object)candidateNames), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Iterator());
        while (iterator.hasNext()) {
            candidate = (String)ScriptBytecodeAdapter.castToType(iterator.next(), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            try {
                boolean bl;
                callSiteArray[245].call((Object)this.log, (Object)new GStringImpl(new Object[]{candidate}, new String[]{"Checking if leaf certificate is suitable for candidate address ", "."}));
                callSiteArray[246].call((Object)verifier, (Object)candidate, (Object)cert);
                success = bl = success || true;
                callSiteArray[247].call((Object)this.log, (Object)new GStringImpl(new Object[]{candidate}, new String[]{"Leaf certificate is suitable for ", ""}));
            }
            catch (SSLException e) {
                callSiteArray[248].call((Object)this.log, (Object)new GStringImpl(new Object[]{candidate, callSiteArray[249].callGetProperty(callSiteArray[250].callGetProperty((Object)e)), callSiteArray[251].callGetProperty((Object)e)}, new String[]{"Leaf certificate not suitable for address ", ": ", " : ", ""}));
            }
        }
        if (!success) {
            String msg = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].call(callSiteArray[253].call((Object)"The leaf certificate doesn't have any CN or subjectAltName that matches ", (Object)new GStringImpl(new Object[]{matchType}, new String[]{"", " address of the current machine. Rejecting the chain. "})), (Object)new GStringImpl(new Object[]{ENV_SKIP_SAN_CHECK}, new String[]{"To skip this check, set the `", "' environment variable to 1."})), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            throw (Throwable)callSiteArray[254].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)msg, callSiteArray[255].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()));
        }
    }

    private boolean certIsSelfSigned(X509Certificate cert) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[256].callGetProperty((Object)cert), (Object)callSiteArray[257].callGetProperty((Object)cert));
        }
        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[258].callGetProperty((Object)cert), (Object)callSiteArray[259].callGetProperty((Object)cert));
    }

    private List<X509Certificate> expandToTrustedChain(List<X509Certificate> chain) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        X509CertSelector target = (X509CertSelector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[260].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$X509CertSelector()), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$X509CertSelector());
        callSiteArray[261].call((Object)target, callSiteArray[262].call(chain, (Object)((Integer)DefaultTypeTransformation.box((int)0))));
        CertPathBuilder pathBuilder = (CertPathBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[263].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CertPathBuilder(), (Object)"PKIX"), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CertPathBuilder());
        PKIXBuilderParameters params = (PKIXBuilderParameters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[264].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$PKIXBuilderParameters(), callSiteArray[265].call(this.systemTrustStore), (Object)target), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$PKIXBuilderParameters());
        CertStore intermediate = (CertStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[266].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CertStore(), (Object)"Collection", callSiteArray[267].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CollectionCertStoreParameters(), chain)), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$CertStore());
        callSiteArray[268].call((Object)params, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{intermediate}));
        callSiteArray[269].call((Object)params, (Object)((Boolean)DefaultTypeTransformation.box((boolean)false)));
        PKIXCertPathBuilderResult built = (PKIXCertPathBuilderResult)ScriptBytecodeAdapter.asType((Object)callSiteArray[270].call((Object)pathBuilder, (Object)params), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$PKIXCertPathBuilderResult());
        List path = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[271].call(callSiteArray[272].callGetProperty(callSiteArray[273].callGetProperty((Object)built)), (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$java$lang$Object;
            private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_expandToTrustedChain_closure3;
            private static /* synthetic */ Class $class$java$security$cert$X509Certificate;
            {
                CallSite[] callSiteArray = _expandToTrustedChain_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _expandToTrustedChain_closure3.$getCallSiteArray();
                return (X509Certificate)ScriptBytecodeAdapter.asType((Object)it, (Class)_expandToTrustedChain_closure3.$get$$class$java$security$cert$X509Certificate());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _expandToTrustedChain_closure3.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper(null, (Class)_expandToTrustedChain_closure3.$get$$class$java$lang$Object()));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _expandToTrustedChain_closure3.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_expandToTrustedChain_closure3()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _expandToTrustedChain_closure3.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _expandToTrustedChain_closure3.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doCall";
                return new CallSiteArray(_expandToTrustedChain_closure3.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_expandToTrustedChain_closure3(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _expandToTrustedChain_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Object() {
                Class clazz = $class$java$lang$Object;
                if (clazz == null) {
                    clazz = $class$java$lang$Object = _expandToTrustedChain_closure3.class$("java.lang.Object");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_expandToTrustedChain_closure3() {
                Class clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_expandToTrustedChain_closure3;
                if (clazz == null) {
                    clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_expandToTrustedChain_closure3 = _expandToTrustedChain_closure3.class$("com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl$_expandToTrustedChain_closure3");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$security$cert$X509Certificate() {
                Class clazz = $class$java$security$cert$X509Certificate;
                if (clazz == null) {
                    clazz = $class$java$security$cert$X509Certificate = _expandToTrustedChain_closure3.class$("java.security.cert.X509Certificate");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$List());
        callSiteArray[274].call((Object)path, callSiteArray[275].callGetProperty(callSiteArray[276].callGetProperty((Object)built)));
        callSiteArray[277].call((Object)this.log, (Object)"Chain was expaned successfully.");
        callSiteArray[278].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[279].call((Object)path)}, new String[]{"New chain size is: ", "."}));
        List list = path;
        try {
            return list;
        }
        catch (CertPathBuilderException e) {
            callSiteArray[280].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[281].callGetProperty((Object)e)}, new String[]{"Exception while expanding incomplete certificate chain: ", ""}), (Object)e);
            throw (Throwable)callSiteArray[282].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)ERROR_CHAIN_EXPAND_FAILED, callSiteArray[283].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()), (Object)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            callSiteArray[284].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[285].callGetProperty((Object)e)}, new String[]{"Cannot create PKIX builder parameters (", "). Possibly empty system-wide trust store."}), (Object)e);
            throw (Throwable)callSiteArray[286].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException(), (Object)ERROR_CHAIN_EXPAND_FAILED, callSiteArray[287].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes()), (Object)e);
        }
    }

    private KeyPair generateKeyPair(int keySize) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        KeyPairGenerator gen = (KeyPairGenerator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[288].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$KeyPairGenerator(), (Object)"RSA"), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$KeyPairGenerator());
        callSiteArray[289].call((Object)gen, (Object)((Integer)DefaultTypeTransformation.box((int)keySize)));
        return (KeyPair)ScriptBytecodeAdapter.castToType((Object)callSiteArray[290].call((Object)gen), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$KeyPair());
    }

    private ServerSslConfig createRootCertificate(Date startDate, int validityDays) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        callSiteArray[291].call((Object)this.log, (Object)"Creating the self-signed root certificate (key size = {})", (Object)((Integer)DefaultTypeTransformation.box((int)GEN_ROOT_KEY_SIZE)));
        KeyPair rootPair = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[292].callCurrent((GroovyObject)this, (Object)((Integer)DefaultTypeTransformation.box((int)GEN_ROOT_KEY_SIZE)));
            rootPair = (KeyPair)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$KeyPair());
        } else {
            KeyPair keyPair;
            rootPair = keyPair = this.generateKeyPair(GEN_ROOT_KEY_SIZE);
        }
        X500Principal subject = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[293].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$javax$security$auth$x500$X500Principal(), callSiteArray[294].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$String(), (Object)GEN_ROOT_SUBJECT, callSiteArray[295].callCurrent((GroovyObject)this)));
            subject = (X500Principal)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$javax$security$auth$x500$X500Principal());
        } else {
            Object object = callSiteArray[296].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$javax$security$auth$x500$X500Principal(), callSiteArray[297].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$String(), (Object)GEN_ROOT_SUBJECT, (Object)this.createNonce()));
            subject = (X500Principal)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$javax$security$auth$x500$X500Principal());
        }
        BigInteger serial = (BigInteger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[298].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$math$BigInteger(), (Object)((Integer)DefaultTypeTransformation.box((int)1))), (Class)ServerSslConfigFactoryImpl.$get$$class$java$math$BigInteger());
        X509v3CertificateBuilder cb = (X509v3CertificateBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[299].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$cert$jcajce$JcaX509v3CertificateBuilder(), ArrayUtil.createArray((Object)subject, (Object)serial, (Object)startDate, (Object)callSiteArray[300].callCurrent((GroovyObject)this, (Object)startDate, (Object)((Integer)DefaultTypeTransformation.box((int)validityDays))), (Object)subject, (Object)callSiteArray[301].callGetProperty((Object)rootPair))), (Class)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$cert$X509v3CertificateBuilder());
        callSiteArray[302].call((Object)cb, callSiteArray[303].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$X509Extension()), (Object)((Boolean)DefaultTypeTransformation.box((boolean)true)), callSiteArray[304].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$BasicConstraints(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)true))));
        callSiteArray[305].call((Object)cb, callSiteArray[306].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$X509Extension()), (Object)((Boolean)DefaultTypeTransformation.box((boolean)false)), callSiteArray[307].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$KeyUsage(), callSiteArray[308].call(callSiteArray[309].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$KeyUsage()), callSiteArray[310].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$KeyUsage()))));
        X509Certificate rootCert = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[311].call(callSiteArray[312].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$cert$jcajce$JcaX509CertificateConverter()), callSiteArray[313].call((Object)cb, callSiteArray[314].call(callSiteArray[315].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$operator$jcajce$JcaContentSignerBuilder(), (Object)"SHA512WithRSA"), callSiteArray[316].callGetProperty((Object)rootPair)))), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$X509Certificate());
        return (ServerSslConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[317].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfig(), callSiteArray[318].callGetProperty((Object)rootPair), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{rootCert})), (Class)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfig());
    }

    private ServerSslConfig createLeafCertificate(ServerSslConfig root, String ou, Date startDate, int validityDays, String hostname) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        callSiteArray[319].call((Object)this.log, (Object)"Creating the leaf certificate (key size = {})", (Object)((Integer)DefaultTypeTransformation.box((int)GEN_LEAF_KEY_SIZE)));
        KeyPair leafPair = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[320].callCurrent((GroovyObject)this, (Object)((Integer)DefaultTypeTransformation.box((int)GEN_LEAF_KEY_SIZE)));
            leafPair = (KeyPair)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$KeyPair());
        } else {
            KeyPair keyPair;
            leafPair = keyPair = this.generateKeyPair(GEN_LEAF_KEY_SIZE);
        }
        X500Principal subject = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[321].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$javax$security$auth$x500$X500Principal(), callSiteArray[322].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$String(), (Object)GEN_LEAF_SUBJECT, callSiteArray[323].callCurrent((GroovyObject)this), callSiteArray[324].callCurrent((GroovyObject)this, (Object)hostname), (Object)ou));
            subject = (X500Principal)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$javax$security$auth$x500$X500Principal());
        } else {
            Object object = callSiteArray[325].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$javax$security$auth$x500$X500Principal(), callSiteArray[326].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$String(), (Object)GEN_LEAF_SUBJECT, (Object)this.createUnstructuredName(), (Object)this.getLocalHostname(hostname), (Object)ou));
            subject = (X500Principal)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$javax$security$auth$x500$X500Principal());
        }
        BigInteger serial = (BigInteger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[327].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$math$BigInteger(), callSiteArray[328].call(callSiteArray[329].call(callSiteArray[330].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$SecureRandom()), (Object)((Integer)DefaultTypeTransformation.box((int)65534))), (Object)((Integer)DefaultTypeTransformation.box((int)1)))), (Class)ServerSslConfigFactoryImpl.$get$$class$java$math$BigInteger());
        X509v3CertificateBuilder cb = (X509v3CertificateBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[331].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$cert$jcajce$JcaX509v3CertificateBuilder(), ArrayUtil.createArray((Object)callSiteArray[332].call(callSiteArray[333].callGetProperty((Object)root), (Object)((Integer)DefaultTypeTransformation.box((int)0))), (Object)serial, (Object)startDate, (Object)callSiteArray[334].callCurrent((GroovyObject)this, (Object)startDate, (Object)((Integer)DefaultTypeTransformation.box((int)validityDays))), (Object)subject, (Object)callSiteArray[335].callGetProperty((Object)leafPair))), (Class)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$cert$X509v3CertificateBuilder());
        callSiteArray[336].call((Object)cb, callSiteArray[337].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$X509Extension()), (Object)((Boolean)DefaultTypeTransformation.box((boolean)true)), callSiteArray[338].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$BasicConstraints(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)false))));
        callSiteArray[339].call((Object)cb, callSiteArray[340].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$X509Extension()), (Object)((Boolean)DefaultTypeTransformation.box((boolean)false)), callSiteArray[341].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$KeyUsage(), callSiteArray[342].call(callSiteArray[343].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$KeyUsage()), callSiteArray[344].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$KeyUsage()))));
        callSiteArray[345].call((Object)cb, callSiteArray[346].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$X509Extension()), (Object)((Boolean)DefaultTypeTransformation.box((boolean)false)), callSiteArray[347].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$ExtendedKeyUsage(), callSiteArray[348].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$KeyPurposeId())));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[349].call((Object)cb, callSiteArray[350].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$X509Extension()), (Object)((Boolean)DefaultTypeTransformation.box((boolean)false)), callSiteArray[351].callCurrent((GroovyObject)this, (Object)hostname));
        } else {
            callSiteArray[352].call((Object)cb, callSiteArray[353].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$X509Extension()), (Object)((Boolean)DefaultTypeTransformation.box((boolean)false)), (Object)this.createSubjectAltNames(hostname));
        }
        X509Certificate leafCert = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[354].call(callSiteArray[355].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$cert$jcajce$JcaX509CertificateConverter()), callSiteArray[356].call((Object)cb, callSiteArray[357].call(callSiteArray[358].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$operator$jcajce$JcaContentSignerBuilder(), (Object)"SHA512WithRSA"), callSiteArray[359].callGetProperty((Object)root)))), (Class)ServerSslConfigFactoryImpl.$get$$class$java$security$cert$X509Certificate());
        return (ServerSslConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[360].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfig(), callSiteArray[361].callGetProperty((Object)leafPair), callSiteArray[362].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{leafCert}), callSiteArray[363].callGetProperty((Object)root))), (Class)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$ServerSslConfig());
    }

    private Date getEndDate(Date startDate, int validityDays) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        Calendar endDate = (Calendar)ScriptBytecodeAdapter.castToType((Object)callSiteArray[364].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Calendar(), callSiteArray[365].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$TimeZone(), (Object)"GMT")), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Calendar());
        callSiteArray[366].call((Object)endDate, (Object)startDate);
        callSiteArray[367].call((Object)endDate, callSiteArray[368].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Calendar()), (Object)((Integer)DefaultTypeTransformation.box((int)validityDays)));
        return (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[369].call((Object)endDate), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Date());
    }

    private List<String> getPublicIpAddresses() {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        Reference ips = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        List ifaces = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[370].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$Collections(), callSiteArray[371].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$net$NetworkInterface())), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$List());
        callSiteArray[372].call((Object)ifaces, (Object)new GeneratedClosure(this, this, ips){
            private /* synthetic */ Reference ips;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4;
            private static /* synthetic */ Class $class$java$util$List;
            {
                Reference reference;
                CallSite[] callSiteArray = _getPublicIpAddresses_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.ips = reference = ips;
            }

            public Object doCall(NetworkInterface iface) {
                CallSite[] callSiteArray = _getPublicIpAddresses_closure4.$getCallSiteArray();
                List addresses = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call((Object)iface), (Class)_getPublicIpAddresses_closure4.$get$$class$java$util$List());
                return callSiteArray[1].call(callSiteArray[2].call((Object)addresses, (Object)new GeneratedClosure((Object)this, this.getThisObject()){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    private static /* synthetic */ Class $class$java$lang$Object;
                    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl;
                    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure6;
                    {
                        CallSite[] callSiteArray = _getPublicIpAddresses_closure4_closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _getPublicIpAddresses_closure4_closure6.$getCallSiteArray();
                        return callSiteArray[0].callStatic(_getPublicIpAddresses_closure4_closure6.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl(), callSiteArray[1].callGetProperty(it));
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _getPublicIpAddresses_closure4_closure6.$getCallSiteArray();
                        return callSiteArray[2].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper(null, (Class)_getPublicIpAddresses_closure4_closure6.$get$$class$java$lang$Object()));
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getPublicIpAddresses_closure4_closure6.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure6()) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                        CallSite[] callSiteArray = _getPublicIpAddresses_closure4_closure6.$getCallSiteArray();
                        $callSiteArray = null;
                    }

                    static {
                        _getPublicIpAddresses_closure4_closure6.__$swapInit();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "isPublicAddress";
                        stringArray[1] = "address";
                        stringArray[2] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _getPublicIpAddresses_closure4_closure6.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_getPublicIpAddresses_closure4_closure6.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure6(), stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getPublicIpAddresses_closure4_closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    private static /* synthetic */ Class $get$$class$java$lang$Object() {
                        Class clazz = $class$java$lang$Object;
                        if (clazz == null) {
                            clazz = $class$java$lang$Object = _getPublicIpAddresses_closure4_closure6.class$("java.lang.Object");
                        }
                        return clazz;
                    }

                    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl() {
                        Class clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl;
                        if (clazz == null) {
                            clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl = _getPublicIpAddresses_closure4_closure6.class$("com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl");
                        }
                        return clazz;
                    }

                    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure6() {
                        Class clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure6;
                        if (clazz == null) {
                            clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure6 = _getPublicIpAddresses_closure4_closure6.class$("com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure6");
                        }
                        return clazz;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }), (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.ips){
                    private /* synthetic */ Reference ips;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    private static /* synthetic */ Class $class$java$util$List;
                    private static /* synthetic */ Class $class$java$lang$String;
                    private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure7;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _getPublicIpAddresses_closure4_closure7.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.ips = reference = ips;
                    }

                    public Object doCall(InterfaceAddress addr) {
                        CallSite[] callSiteArray = _getPublicIpAddresses_closure4_closure7.$getCallSiteArray();
                        String hostAddress = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)addr)), (Class)_getPublicIpAddresses_closure4_closure7.$get$$class$java$lang$String());
                        return callSiteArray[2].call(this.ips.get(), (Object)hostAddress);
                    }

                    public Object call(InterfaceAddress addr) {
                        CallSite[] callSiteArray = _getPublicIpAddresses_closure4_closure7.$getCallSiteArray();
                        return callSiteArray[3].callCurrent((GroovyObject)this, (Object)addr);
                    }

                    public List getIps() {
                        CallSite[] callSiteArray = _getPublicIpAddresses_closure4_closure7.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.ips.get(), (Class)_getPublicIpAddresses_closure4_closure7.$get$$class$java$util$List());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getPublicIpAddresses_closure4_closure7.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure7()) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                        CallSite[] callSiteArray = _getPublicIpAddresses_closure4_closure7.$getCallSiteArray();
                        $callSiteArray = null;
                    }

                    static {
                        _getPublicIpAddresses_closure4_closure7.__$swapInit();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "hostAddress";
                        stringArray[1] = "address";
                        stringArray[2] = "add";
                        stringArray[3] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _getPublicIpAddresses_closure4_closure7.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_getPublicIpAddresses_closure4_closure7.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure7(), stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getPublicIpAddresses_closure4_closure7.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    private static /* synthetic */ Class $get$$class$java$util$List() {
                        Class clazz = $class$java$util$List;
                        if (clazz == null) {
                            clazz = $class$java$util$List = _getPublicIpAddresses_closure4_closure7.class$("java.util.List");
                        }
                        return clazz;
                    }

                    private static /* synthetic */ Class $get$$class$java$lang$String() {
                        Class clazz = $class$java$lang$String;
                        if (clazz == null) {
                            clazz = $class$java$lang$String = _getPublicIpAddresses_closure4_closure7.class$("java.lang.String");
                        }
                        return clazz;
                    }

                    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure7() {
                        Class clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure7;
                        if (clazz == null) {
                            clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure7 = _getPublicIpAddresses_closure4_closure7.class$("com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4_closure7");
                        }
                        return clazz;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }

            public Object call(NetworkInterface iface) {
                CallSite[] callSiteArray = _getPublicIpAddresses_closure4.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, (Object)iface);
            }

            public List getIps() {
                CallSite[] callSiteArray = _getPublicIpAddresses_closure4.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.ips.get(), (Class)_getPublicIpAddresses_closure4.$get$$class$java$util$List());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPublicIpAddresses_closure4.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _getPublicIpAddresses_closure4.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _getPublicIpAddresses_closure4.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getInterfaceAddresses";
                stringArray[1] = "each";
                stringArray[2] = "findAll";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _getPublicIpAddresses_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getPublicIpAddresses_closure4.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPublicIpAddresses_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4() {
                Class clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4;
                if (clazz == null) {
                    clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4 = _getPublicIpAddresses_closure4.class$("com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl$_getPublicIpAddresses_closure4");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$List() {
                Class clazz = $class$java$util$List;
                if (clazz == null) {
                    clazz = $class$java$util$List = _getPublicIpAddresses_closure4.class$("java.util.List");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        return (List)ips.get();
    }

    private String getResolvableHostname() {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        String hostname = null;
        try {
            String localhost = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[373].call(callSiteArray[374].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$net$InetAddress())), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            callSiteArray[375].call((Object)this.log, (Object)new GStringImpl(new Object[]{localhost}, new String[]{"Machine's FQHN: ", ""}));
            String string = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[376].call((Object)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$impl$DNSResolver(), (Object)localhost)) ? localhost : null;
            hostname = (String)ScriptBytecodeAdapter.castToType((Object)string, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        }
        catch (UnknownHostException e) {
            Object var6_6 = null;
            hostname = (String)ScriptBytecodeAdapter.castToType(var6_6, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)hostname, null)) {
                callSiteArray[377].call((Object)this.log, (Object)"The host name of this machine cannot be resolved against the configured DNS servers.");
                callSiteArray[378].call((Object)this.log, (Object)"Having a resolvable host name is a requirement for installing the VMware vSphere services.");
                callSiteArray[379].call((Object)this.log, (Object)"The operation will continues on a best effort basis, but false negative (or positive) results are possible.");
                callSiteArray[380].call((Object)this.log, (Object)"Review the `Prerequisites for Installing vCenter Server' secion in the vSphere Documentation Center.");
            } else {
                callSiteArray[381].call((Object)this.log, (Object)new GStringImpl(new Object[]{hostname}, new String[]{"Machine has a resolvable hostname: ", ""}));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)hostname, null)) {
            callSiteArray[382].call((Object)this.log, (Object)"The host name of this machine cannot be resolved against the configured DNS servers.");
            callSiteArray[383].call((Object)this.log, (Object)"Having a resolvable host name is a requirement for installing the VMware vSphere services.");
            callSiteArray[384].call((Object)this.log, (Object)"The operation will continues on a best effort basis, but false negative (or positive) results are possible.");
            callSiteArray[385].call((Object)this.log, (Object)"Review the `Prerequisites for Installing vCenter Server' secion in the vSphere Documentation Center.");
        } else {
            callSiteArray[386].call((Object)this.log, (Object)new GStringImpl(new Object[]{hostname}, new String[]{"Machine has a resolvable hostname: ", ""}));
        }
        return hostname;
    }

    private String getLocalHostname(String defaultName) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        String name = null;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)defaultName, null)) {
                String string;
                name = string = defaultName;
            } else {
                try {
                    Object object = callSiteArray[387].call(callSiteArray[388].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$net$InetAddress()));
                    name = (String)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                }
                catch (UnknownHostException e) {
                    String string;
                    callSiteArray[389].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[390].callGetProperty((Object)e)}, new String[]{"Cannot automatically retrieve machine's hostname: ", ". This may lead to further problems."}));
                    callSiteArray[391].call((Object)this.log, (Object)"", (Object)e);
                    name = string = "localhost.localdom";
                }
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)defaultName, null)) {
            String string;
            name = string = defaultName;
        } else {
            try {
                Object object = callSiteArray[392].call(callSiteArray[393].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$net$InetAddress()));
                name = (String)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
            }
            catch (UnknownHostException e) {
                String string;
                callSiteArray[394].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[395].callGetProperty((Object)e)}, new String[]{"Cannot automatically retrieve machine's hostname: ", ". This may lead to further problems."}));
                callSiteArray[396].call((Object)this.log, (Object)"", (Object)e);
                name = string = "localhost.localdom";
            }
        }
        return name;
    }

    private String createNonce() {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        String nonce = null;
        Random rnd = (Random)ScriptBytecodeAdapter.castToType((Object)callSiteArray[397].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$security$SecureRandom()), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Random());
        byte[] nonceBytes = new byte[6];
        callSiteArray[398].call((Object)rnd, (Object)nonceBytes);
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[399].call(callSiteArray[400].call((Object)nonceBytes, (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_createNonce_closure5;
            {
                CallSite[] callSiteArray = _createNonce_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(byte b) {
                CallSite[] callSiteArray = _createNonce_closure5.$getCallSiteArray();
                return callSiteArray[0].call((Object)_createNonce_closure5.$get$$class$java$lang$String(), (Object)"%02x", (Object)((Byte)DefaultTypeTransformation.box((byte)b)));
            }

            public Object call(byte b) {
                CallSite[] callSiteArray = _createNonce_closure5.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)((Byte)DefaultTypeTransformation.box((byte)b)));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createNonce_closure5.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_createNonce_closure5()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _createNonce_closure5.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _createNonce_closure5.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "format";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _createNonce_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createNonce_closure5.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_createNonce_closure5(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createNonce_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = _createNonce_closure5.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_createNonce_closure5() {
                Class clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_createNonce_closure5;
                if (clazz == null) {
                    clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl$_createNonce_closure5 = _createNonce_closure5.class$("com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl$_createNonce_closure5");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Object)""), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
    }

    private String createUnstructuredName() {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[401].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$String(), (Object)"%d\\,%s", callSiteArray[402].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$System()), callSiteArray[403].callCurrent((GroovyObject)this)), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        }
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[404].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$String(), (Object)"%d\\,%s", callSiteArray[405].call((Object)ServerSslConfigFactoryImpl.$get$$class$java$lang$System()), (Object)this.createNonce()), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
    }

    private GeneralNames createSubjectAltNames(String hostname) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        List names = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            String addr = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[406].call(callSiteArray[407].callCurrent((GroovyObject)this)), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Iterator());
            while (iterator.hasNext()) {
                addr = (String)ScriptBytecodeAdapter.castToType(iterator.next(), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                callSiteArray[408].call((Object)this.log, (Object)new GStringImpl(new Object[]{addr}, new String[]{"Adding SubjectAltName IP:", ""}));
                callSiteArray[409].call((Object)names, callSiteArray[410].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName(), callSiteArray[411].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName()), (Object)addr));
            }
        } else {
            String addr = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[412].call(this.getPublicIpAddresses()), (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Iterator());
            while (iterator.hasNext()) {
                addr = (String)ScriptBytecodeAdapter.castToType(iterator.next(), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
                callSiteArray[413].call((Object)this.log, (Object)new GStringImpl(new Object[]{addr}, new String[]{"Adding SubjectAltName IP:", ""}));
                callSiteArray[414].call((Object)names, callSiteArray[415].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName(), callSiteArray[416].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName()), (Object)addr));
            }
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)hostname, null)) {
                callSiteArray[417].call((Object)this.log, (Object)new GStringImpl(new Object[]{hostname}, new String[]{"Adding SubjectAltName DNS:", ""}));
                callSiteArray[418].call((Object)names, callSiteArray[419].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName(), callSiteArray[420].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName()), (Object)hostname));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)hostname, null)) {
            callSiteArray[421].call((Object)this.log, (Object)new GStringImpl(new Object[]{hostname}, new String[]{"Adding SubjectAltName DNS:", ""}));
            callSiteArray[422].call((Object)names, callSiteArray[423].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName(), callSiteArray[424].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName()), (Object)hostname));
        }
        String localhost = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[425].callCurrent((GroovyObject)this, null), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        callSiteArray[426].call((Object)this.log, (Object)new GStringImpl(new Object[]{localhost}, new String[]{"Adding SubjectAltName DNS:", ""}));
        callSiteArray[427].call((Object)names, callSiteArray[428].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName(), callSiteArray[429].callGetProperty((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralName()), (Object)localhost));
        return (GeneralNames)ScriptBytecodeAdapter.castToType((Object)callSiteArray[430].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralNames(), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((GeneralName[])ScriptBytecodeAdapter.asType((Object)names, (Class)ServerSslConfigFactoryImpl.$get$array$$class$org$bouncycastle$asn1$x509$GeneralName())), (Class)ServerSslConfigFactoryImpl.$get$array$$class$org$bouncycastle$asn1$x509$GeneralName())), (Class)ServerSslConfigFactoryImpl.$get$$class$org$bouncycastle$asn1$x509$GeneralNames());
    }

    private static boolean isPublicAddress(InetAddress addr) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return !(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[431].call((Object)addr)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[432].call((Object)addr)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[433].call((Object)addr)));
        }
        return !(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[434].call((Object)addr)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[435].call((Object)addr)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[436].call((Object)addr)));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String())));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField((Class)ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String())));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl()) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = ServerSslConfigFactoryImpl.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        ServerSslConfigFactoryImpl.__$swapInit();
        Long l = (Long)DefaultTypeTransformation.box((long)0L);
        __timeStamp__239_neverHappen1378297898781 = l;
        Long l2 = (Long)DefaultTypeTransformation.box((long)1378297898781L);
        __timeStamp = l2;
        GStringImpl gStringImpl = new GStringImpl(new Object[]{ERROR_CHAIN_NOT_CHAIN}, new String[]{"", ". PKIX path validation failed with:"});
        ERROR_CHAIN_NOT_VALID = (String)ScriptBytecodeAdapter.castToType((Object)gStringImpl, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        Object object = ServerSslConfigFactoryImpl.$getCallSiteArray()[437].call(ServerSslConfigFactoryImpl.$getCallSiteArray()[438].call((Object)"Certificate chain is incomplete: the root ", (Object)"authority certificate is not present and cannot be detected automatically. The presence of the root "), (Object)"certificate is required so the other service can establish trust to this service. Try adding the authority certificate manually.");
        ERROR_CHAIN_EXPAND_FAILED = (String)ScriptBytecodeAdapter.castToType((Object)object, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        Object object2 = ServerSslConfigFactoryImpl.$getCallSiteArray()[439].call((Object)"The certificate chain file cannot be decoded. The file is ", (Object)"either corrupt or contains an unsupported object type.");
        ERROR_CHAIN_CORRUPT = (String)ScriptBytecodeAdapter.castToType((Object)object2, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        Object object3 = ServerSslConfigFactoryImpl.$getCallSiteArray()[440].call((Object)"EMail=ssl-certificates@vmware.com, ", (Object)"CN=SSL Updater Auto Autority %s, O=VMware\\, Inc., L=Palo Alto, ST=California, C=US");
        GEN_ROOT_SUBJECT = (String)ScriptBytecodeAdapter.castToType((Object)object3, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        Object object4 = ServerSslConfigFactoryImpl.$getCallSiteArray()[441].call((Object)"OID.1.2.840.113549.1.9.2=%s, ", (Object)"CN = %s, OU=VMware %s Certificate, O=VMware\\, Inc., L=Palo Alto, ST=California, C=US");
        GEN_LEAF_SUBJECT = (String)ScriptBytecodeAdapter.castToType((Object)object4, (Class)ServerSslConfigFactoryImpl.$get$$class$java$lang$String());
        Object object5 = ServerSslConfigFactoryImpl.$getCallSiteArray()[442].callConstructor((Object)ServerSslConfigFactoryImpl.$get$$class$java$util$HashMap());
        WEAK_HASHES = (Map)ScriptBytecodeAdapter.castToType((Object)object5, (Class)ServerSslConfigFactoryImpl.$get$$class$java$util$Map());
    }

    public /* synthetic */ PrivateKey this$2$loadKeyFile(File file) {
        return this.loadKeyFile(file);
    }

    public /* synthetic */ List this$2$loadCertChain(File file) {
        return this.loadCertChain(file);
    }

    public /* synthetic */ List this$2$loadCertChainFromStream(Reader reader) {
        return this.loadCertChainFromStream(reader);
    }

    public /* synthetic */ boolean this$2$keyPairMatch(PrivateKey privateKey, PublicKey publicKey) {
        return this.keyPairMatch(privateKey, publicKey);
    }

    public /* synthetic */ void this$2$verifyChainFileIsClean(Reader reader) {
        this.verifyChainFileIsClean(reader);
    }

    public /* synthetic */ boolean this$2$pemIsClean(Reader reader, String string) {
        return this.pemIsClean(reader, string);
    }

    public /* synthetic */ void this$2$validateChainIsChain(List list) {
        this.validateChainIsChain(list);
    }

    public /* synthetic */ void this$2$verifyValidityPeriod(List list) {
        this.verifyValidityPeriod(list);
    }

    public /* synthetic */ void this$2$verifyKeyLengths(X509Certificate x509Certificate) {
        this.verifyKeyLengths(x509Certificate);
    }

    public /* synthetic */ void this$2$verifySignatureAlgorithms(X509Certificate x509Certificate) {
        this.verifySignatureAlgorithms(x509Certificate);
    }

    public /* synthetic */ void this$2$verifySubjectAltNames(X509Certificate x509Certificate) {
        this.verifySubjectAltNames(x509Certificate);
    }

    public /* synthetic */ boolean this$2$certIsSelfSigned(X509Certificate x509Certificate) {
        return this.certIsSelfSigned(x509Certificate);
    }

    public /* synthetic */ List this$2$expandToTrustedChain(List list) {
        return this.expandToTrustedChain(list);
    }

    public /* synthetic */ KeyPair this$2$generateKeyPair(int n) {
        return this.generateKeyPair(n);
    }

    public /* synthetic */ ServerSslConfig this$2$createRootCertificate(Date date, int n) {
        return this.createRootCertificate(date, n);
    }

    public /* synthetic */ ServerSslConfig this$2$createLeafCertificate(ServerSslConfig serverSslConfig, String string, Date date, int n, String string2) {
        return this.createLeafCertificate(serverSslConfig, string, date, n, string2);
    }

    public /* synthetic */ Date this$2$getEndDate(Date date, int n) {
        return this.getEndDate(date, n);
    }

    public /* synthetic */ List this$2$getPublicIpAddresses() {
        return this.getPublicIpAddresses();
    }

    public /* synthetic */ String this$2$getResolvableHostname() {
        return this.getResolvableHostname();
    }

    public /* synthetic */ String this$2$getLocalHostname(String string) {
        return this.getLocalHostname(string);
    }

    public /* synthetic */ String this$2$createNonce() {
        return this.createNonce();
    }

    public /* synthetic */ String this$2$createUnstructuredName() {
        return this.createUnstructuredName();
    }

    public /* synthetic */ GeneralNames this$2$createSubjectAltNames(String string) {
        return this.createSubjectAltNames(string);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getLogger";
        stringArray[1] = "class";
        stringArray[2] = "put";
        stringArray[3] = "put";
        stringArray[4] = "put";
        stringArray[5] = "put";
        stringArray[6] = "loadKeyFile";
        stringArray[7] = "loadCertChain";
        stringArray[8] = "first";
        stringArray[9] = "keyPairMatch";
        stringArray[10] = "publicKey";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "KeyLeafMismatch";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "info";
        stringArray[15] = "getInstance";
        stringArray[16] = "getTimeZone";
        stringArray[17] = "add";
        stringArray[18] = "HOUR";
        stringArray[19] = "getTime";
        stringArray[20] = "multiply";
        stringArray[21] = "createRootCertificate";
        stringArray[22] = "createLeafCertificate";
        stringArray[23] = "info";
        stringArray[24] = "MARK_VERBOSE";
        stringArray[25] = "absolutePath";
        stringArray[26] = "withReader";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "EmptyKeyFile";
        stringArray[29] = "privateKey";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "debug";
        stringArray[33] = "name";
        stringArray[34] = "class";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "KeyFileContainsNonKey";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "EmptyKeyFile";
        stringArray[39] = "privateKey";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "debug";
        stringArray[43] = "name";
        stringArray[44] = "class";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "KeyFileContainsNonKey";
        stringArray[47] = "absolutePath";
        stringArray[48] = "message";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "LoadKeyFileError";
        stringArray[51] = "info";
        stringArray[52] = "MARK_VERBOSE";
        stringArray[53] = "absolutePath";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "verifyChainFileIsClean";
        stringArray[57] = "loadCertChainFromStream";
        stringArray[58] = "closeQuietly";
        stringArray[59] = "closeQuietly";
        stringArray[60] = "closeQuietly";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "readObject";
        stringArray[64] = "info";
        stringArray[65] = "MARK_VERBOSE";
        stringArray[66] = "subjectX500Principal";
        stringArray[67] = "add";
        stringArray[68] = "debug";
        stringArray[69] = "message";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "LoadChainFileError";
        stringArray[72] = "debug";
        stringArray[73] = "message";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "LoadChainFileError";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "ChainContainsNonCert";
        stringArray[78] = "empty";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "EmptyChain";
        stringArray[81] = "info";
        stringArray[82] = "MARK_VERBOSE";
        stringArray[83] = "size";
        stringArray[84] = "certIsSelfSigned";
        stringArray[85] = "getAt";
        stringArray[86] = "debug";
        stringArray[87] = "expandToTrustedChain";
        stringArray[88] = "validateChainIsChain";
        stringArray[89] = "infoEnabled";
        stringArray[90] = "info";
        stringArray[91] = "MARK_VERBOSE";
        stringArray[92] = "eachWithIndex";
        stringArray[93] = "verifyValidityPeriod";
        stringArray[94] = "getenv";
        stringArray[95] = "verifySubjectAltNames";
        stringArray[96] = "getAt";
        stringArray[97] = "info";
        stringArray[98] = "MARK_VERBOSE";
        stringArray[99] = "getenv";
        stringArray[100] = "verifySubjectAltNames";
        stringArray[101] = "getAt";
        stringArray[102] = "info";
        stringArray[103] = "MARK_VERBOSE";
        stringArray[104] = "getenv";
        stringArray[105] = "verifyKeyLengths";
        stringArray[106] = "getAt";
        stringArray[107] = "info";
        stringArray[108] = "MARK_VERBOSE";
        stringArray[109] = "getenv";
        stringArray[110] = "verifyKeyLengths";
        stringArray[111] = "getAt";
        stringArray[112] = "info";
        stringArray[113] = "MARK_VERBOSE";
        stringArray[114] = "verifySignatureAlgorithms";
        stringArray[115] = "getAt";
        stringArray[116] = "algorithm";
        stringArray[117] = "algorithm";
        stringArray[118] = "publicExponent";
        stringArray[119] = "publicExponent";
        stringArray[120] = "modulus";
        stringArray[121] = "modulus";
        stringArray[122] = "algorithm";
        stringArray[123] = "algorithm";
        stringArray[124] = "publicExponent";
        stringArray[125] = "publicExponent";
        stringArray[126] = "modulus";
        stringArray[127] = "modulus";
        stringArray[128] = "getenv";
        stringArray[129] = "info";
        stringArray[130] = "MARK_VERBOSE";
        stringArray[131] = "pemIsClean";
        stringArray[132] = "plus";
        stringArray[133] = "plus";
        stringArray[134] = "<$constructor$>";
        stringArray[135] = "ChainFileNotClean";
        stringArray[136] = "getenv";
        stringArray[137] = "info";
        stringArray[138] = "MARK_VERBOSE";
        stringArray[139] = "pemIsClean";
        stringArray[140] = "plus";
        stringArray[141] = "plus";
        stringArray[142] = "<$constructor$>";
        stringArray[143] = "ChainFileNotClean";
        stringArray[144] = "length";
        stringArray[145] = "mark";
        stringArray[146] = "read";
        stringArray[147] = "reset";
        stringArray[148] = "equals";
        stringArray[149] = "<$constructor$>";
        stringArray[150] = "getInstance";
        stringArray[151] = "getInstance";
        stringArray[152] = "generateCertPath";
        stringArray[153] = "getCertificates";
        stringArray[154] = "plus";
        stringArray[155] = "<$constructor$>";
        stringArray[156] = "ChainNotAChain";
        stringArray[157] = "getCertificates";
        stringArray[158] = "plus";
        stringArray[159] = "<$constructor$>";
        stringArray[160] = "ChainNotAChain";
        stringArray[161] = "singleton";
        stringArray[162] = "<$constructor$>";
        stringArray[163] = "getAt";
        stringArray[164] = "<$constructor$>";
        stringArray[165] = "setCertificate";
        stringArray[166] = "getAt";
        stringArray[167] = "<$constructor$>";
        stringArray[168] = "setRevocationEnabled";
        stringArray[169] = "validate";
        stringArray[170] = "debug";
        stringArray[171] = "name";
        stringArray[172] = "class";
        stringArray[173] = "message";
        stringArray[174] = "message";
        stringArray[175] = "<$constructor$>";
        stringArray[176] = "ChainNotAChain";
        stringArray[177] = "debug";
        stringArray[178] = "name";
        stringArray[179] = "class";
        stringArray[180] = "message";
        stringArray[181] = "index";
        stringArray[182] = "message";
        stringArray[183] = "index";
        stringArray[184] = "plus";
        stringArray[185] = "plus";
        stringArray[186] = "index";
        stringArray[187] = "index";
        stringArray[188] = "plus";
        stringArray[189] = "plus";
        stringArray[190] = "index";
        stringArray[191] = "<$constructor$>";
        stringArray[192] = "ChainNotAChain";
        stringArray[193] = "<$constructor$>";
        stringArray[194] = "info";
        stringArray[195] = "MARK_VERBOSE";
        stringArray[196] = "iterator";
        stringArray[197] = "compareTo";
        stringArray[198] = "getNotBefore";
        stringArray[199] = "subjectX500Principal";
        stringArray[200] = "<$constructor$>";
        stringArray[201] = "CertificateValidityPeriod";
        stringArray[202] = "before";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "plus";
        stringArray[205] = "getTime";
        stringArray[206] = "getNotAfter";
        stringArray[207] = "subjectX500Principal";
        stringArray[208] = "<$constructor$>";
        stringArray[209] = "CertificateValidityPeriod";
        stringArray[210] = "info";
        stringArray[211] = "MARK_VERBOSE";
        stringArray[212] = "publicKey";
        stringArray[213] = "bitLength";
        stringArray[214] = "modulus";
        stringArray[215] = "plus";
        stringArray[216] = "plus";
        stringArray[217] = "subjectX500Principal";
        stringArray[218] = "<$constructor$>";
        stringArray[219] = "CertificateKeySize";
        stringArray[220] = "warn";
        stringArray[221] = "plus";
        stringArray[222] = "subjectX500Principal";
        stringArray[223] = "algorithm";
        stringArray[224] = "debug";
        stringArray[225] = "get";
        stringArray[226] = "getSigAlgOID";
        stringArray[227] = "warn";
        stringArray[228] = "plus";
        stringArray[229] = "subjectX500Principal";
        stringArray[230] = "warn";
        stringArray[231] = "plus";
        stringArray[232] = "subjectX500Principal";
        stringArray[233] = "info";
        stringArray[234] = "MARK_VERBOSE";
        stringArray[235] = "<$constructor$>";
        stringArray[236] = "getResolvableHostname";
        stringArray[237] = "singletonList";
        stringArray[238] = "info";
        stringArray[239] = "MARK_VERBOSE";
        stringArray[240] = "getPublicIpAddresses";
        stringArray[241] = "singletonList";
        stringArray[242] = "info";
        stringArray[243] = "MARK_VERBOSE";
        stringArray[244] = "iterator";
        stringArray[245] = "debug";
        stringArray[246] = "verify";
        stringArray[247] = "debug";
        stringArray[248] = "debug";
        stringArray[249] = "name";
        stringArray[250] = "class";
        stringArray[251] = "message";
        stringArray[252] = "plus";
        stringArray[253] = "plus";
        stringArray[254] = "<$constructor$>";
        stringArray[255] = "CertificateNames";
        stringArray[256] = "subjectX500Principal";
        stringArray[257] = "issuerX500Principal";
        stringArray[258] = "subjectX500Principal";
        stringArray[259] = "issuerX500Principal";
        stringArray[260] = "<$constructor$>";
        stringArray[261] = "setCertificate";
        stringArray[262] = "getAt";
        stringArray[263] = "getInstance";
        stringArray[264] = "<$constructor$>";
        stringArray[265] = "get";
        stringArray[266] = "getInstance";
        stringArray[267] = "<$constructor$>";
        stringArray[268] = "setCertStores";
        stringArray[269] = "setRevocationEnabled";
        stringArray[270] = "build";
        stringArray[271] = "collect";
        stringArray[272] = "certificates";
        stringArray[273] = "certPath";
        stringArray[274] = "add";
        stringArray[275] = "trustedCert";
        stringArray[276] = "trustAnchor";
        stringArray[277] = "debug";
        stringArray[278] = "debug";
        stringArray[279] = "size";
        stringArray[280] = "debug";
        stringArray[281] = "message";
        stringArray[282] = "<$constructor$>";
        stringArray[283] = "ChainNotTrusted";
        stringArray[284] = "debug";
        stringArray[285] = "message";
        stringArray[286] = "<$constructor$>";
        stringArray[287] = "ChainNotTrusted";
        stringArray[288] = "getInstance";
        stringArray[289] = "initialize";
        stringArray[290] = "generateKeyPair";
        stringArray[291] = "info";
        stringArray[292] = "generateKeyPair";
        stringArray[293] = "<$constructor$>";
        stringArray[294] = "format";
        stringArray[295] = "createNonce";
        stringArray[296] = "<$constructor$>";
        stringArray[297] = "format";
        stringArray[298] = "valueOf";
        stringArray[299] = "<$constructor$>";
        stringArray[300] = "getEndDate";
        stringArray[301] = "public";
        stringArray[302] = "addExtension";
        stringArray[303] = "basicConstraints";
        stringArray[304] = "<$constructor$>";
        stringArray[305] = "addExtension";
        stringArray[306] = "keyUsage";
        stringArray[307] = "<$constructor$>";
        stringArray[308] = "or";
        stringArray[309] = "keyCertSign";
        stringArray[310] = "cRLSign";
        stringArray[311] = "getCertificate";
        stringArray[312] = "<$constructor$>";
        stringArray[313] = "build";
        stringArray[314] = "build";
        stringArray[315] = "<$constructor$>";
        stringArray[316] = "private";
        stringArray[317] = "<$constructor$>";
        stringArray[318] = "private";
        stringArray[319] = "info";
        stringArray[320] = "generateKeyPair";
        stringArray[321] = "<$constructor$>";
        stringArray[322] = "format";
        stringArray[323] = "createUnstructuredName";
        stringArray[324] = "getLocalHostname";
        stringArray[325] = "<$constructor$>";
        stringArray[326] = "format";
        stringArray[327] = "valueOf";
        stringArray[328] = "plus";
        stringArray[329] = "nextInt";
        stringArray[330] = "<$constructor$>";
        stringArray[331] = "<$constructor$>";
        stringArray[332] = "getAt";
        stringArray[333] = "chain";
        stringArray[334] = "getEndDate";
        stringArray[335] = "public";
        stringArray[336] = "addExtension";
        stringArray[337] = "basicConstraints";
        stringArray[338] = "<$constructor$>";
        stringArray[339] = "addExtension";
        stringArray[340] = "keyUsage";
        stringArray[341] = "<$constructor$>";
        stringArray[342] = "or";
        stringArray[343] = "keyEncipherment";
        stringArray[344] = "digitalSignature";
        stringArray[345] = "addExtension";
        stringArray[346] = "extendedKeyUsage";
        stringArray[347] = "<$constructor$>";
        stringArray[348] = "id_kp_serverAuth";
        stringArray[349] = "addExtension";
        stringArray[350] = "subjectAlternativeName";
        stringArray[351] = "createSubjectAltNames";
        stringArray[352] = "addExtension";
        stringArray[353] = "subjectAlternativeName";
        stringArray[354] = "getCertificate";
        stringArray[355] = "<$constructor$>";
        stringArray[356] = "build";
        stringArray[357] = "build";
        stringArray[358] = "<$constructor$>";
        stringArray[359] = "key";
        stringArray[360] = "<$constructor$>";
        stringArray[361] = "private";
        stringArray[362] = "plus";
        stringArray[363] = "chain";
        stringArray[364] = "getInstance";
        stringArray[365] = "getTimeZone";
        stringArray[366] = "setTime";
        stringArray[367] = "add";
        stringArray[368] = "DAY_OF_YEAR";
        stringArray[369] = "getTime";
        stringArray[370] = "list";
        stringArray[371] = "getNetworkInterfaces";
        stringArray[372] = "each";
        stringArray[373] = "getCanonicalHostName";
        stringArray[374] = "getLocalHost";
        stringArray[375] = "debug";
        stringArray[376] = "checkDNS";
        stringArray[377] = "warn";
        stringArray[378] = "warn";
        stringArray[379] = "warn";
        stringArray[380] = "info";
        stringArray[381] = "debug";
        stringArray[382] = "warn";
        stringArray[383] = "warn";
        stringArray[384] = "warn";
        stringArray[385] = "info";
        stringArray[386] = "debug";
        stringArray[387] = "getHostName";
        stringArray[388] = "getLocalHost";
        stringArray[389] = "warn";
        stringArray[390] = "message";
        stringArray[391] = "trace";
        stringArray[392] = "getHostName";
        stringArray[393] = "getLocalHost";
        stringArray[394] = "warn";
        stringArray[395] = "message";
        stringArray[396] = "trace";
        stringArray[397] = "<$constructor$>";
        stringArray[398] = "nextBytes";
        stringArray[399] = "join";
        stringArray[400] = "collect";
        stringArray[401] = "format";
        stringArray[402] = "currentTimeMillis";
        stringArray[403] = "createNonce";
        stringArray[404] = "format";
        stringArray[405] = "currentTimeMillis";
        stringArray[406] = "iterator";
        stringArray[407] = "getPublicIpAddresses";
        stringArray[408] = "info";
        stringArray[409] = "add";
        stringArray[410] = "<$constructor$>";
        stringArray[411] = "iPAddress";
        stringArray[412] = "iterator";
        stringArray[413] = "info";
        stringArray[414] = "add";
        stringArray[415] = "<$constructor$>";
        stringArray[416] = "iPAddress";
        stringArray[417] = "info";
        stringArray[418] = "add";
        stringArray[419] = "<$constructor$>";
        stringArray[420] = "dNSName";
        stringArray[421] = "info";
        stringArray[422] = "add";
        stringArray[423] = "<$constructor$>";
        stringArray[424] = "dNSName";
        stringArray[425] = "getLocalHostname";
        stringArray[426] = "info";
        stringArray[427] = "add";
        stringArray[428] = "<$constructor$>";
        stringArray[429] = "dNSName";
        stringArray[430] = "<$constructor$>";
        stringArray[431] = "isLinkLocalAddress";
        stringArray[432] = "isMulticastAddress";
        stringArray[433] = "isLoopbackAddress";
        stringArray[434] = "isLinkLocalAddress";
        stringArray[435] = "isMulticastAddress";
        stringArray[436] = "isLoopbackAddress";
        stringArray[437] = "plus";
        stringArray[438] = "plus";
        stringArray[439] = "plus";
        stringArray[440] = "plus";
        stringArray[441] = "plus";
        stringArray[442] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[443];
        ServerSslConfigFactoryImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ServerSslConfigFactoryImpl.$get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl(), stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ServerSslConfigFactoryImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$java$security$PrivateKey() {
        Class clazz = $class$java$security$PrivateKey;
        if (clazz == null) {
            clazz = $class$java$security$PrivateKey = ServerSslConfigFactoryImpl.class$("java.security.PrivateKey");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$X509Certificate() {
        Class clazz = $class$java$security$cert$X509Certificate;
        if (clazz == null) {
            clazz = $class$java$security$cert$X509Certificate = ServerSslConfigFactoryImpl.class$("java.security.cert.X509Certificate");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$asn1$x509$KeyPurposeId() {
        Class clazz = $class$org$bouncycastle$asn1$x509$KeyPurposeId;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$asn1$x509$KeyPurposeId = ServerSslConfigFactoryImpl.class$("org.bouncycastle.asn1.x509.KeyPurposeId");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$asn1$x509$X509Extension() {
        Class clazz = $class$org$bouncycastle$asn1$x509$X509Extension;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$asn1$x509$X509Extension = ServerSslConfigFactoryImpl.class$("org.bouncycastle.asn1.x509.X509Extension");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$String() {
        Class clazz = $class$java$lang$String;
        if (clazz == null) {
            clazz = $class$java$lang$String = ServerSslConfigFactoryImpl.class$("java.lang.String");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$SecureRandom() {
        Class clazz = $class$java$security$SecureRandom;
        if (clazz == null) {
            clazz = $class$java$security$SecureRandom = ServerSslConfigFactoryImpl.class$("java.security.SecureRandom");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$cert$jcajce$JcaX509v3CertificateBuilder() {
        Class clazz = $class$org$bouncycastle$cert$jcajce$JcaX509v3CertificateBuilder;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$cert$jcajce$JcaX509v3CertificateBuilder = ServerSslConfigFactoryImpl.class$("org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$slf4j$Logger() {
        Class clazz = $class$org$slf4j$Logger;
        if (clazz == null) {
            clazz = $class$org$slf4j$Logger = ServerSslConfigFactoryImpl.class$("org.slf4j.Logger");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$operator$jcajce$JcaContentSignerBuilder() {
        Class clazz = $class$org$bouncycastle$operator$jcajce$JcaContentSignerBuilder;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$operator$jcajce$JcaContentSignerBuilder = ServerSslConfigFactoryImpl.class$("org.bouncycastle.operator.jcajce.JcaContentSignerBuilder");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$net$NetworkInterface() {
        Class clazz = $class$java$net$NetworkInterface;
        if (clazz == null) {
            clazz = $class$java$net$NetworkInterface = ServerSslConfigFactoryImpl.class$("java.net.NetworkInterface");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$inject$Provider() {
        Class clazz = $class$javax$inject$Provider;
        if (clazz == null) {
            clazz = $class$javax$inject$Provider = ServerSslConfigFactoryImpl.class$("javax.inject.Provider");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Set() {
        Class clazz = $class$java$util$Set;
        if (clazz == null) {
            clazz = $class$java$util$Set = ServerSslConfigFactoryImpl.class$("java.util.Set");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$security$auth$x500$X500Principal() {
        Class clazz = $class$javax$security$auth$x500$X500Principal;
        if (clazz == null) {
            clazz = $class$javax$security$auth$x500$X500Principal = ServerSslConfigFactoryImpl.class$("javax.security.auth.x500.X500Principal");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$X509CertSelector() {
        Class clazz = $class$java$security$cert$X509CertSelector;
        if (clazz == null) {
            clazz = $class$java$security$cert$X509CertSelector = ServerSslConfigFactoryImpl.class$("java.security.cert.X509CertSelector");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Iterator() {
        Class clazz = $class$java$util$Iterator;
        if (clazz == null) {
            clazz = $class$java$util$Iterator = ServerSslConfigFactoryImpl.class$("java.util.Iterator");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$asn1$x509$GeneralNames() {
        Class clazz = $class$org$bouncycastle$asn1$x509$GeneralNames;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$asn1$x509$GeneralNames = ServerSslConfigFactoryImpl.class$("org.bouncycastle.asn1.x509.GeneralNames");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$commons$io$IOUtils() {
        Class clazz = $class$org$apache$commons$io$IOUtils;
        if (clazz == null) {
            clazz = $class$org$apache$commons$io$IOUtils = ServerSslConfigFactoryImpl.class$("org.apache.commons.io.IOUtils");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$asn1$x509$BasicConstraints() {
        Class clazz = $class$org$bouncycastle$asn1$x509$BasicConstraints;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$asn1$x509$BasicConstraints = ServerSslConfigFactoryImpl.class$("org.bouncycastle.asn1.x509.BasicConstraints");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Date() {
        Class clazz = $class$java$util$Date;
        if (clazz == null) {
            clazz = $class$java$util$Date = ServerSslConfigFactoryImpl.class$("java.util.Date");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$HashMap() {
        Class clazz = $class$java$util$HashMap;
        if (clazz == null) {
            clazz = $class$java$util$HashMap = ServerSslConfigFactoryImpl.class$("java.util.HashMap");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl() {
        Class clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl;
        if (clazz == null) {
            clazz = $class$com$vmware$sso$cfg$components$impl$ServerSslConfigFactoryImpl = ServerSslConfigFactoryImpl.class$("com.vmware.sso.cfg.components.impl.ServerSslConfigFactoryImpl");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$CertStore() {
        Class clazz = $class$java$security$cert$CertStore;
        if (clazz == null) {
            clazz = $class$java$security$cert$CertStore = ServerSslConfigFactoryImpl.class$("java.security.cert.CertStore");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$ServerSslConfig() {
        Class clazz = $class$com$vmware$sso$cfg$components$ServerSslConfig;
        if (clazz == null) {
            clazz = $class$com$vmware$sso$cfg$components$ServerSslConfig = ServerSslConfigFactoryImpl.class$("com.vmware.sso.cfg.components.ServerSslConfig");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$cert$jcajce$JcaX509CertificateConverter() {
        Class clazz = $class$org$bouncycastle$cert$jcajce$JcaX509CertificateConverter;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$cert$jcajce$JcaX509CertificateConverter = ServerSslConfigFactoryImpl.class$("org.bouncycastle.cert.jcajce.JcaX509CertificateConverter");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$net$InetAddress() {
        Class clazz = $class$java$net$InetAddress;
        if (clazz == null) {
            clazz = $class$java$net$InetAddress = ServerSslConfigFactoryImpl.class$("java.net.InetAddress");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$io$BufferedReader() {
        Class clazz = $class$java$io$BufferedReader;
        if (clazz == null) {
            clazz = $class$java$io$BufferedReader = ServerSslConfigFactoryImpl.class$("java.io.BufferedReader");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$slf4j$LoggerFactory() {
        Class clazz = $class$org$slf4j$LoggerFactory;
        if (clazz == null) {
            clazz = $class$org$slf4j$LoggerFactory = ServerSslConfigFactoryImpl.class$("org.slf4j.LoggerFactory");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$apache$http$conn$ssl$X509HostnameVerifier() {
        Class clazz = $class$com$vmware$sso$cfg$components$apache$http$conn$ssl$X509HostnameVerifier;
        if (clazz == null) {
            clazz = $class$com$vmware$sso$cfg$components$apache$http$conn$ssl$X509HostnameVerifier = ServerSslConfigFactoryImpl.class$("com.vmware.sso.cfg.components.apache.http.conn.ssl.X509HostnameVerifier");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Collections() {
        Class clazz = $class$java$util$Collections;
        if (clazz == null) {
            clazz = $class$java$util$Collections = ServerSslConfigFactoryImpl.class$("java.util.Collections");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes() {
        Class clazz = $class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes;
        if (clazz == null) {
            clazz = $class$com$vmware$sso$cfg$components$ServerSslConfigErrorCodes = ServerSslConfigFactoryImpl.class$("com.vmware.sso.cfg.components.ServerSslConfigErrorCodes");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Random() {
        Class clazz = $class$java$util$Random;
        if (clazz == null) {
            clazz = $class$java$util$Random = ServerSslConfigFactoryImpl.class$("java.util.Random");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$List() {
        Class clazz = $class$java$util$List;
        if (clazz == null) {
            clazz = $class$java$util$List = ServerSslConfigFactoryImpl.class$("java.util.List");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$TimeZone() {
        Class clazz = $class$java$util$TimeZone;
        if (clazz == null) {
            clazz = $class$java$util$TimeZone = ServerSslConfigFactoryImpl.class$("java.util.TimeZone");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Map() {
        Class clazz = $class$java$util$Map;
        if (clazz == null) {
            clazz = $class$java$util$Map = ServerSslConfigFactoryImpl.class$("java.util.Map");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$asn1$x509$ExtendedKeyUsage() {
        Class clazz = $class$org$bouncycastle$asn1$x509$ExtendedKeyUsage;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$asn1$x509$ExtendedKeyUsage = ServerSslConfigFactoryImpl.class$("org.bouncycastle.asn1.x509.ExtendedKeyUsage");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$logging$LogConst() {
        Class clazz = $class$com$vmware$sso$cfg$logging$LogConst;
        if (clazz == null) {
            clazz = $class$com$vmware$sso$cfg$logging$LogConst = ServerSslConfigFactoryImpl.class$("com.vmware.sso.cfg.logging.LogConst");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$interfaces$RSAPrivateCrtKey() {
        Class clazz = $class$java$security$interfaces$RSAPrivateCrtKey;
        if (clazz == null) {
            clazz = $class$java$security$interfaces$RSAPrivateCrtKey = ServerSslConfigFactoryImpl.class$("java.security.interfaces.RSAPrivateCrtKey");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$CertPath() {
        Class clazz = $class$java$security$cert$CertPath;
        if (clazz == null) {
            clazz = $class$java$security$cert$CertPath = ServerSslConfigFactoryImpl.class$("java.security.cert.CertPath");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$openssl$PEMReader() {
        Class clazz = $class$org$bouncycastle$openssl$PEMReader;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$openssl$PEMReader = ServerSslConfigFactoryImpl.class$("org.bouncycastle.openssl.PEMReader");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$io$Reader() {
        Class clazz = $class$java$io$Reader;
        if (clazz == null) {
            clazz = $class$java$io$Reader = ServerSslConfigFactoryImpl.class$("java.io.Reader");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$cert$X509v3CertificateBuilder() {
        Class clazz = $class$org$bouncycastle$cert$X509v3CertificateBuilder;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$cert$X509v3CertificateBuilder = ServerSslConfigFactoryImpl.class$("org.bouncycastle.cert.X509v3CertificateBuilder");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Calendar() {
        Class clazz = $class$java$util$Calendar;
        if (clazz == null) {
            clazz = $class$java$util$Calendar = ServerSslConfigFactoryImpl.class$("java.util.Calendar");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$CertPathValidator() {
        Class clazz = $class$java$security$cert$CertPathValidator;
        if (clazz == null) {
            clazz = $class$java$security$cert$CertPathValidator = ServerSslConfigFactoryImpl.class$("java.security.cert.CertPathValidator");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$KeyPair() {
        Class clazz = $class$java$security$KeyPair;
        if (clazz == null) {
            clazz = $class$java$security$KeyPair = ServerSslConfigFactoryImpl.class$("java.security.KeyPair");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$IllegalSslConfigException() {
        Class clazz = $class$com$vmware$sso$cfg$components$IllegalSslConfigException;
        if (clazz == null) {
            clazz = $class$com$vmware$sso$cfg$components$IllegalSslConfigException = ServerSslConfigFactoryImpl.class$("com.vmware.sso.cfg.components.IllegalSslConfigException");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$interfaces$RSAPublicKey() {
        Class clazz = $class$java$security$interfaces$RSAPublicKey;
        if (clazz == null) {
            clazz = $class$java$security$interfaces$RSAPublicKey = ServerSslConfigFactoryImpl.class$("java.security.interfaces.RSAPublicKey");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$TrustAnchor() {
        Class clazz = $class$java$security$cert$TrustAnchor;
        if (clazz == null) {
            clazz = $class$java$security$cert$TrustAnchor = ServerSslConfigFactoryImpl.class$("java.security.cert.TrustAnchor");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$CollectionCertStoreParameters() {
        Class clazz = $class$java$security$cert$CollectionCertStoreParameters;
        if (clazz == null) {
            clazz = $class$java$security$cert$CollectionCertStoreParameters = ServerSslConfigFactoryImpl.class$("java.security.cert.CollectionCertStoreParameters");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$CertificateFactory() {
        Class clazz = $class$java$security$cert$CertificateFactory;
        if (clazz == null) {
            clazz = $class$java$security$cert$CertificateFactory = ServerSslConfigFactoryImpl.class$("java.security.cert.CertificateFactory");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$KeyPairGenerator() {
        Class clazz = $class$java$security$KeyPairGenerator;
        if (clazz == null) {
            clazz = $class$java$security$KeyPairGenerator = ServerSslConfigFactoryImpl.class$("java.security.KeyPairGenerator");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$impl$DNSResolver() {
        Class clazz = $class$com$vmware$sso$cfg$components$impl$DNSResolver;
        if (clazz == null) {
            clazz = $class$com$vmware$sso$cfg$components$impl$DNSResolver = ServerSslConfigFactoryImpl.class$("com.vmware.sso.cfg.components.impl.DNSResolver");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$PKIXCertPathBuilderResult() {
        Class clazz = $class$java$security$cert$PKIXCertPathBuilderResult;
        if (clazz == null) {
            clazz = $class$java$security$cert$PKIXCertPathBuilderResult = ServerSslConfigFactoryImpl.class$("java.security.cert.PKIXCertPathBuilderResult");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$asn1$x509$GeneralName() {
        Class clazz = $class$org$bouncycastle$asn1$x509$GeneralName;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$asn1$x509$GeneralName = ServerSslConfigFactoryImpl.class$("org.bouncycastle.asn1.x509.GeneralName");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$bouncycastle$asn1$x509$KeyUsage() {
        Class clazz = $class$org$bouncycastle$asn1$x509$KeyUsage;
        if (clazz == null) {
            clazz = $class$org$bouncycastle$asn1$x509$KeyUsage = ServerSslConfigFactoryImpl.class$("org.bouncycastle.asn1.x509.KeyUsage");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$array$$class$org$bouncycastle$asn1$x509$GeneralName() {
        Class clazz = array$$class$org$bouncycastle$asn1$x509$GeneralName;
        if (clazz == null) {
            clazz = array$$class$org$bouncycastle$asn1$x509$GeneralName = ServerSslConfigFactoryImpl.class$("[Lorg.bouncycastle.asn1.x509.GeneralName;");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$System() {
        Class clazz = $class$java$lang$System;
        if (clazz == null) {
            clazz = $class$java$lang$System = ServerSslConfigFactoryImpl.class$("java.lang.System");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$CertPathBuilder() {
        Class clazz = $class$java$security$cert$CertPathBuilder;
        if (clazz == null) {
            clazz = $class$java$security$cert$CertPathBuilder = ServerSslConfigFactoryImpl.class$("java.security.cert.CertPathBuilder");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$ArrayList() {
        Class clazz = $class$java$util$ArrayList;
        if (clazz == null) {
            clazz = $class$java$util$ArrayList = ServerSslConfigFactoryImpl.class$("java.util.ArrayList");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$io$FileReader() {
        Class clazz = $class$java$io$FileReader;
        if (clazz == null) {
            clazz = $class$java$io$FileReader = ServerSslConfigFactoryImpl.class$("java.io.FileReader");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$cert$PKIXBuilderParameters() {
        Class clazz = $class$java$security$cert$PKIXBuilderParameters;
        if (clazz == null) {
            clazz = $class$java$security$cert$PKIXBuilderParameters = ServerSslConfigFactoryImpl.class$("java.security.cert.PKIXBuilderParameters");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$PublicKey() {
        Class clazz = $class$java$security$PublicKey;
        if (clazz == null) {
            clazz = $class$java$security$PublicKey = ServerSslConfigFactoryImpl.class$("java.security.PublicKey");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$com$vmware$sso$cfg$components$apache$http$conn$ssl$StrictHostnameVerifier() {
        Class clazz = $class$com$vmware$sso$cfg$components$apache$http$conn$ssl$StrictHostnameVerifier;
        if (clazz == null) {
            clazz = $class$com$vmware$sso$cfg$components$apache$http$conn$ssl$StrictHostnameVerifier = ServerSslConfigFactoryImpl.class$("com.vmware.sso.cfg.components.apache.http.conn.ssl.StrictHostnameVerifier");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$math$BigInteger() {
        Class clazz = $class$java$math$BigInteger;
        if (clazz == null) {
            clazz = $class$java$math$BigInteger = ServerSslConfigFactoryImpl.class$("java.math.BigInteger");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

