/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg.components.impl;

import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.ptr.IntByReference;
import com.vmware.sso.cfg.components.ServiceControl;
import com.vmware.sso.cfg.components.ServiceControlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceControlImpl
implements ServiceControl {
    private static final int SERVICE_MAX_WAIT = 120;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning(String serviceName) {
        Winsvc.SC_HANDLE svcCtlMgr = this.openScManager(Integer.MIN_VALUE);
        try {
            boolean bl;
            Winsvc.SC_HANDLE service = this.openService(svcCtlMgr, serviceName, Integer.MIN_VALUE);
            try {
                Winsvc.SERVICE_STATUS_PROCESS svcStatus = this.querySvcStatus(service);
                bl = this.isRunnung(svcStatus);
            }
            catch (Throwable throwable) {
                ServiceControlImpl.advapi32().CloseServiceHandle(service);
                throw throwable;
            }
            ServiceControlImpl.advapi32().CloseServiceHandle(service);
            return bl;
        }
        finally {
            ServiceControlImpl.advapi32().CloseServiceHandle(svcCtlMgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String serviceName) {
        block9: {
            Winsvc.SC_HANDLE svcCtlMgr = this.openScManager(0x20000000);
            try {
                Winsvc.SC_HANDLE service = this.openService(svcCtlMgr, serviceName, -1610612736);
                try {
                    Winsvc.SERVICE_STATUS_PROCESS processStatus = this.querySvcStatus(service);
                    if (this.isRunnung(processStatus)) {
                        this.log.debug("Service {} is running, nothing to do.", (Object)serviceName);
                        break block9;
                    }
                    if (this.isStarting(processStatus)) {
                        this.waitForServiceToStart(serviceName, service);
                        break block9;
                    }
                    if (this.isStopped(processStatus)) {
                        this.checkOsError("StartService", ServiceControlImpl.advapi32().StartService(service, 0, new String[0]));
                        this.waitForServiceToStart(serviceName, service);
                        break block9;
                    }
                    throw new ServiceControlException(String.format("Service %s is in state: %d . Cannot issue start command while service is in that state. Try launching the operation again.", serviceName, processStatus.dwCurrentState));
                }
                finally {
                    ServiceControlImpl.advapi32().CloseServiceHandle(service);
                }
            }
            finally {
                ServiceControlImpl.advapi32().CloseServiceHandle(svcCtlMgr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String serviceName) {
        block9: {
            Winsvc.SC_HANDLE svcCtlMgr = this.openScManager(0x20000000);
            try {
                Winsvc.SC_HANDLE service = this.openService(svcCtlMgr, serviceName, -1610612736);
                try {
                    Winsvc.SERVICE_STATUS_PROCESS processStatus = this.querySvcStatus(service);
                    if (this.isStopped(processStatus)) {
                        this.log.debug("Service {} already stopped, nothing to do.", (Object)serviceName);
                        break block9;
                    }
                    if (this.isStopping(processStatus)) {
                        this.waitForServiceToStop(serviceName, service);
                        break block9;
                    }
                    if (this.isRunnung(processStatus)) {
                        Winsvc.SERVICE_STATUS status = new Winsvc.SERVICE_STATUS();
                        this.checkOsError("ControlService(SERVICE_CONTROL_STOP)", ServiceControlImpl.advapi32().ControlService(service, 1, status));
                        this.waitForServiceToStop(serviceName, service);
                        break block9;
                    }
                    throw new ServiceControlException(String.format("Service %s is in state: %d . Cannot issue stop command while service is in that state. Try stopping the service manually.", serviceName, processStatus.dwCurrentState));
                }
                finally {
                    ServiceControlImpl.advapi32().CloseServiceHandle(service);
                }
            }
            finally {
                ServiceControlImpl.advapi32().CloseServiceHandle(svcCtlMgr);
            }
        }
    }

    private void waitForServiceToStart(String serviceName, Winsvc.SC_HANDLE service) {
        this.waitForPendingState(serviceName, service, 2, 4, "start");
    }

    private void waitForServiceToStop(String serviceName, Winsvc.SC_HANDLE service) {
        this.waitForPendingState(serviceName, service, 3, 1, "stop");
    }

    private void waitForPendingState(String serviceName, Winsvc.SC_HANDLE service, int pendingState, int targetState, String stateTransition) {
        assert (serviceName != null);
        assert (service != null);
        assert (pendingState == 2 && targetState == 4 || pendingState == 3 && targetState == 1);
        assert (stateTransition != null && !stateTransition.isEmpty());
        long probeInterval = 3L;
        long infoInterval = 5L;
        long totalWaitTimeSec = 0L;
        long totalProbeCount = 0L;
        Winsvc.SERVICE_STATUS_PROCESS status = this.querySvcStatus(service);
        while (status.dwCurrentState == pendingState) {
            if (totalWaitTimeSec >= 120L) {
                throw new ServiceControlException(String.format("Already waited for %d seconds and service did not %s. Giving up.", 120, stateTransition));
            }
            long waitTimeSec = Math.max((long)(status.dwWaitHint / 1000), 3L);
            if (totalProbeCount % 5L == 0L) {
                this.log.info("Waiting for service {} to {}, {} seconds.", new Object[]{serviceName, stateTransition, 15L});
            }
            try {
                Thread.sleep(waitTimeSec * 1000L);
                totalWaitTimeSec += waitTimeSec;
                ++totalProbeCount;
            }
            catch (InterruptedException e) {
                this.log.debug("", (Throwable)e);
                throw new ServiceControlException(String.format("Interrupted while waiting for the service %s to %s: %s. Service cannot be stopped successfully.", serviceName, stateTransition, e.getMessage()));
            }
            status = this.querySvcStatus(service);
        }
        assert (this.querySvcStatus((Winsvc.SC_HANDLE)service).dwCurrentState == targetState);
        this.log.info("Service did {} successfully.", (Object)stateTransition);
    }

    private Winsvc.SC_HANDLE openScManager(int access) {
        Winsvc.SC_HANDLE svcCtlMgr = ServiceControlImpl.advapi32().OpenSCManager(null, null, access);
        this.checkOsError("OpenSCManager", svcCtlMgr != null);
        return svcCtlMgr;
    }

    private Winsvc.SC_HANDLE openService(Winsvc.SC_HANDLE svcCtlMgr, String serviceName, int access) {
        Winsvc.SC_HANDLE service = ServiceControlImpl.advapi32().OpenService(svcCtlMgr, serviceName, access);
        this.checkOsError("OpenService", service != null);
        return service;
    }

    private Winsvc.SERVICE_STATUS_PROCESS querySvcStatus(Winsvc.SC_HANDLE service) {
        Winsvc.SERVICE_STATUS_PROCESS status = new Winsvc.SERVICE_STATUS_PROCESS();
        IntByReference bytesNeeded = new IntByReference();
        this.checkOsError("QueryServiceStatusEx", ServiceControlImpl.advapi32().QueryServiceStatusEx(service, 0, status, status.size(), bytesNeeded));
        return status;
    }

    private boolean isRunnung(Winsvc.SERVICE_STATUS_PROCESS processStatus) {
        return processStatus.dwCurrentState == 4;
    }

    private boolean isStarting(Winsvc.SERVICE_STATUS_PROCESS processStatus) {
        return processStatus.dwCurrentState == 2;
    }

    private boolean isStopping(Winsvc.SERVICE_STATUS_PROCESS processStatus) {
        return processStatus.dwCurrentState == 3;
    }

    private boolean isStopped(Winsvc.SERVICE_STATUS_PROCESS processStatus) {
        return processStatus.dwCurrentState == 1;
    }

    private void checkOsError(String call, boolean condition) {
        if (!condition) {
            int lastError = Kernel32.INSTANCE.GetLastError();
            String systemMsg = Kernel32Util.formatMessageFromLastErrorCode((int)lastError);
            throw new ServiceControlException(String.format(String.format("Call to %s failed: %s", call, systemMsg), new Object[0]));
        }
    }

    private static final Advapi32 advapi32() {
        return Advapi32.INSTANCE;
    }
}

