/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg.logging;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LayoutBase;
import java.util.LinkedList;
import java.util.List;

public final class MultiPatternLayout
extends LayoutBase<ILoggingEvent> {
    private final List<Rule> rules = new LinkedList<Rule>();
    private final PatternLayout defaultPattern = new PatternLayout();

    public void start() {
        super.start();
        this.defaultPattern.setContext(this.getContext());
        this.defaultPattern.start();
        for (Rule rule : this.rules) {
            rule.pattern.setContext(this.getContext());
            rule.pattern.start();
        }
    }

    public void stop() {
        for (Rule rule : this.rules) {
            rule.pattern.stop();
        }
        this.defaultPattern.stop();
        super.stop();
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.defaultPattern.setContext(context);
        for (Rule rule : this.rules) {
            rule.pattern.setContext(context);
        }
    }

    public String doLayout(ILoggingEvent event) {
        for (Rule rule : this.rules) {
            if (!rule.matches(event)) continue;
            return rule.pattern.doLayout(event);
        }
        return this.defaultPattern.doLayout(event);
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void setDefault(String pattern) {
        this.defaultPattern.setPattern(pattern);
    }

    public static abstract class Rule {
        private PatternLayout pattern = new PatternLayout();

        public abstract boolean matches(ILoggingEvent var1);

        public final String getPattern() {
            return this.pattern.getPattern();
        }

        public final void setPattern(String pattern) {
            this.pattern.setPattern(pattern);
        }
    }
}

