/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class SslUtil {
    private static final String HEX = "0123456789ABCDEF";

    public static String computeCertificateThumbprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] digest = md.digest(cert.getEncoded());
        StringBuilder thumbprint = new StringBuilder();
        int len = digest.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                thumbprint.append(':');
            }
            byte b = digest[i];
            thumbprint.append(HEX.charAt((b & 0xF0) >> 4));
            thumbprint.append(HEX.charAt(b & 0xF));
        }
        return thumbprint.toString();
    }
}

