/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.Environment;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

class MoRefStackContext
extends StackContext {
    private ManagedObjectReference _moref = new ManagedObjectReference();
    private static final QName TYPE = new QName("type");
    private static final QName SERVER_GUID = new QName("serverGuid");

    public MoRefStackContext(VmodlField field, VmodlType type, StackContext parent, Map<QName, String> attrs, Environment env) throws UnmarshallException {
        super(field, type, parent);
        if (env.isQSFormat()) {
            String href = attrs.get(HREF);
            if (href == null) {
                throw new UnmarshallException("Missing xlink:href attribute");
            }
            String[] info = href.split(":");
            if (info.length != 5 || !info[0].equals("urn") || !info[1].equals("vmomi")) {
                throw new UnmarshallException(String.format("Managed object reference URI %s is not in the correct format", href));
            }
            this._moref.setType(info[2]);
            this._moref.setValue(info[3]);
            this._moref.setServerGuid(info[4]);
        } else {
            String moType = attrs.get(TYPE);
            if (moType == null) {
                throw new UnmarshallException("Missing 'type' attribute on ManagedObjectReference");
            }
            this._moref.setType(moType);
            this._moref.setServerGuid(attrs.get(SERVER_GUID));
        }
    }

    @Override
    public void setValue(Object value) throws UnmarshallException {
        this._moref.setValue((String)value);
    }

    @Override
    public void setChildValue(VmodlField field, Object value) throws UnmarshallException {
        throw new UnmarshallException();
    }

    @Override
    public Object getValue() {
        return this._moref;
    }

    @Override
    public void close() throws UnmarshallException {
        if (this.getParentContext() != null) {
            this.getParentContext().setChildValue(this.getField(), this.getValue());
        }
    }

    @Override
    public StackContext getNestedContext(QName name2, Map<QName, String> attrs, NamespaceContext namespaces) throws UnmarshallException {
        throw new UnmarshallException();
    }
}

