/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vim.vmomi.core.types.impl.DataObjectTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.FaultTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.ManagedObjectTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlArrayTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlEnumTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlTypeMapImpl;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class VmodlContextLoader {
    private boolean _hideMoRef;
    private List<Class<?>> _vmodlVersionContext;
    private List<Class<?>> _vmodlTypeContext;
    private List<Primitive> _vmodlPrimitiveContext;
    private Map<Class<? extends DataObject>, Class<? extends DataObject>> _vmodlDataObjects;

    VmodlContextLoader() {
    }

    public void load() {
        this.loadVersions();
        this.loadTypes();
    }

    private void loadVersions() {
        VmodlVersionMap vmap = VmodlVersionMap.Factory.getVmodlVersionMap();
        for (Class<?> version : this._vmodlVersionContext) {
            if (vmap.getVersion(version) != null) continue;
            vmap.addVersion(version);
        }
    }

    private void loadTypes() {
        VmodlTypeMap typeMap = VmodlTypeMap.Factory.getTypeMap();
        VmodlVersionMap vmap = VmodlVersionMap.Factory.getVmodlVersionMap();
        if (this._vmodlPrimitiveContext != null) {
            for (int i = 0; i < this._vmodlPrimitiveContext.size(); ++i) {
                Primitive primitive = this._vmodlPrimitiveContext.get(i);
                VmodlTypeImpl type = new VmodlTypeImpl();
                type.setClazz(primitive.getClazz());
                type.setKind(primitive.getKind());
                type.setVersion(vmap.getVersion(primitive.getVersion()));
                type.setWsdlName(primitive.getWsdlName());
                type.initTypeName();
                typeMap.registerType(type);
                try {
                    Class typeField = (Class)primitive.getClazz().getField("TYPE").get(null);
                    typeMap.registerType(typeField, (VmodlType)type);
                    typeMap.registerType(Array.newInstance(typeField, 0).getClass(), (VmodlType)new VmodlArrayTypeImpl(type, typeField));
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalAccessException e) {
                    throw new InternalException(e);
                }
                typeMap.registerType(new VmodlArrayTypeImpl(type));
            }
        }
        for (Class<?> clazz : this._vmodlTypeContext) {
            this.loadVmodlType(clazz, typeMap);
        }
        ArrayList<ManagedObjectTypeImpl> moTypes = new ArrayList<ManagedObjectTypeImpl>();
        for (Class<?> clazz : this._vmodlTypeContext) {
            if (!this.isManagedObject(clazz)) continue;
            this.loadManagedObjectType(clazz, typeMap, moTypes);
        }
        for (ManagedObjectTypeImpl moType : moTypes) {
            moType.init();
            ((VmodlTypeMapImpl)typeMap).registerOperations(moType);
        }
    }

    private void loadManagedObjectType(Class<?> clazz, VmodlTypeMap typeMap, List<ManagedObjectTypeImpl> moTypes) {
        for (Class<?> inner : clazz.getDeclaredClasses()) {
            if (!this.isManagedObject(inner) && typeMap.getVmodlType(inner) == null) {
                this.loadVmodlType(inner, typeMap);
                continue;
            }
            this.loadManagedObjectType(inner, typeMap, moTypes);
        }
        Class<?>[] baseClasses = clazz.getInterfaces();
        while (baseClasses != null && baseClasses.length == 1 && this.isManagedObject(baseClasses[0])) {
            this.loadManagedObjectType(baseClasses[0], typeMap, moTypes);
            baseClasses = baseClasses[0].getInterfaces();
        }
        if (typeMap.getVmodlType(clazz) == null) {
            ManagedObjectTypeImpl type = new ManagedObjectTypeImpl((Class)clazz);
            typeMap.registerType(type);
            moTypes.add(type);
            typeMap.registerType(new VmodlArrayTypeImpl(type));
        }
    }

    private void loadVmodlType(Class<?> vmodl, VmodlTypeMap typeMap) {
        Class<?>[] inner;
        VmodlTypeImpl type = null;
        if (this._vmodlDataObjects.containsKey(vmodl)) {
            type = new DataObjectTypeImpl(vmodl, this._vmodlDataObjects.get(vmodl));
        } else if (this.isException(vmodl)) {
            type = new FaultTypeImpl((Class<? extends Exception>)vmodl);
        } else if (vmodl.isEnum()) {
            type = new VmodlEnumTypeImpl((Class<? extends Enum<?>>)vmodl);
        }
        if (type != null) {
            typeMap.registerType(type);
            typeMap.registerType(new VmodlArrayTypeImpl(type));
        }
        if ((inner = vmodl.getDeclaredClasses()) == null) {
            return;
        }
        for (int i = 0; i < inner.length; ++i) {
            this.loadVmodlType(inner[i], typeMap);
        }
    }

    private boolean isException(Class<?> clazz) {
        try {
            clazz.asSubclass(Exception.class);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean isManagedObject(Class<?> clazz) {
        return clazz.getAnnotation(managed.class) != null;
    }

    public void setVmodlTypeContext(List<Class<?>> type) {
        this._vmodlTypeContext = type;
    }

    public void setVmodlVersionContext(List<Class<?>> version) {
        this._vmodlVersionContext = version;
    }

    public List<Class<?>> getVmodlVersionContext() {
        return this._vmodlVersionContext;
    }

    public void setVmodlPrimitiveContext(List<Primitive> type) {
        this._vmodlPrimitiveContext = type;
    }

    public void setVmodlDataObjects(Map<Class<? extends DataObject>, Class<? extends DataObject>> vmodlDataObjects) {
        this._vmodlDataObjects = vmodlDataObjects;
    }

    public void setHideMoRef(boolean hideMoRef) {
        this._hideMoRef = hideMoRef;
    }

    public boolean isHideMoRef() {
        return this._hideMoRef;
    }

    public static class Primitive {
        private Class<?> _class;
        private VmodlType.Kind _kind;
        private String _wsdlName;
        private Class<?> _version;

        public void setClazz(Class<?> clazz) {
            this._class = clazz;
        }

        public Class<?> getClazz() {
            return this._class;
        }

        public void setKind(VmodlType.Kind kind) {
            this._kind = kind;
        }

        public VmodlType.Kind getKind() {
            return this._kind;
        }

        public void setWsdlName(String wsdlName2) {
            this._wsdlName = wsdlName2;
        }

        public String getWsdlName() {
            return this._wsdlName;
        }

        public void setVersion(Class<?> version) {
            this._version = version;
        }

        public Class<?> getVersion() {
            return this._version;
        }
    }
}

