/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";

    private FileUtil() {
    }

    public static String getAbsoluteFilename(String path) throws IOException {
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            ClassLoader loader = FileUtil.class.getClassLoader();
            return loader.getResource(FileUtil.stripPrefix(path)).getPath();
        }
        return new File(path).getAbsolutePath();
    }

    public static InputStream getInputStream(String path, ClassLoader loader) throws IOException {
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            if (loader == null) {
                loader = FileUtil.class.getClassLoader();
            }
            return loader.getResourceAsStream(FileUtil.stripPrefix(path));
        }
        return new FileInputStream(path);
    }

    private static String stripPrefix(String path) {
        return path.substring(CLASSPATH_URL_PREFIX.length());
    }
}

