/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.common.Exchange;
import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.client.exception.ClientHaltException;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpSchemeUtils;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpExchange
implements Exchange,
Runnable {
    private static final Log LOG = LogFactory.getLog(HttpExchange.class);
    private static final Header CONTENT_TYPE = new BasicHeader("Content-Type", "text/xml; charset=utf-8");
    private static final Header ACCEPT_ENCODING = new BasicHeader("Accept-Encoding", "gzip");
    private static final Header CONTENT_ENCODING = new BasicHeader("Content-Encoding", "gzip");
    private static final String REQUEST_VERSION_ID_TEMPLATE = "urn:%1$s/%2$s";
    private final Request _request;
    private final Response _response;
    private final URI _endpoint;
    private final HttpClient _client;
    private final boolean _enableCompression;
    private InvocationInterceptor _invocationInterceptor;
    private HttpConfigurationImpl _config;

    public HttpExchange(Request request, Response response, HttpClient client, URI endpoint, boolean enableCompression, InvocationInterceptor invocationInterceptor, HttpConfigurationImpl config) {
        this._request = request;
        this._response = response;
        this._endpoint = endpoint;
        this._client = client;
        this._enableCompression = enableCompression;
        this._invocationInterceptor = invocationInterceptor;
        this._config = config;
    }

    @Override
    public Request getRequest() {
        return this._request;
    }

    @Override
    public Response getResponse() {
        return this._response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean success;
        InputStream responseBody;
        block31: {
            responseBody = null;
            success = true;
            if (this._invocationInterceptor != null) {
                try {
                    this._invocationInterceptor.beginInvocation(((ResponseImpl)this._response).getInvocationContext());
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Exception on InvocationInterceptor.beginInvocation(...)", (Throwable)e);
                    }
                    if (!(e instanceof ClientHaltException)) break block31;
                    throw (ClientHaltException)e;
                }
            }
        }
        try {
            HttpPost post = this.prepareRequest();
            HttpContext localContext = this.prepareLocalContext();
            HttpResponse response = this._client.execute((HttpUriRequest)post, localContext);
            this.parseLocalContext(localContext);
            responseBody = response.getEntity().getContent();
            Header contentEncoding = response.getFirstHeader("Content-Encoding");
            if (contentEncoding != null && "gzip".equals(contentEncoding.getValue())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Received HTTP response with gzip content encoding.");
                }
                responseBody = new GZIPInputStream(responseBody);
            }
            this._response.setResponse(Response.Status.getStatus(response.getStatusLine().getStatusCode()), responseBody);
        }
        catch (Exception e) {
            success = false;
            this._response.setError(e);
        }
        catch (Throwable e) {
            success = false;
            this._response.setError(new RuntimeException(e));
        }
        finally {
            block33: {
                if (responseBody != null) {
                    try {
                        responseBody.close();
                    }
                    catch (IOException e) {}
                }
                if (this._invocationInterceptor != null) {
                    try {
                        this._invocationInterceptor.completeInvocation(((ResponseImpl)this._response).getInvocationContext(), success);
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled() || !LOG.isDebugEnabled()) break block33;
                        LOG.debug((Object)"Exception on InvocationInterceptor.completeInvocation(...)", (Throwable)e);
                    }
                }
            }
        }
    }

    private HttpPost prepareRequest() throws IOException, MarshallException {
        String versionId;
        HttpPost post = new HttpPost(this._endpoint);
        post.setHeader(CONTENT_TYPE);
        if (this._enableCompression) {
            post.setHeader(CONTENT_ENCODING);
            post.setHeader(ACCEPT_ENCODING);
        }
        post.setHeader("SOAPAction", (versionId = this._request.getVersion().getVersionId()) != null && versionId.length() > 0 ? String.format(REQUEST_VERSION_ID_TEMPLATE, this._request.getVersion().getNamespace(), versionId) : "");
        post.setEntity((HttpEntity)new RequestEntity());
        return post;
    }

    private HttpContext prepareLocalContext() {
        if (!HttpSchemeUtils.isSecure(this._endpoint)) {
            return null;
        }
        BasicHttpContext localContext = new BasicHttpContext();
        if (this._config.getCompiledConfiguration().getClientSSLToken() != null) {
            localContext.setAttribute("http.user-token", (Object)this._config.getCompiledConfiguration().getClientSSLToken());
        }
        return localContext;
    }

    private void parseLocalContext(HttpContext localContext) {
        if (localContext == null || !HttpSchemeUtils.isSecure(this._endpoint)) {
            return;
        }
        if (localContext.getAttribute("http.user-token") != null && this._config.getCompiledConfiguration().getClientSSLToken() == null) {
            this._config.getCompiledConfiguration().setClientSSLToken((Principal)localContext.getAttribute("http.user-token"));
        }
    }

    private class RequestEntity
    extends AbstractHttpEntity {
        private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

        public RequestEntity() throws IOException, MarshallException {
            OutputStream os = HttpExchange.this._enableCompression ? new GZIPOutputStream(this._buffer) : this._buffer;
            HttpExchange.this._request.writeBody(os);
            os.close();
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return this._buffer.size();
        }

        public InputStream getContent() {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outstream) throws IOException {
            outstream.write(this._buffer.toByteArray());
        }

        public boolean isStreaming() {
            return false;
        }
    }
}

