/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi;

import com.vmware.vim.binding.sso.version.version1;
import com.vmware.vim.binding.sso.version.version1_5;
import com.vmware.vim.binding.sso.version.version2;
import com.vmware.vim.binding.sso.version.version2_5;
import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.admin.client.AdminClientFactory;
import com.vmware.vim.sso.admin.client.ClientConfiguration;
import com.vmware.vim.sso.admin.client.GroupCheckClient;
import com.vmware.vim.sso.admin.client.GroupCheckClientFactory;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.impl.AdminClientImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.GroupCheckClientImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.VlsiClientFactory;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import java.net.URI;

public final class VmomiClientFactory
implements AdminClientFactory,
GroupCheckClientFactory {
    private static final String VMOMI_CONFIG_ERR_MSG = "VMOMI client configuration";
    private static final String CLIENT_CONFIG_ERR_MSG = "Client configuration";
    private final VlsiClientFactory _clientFactory;
    private final VmomiClientConfiguration _config;

    private VmomiClientFactory(VmomiClientConfiguration config) {
        this._config = config;
        this._clientFactory = new VlsiClientFactory();
    }

    @Override
    public AdminClient createAdminClient() throws SystemException {
        return this.createAdminClient(new ClientConfiguration());
    }

    @Override
    public AdminClient createAdminClient(ClientConfiguration config) throws SystemException {
        ValidateUtil.validateNotNull((Object)config, (String)CLIENT_CONFIG_ERR_MSG);
        return new AdminClientImpl(this.createVmomiClient(), config.getAuthData());
    }

    @Override
    public GroupCheckClient createGroupCheckClient(ClientConfiguration config) throws SystemException {
        ValidateUtil.validateNotNull((Object)config, (String)CLIENT_CONFIG_ERR_MSG);
        ValidateUtil.validateNotNull((Object)config.getAuthData(), (String)"Authentication data");
        return new GroupCheckClientImpl(this.createVmomiClient(), config.getAuthData());
    }

    private Client createVmomiClient() {
        VmomiClientConfiguration.SslConfiguration sslConfig = this._config.getSslConfig();
        URI serverUri = this._config.getServerUri();
        VmomiClientConfiguration.Version version = this._config.getVersion();
        Class vmomiVersion = version1.class;
        vmomiVersion = version == VmomiClientConfiguration.Version.Version2_5 ? version2_5.class : (version == VmomiClientConfiguration.Version.Version2 ? version2.class : (version == VmomiClientConfiguration.Version.Version1_5 ? version1_5.class : version1.class));
        return sslConfig != null ? this._clientFactory.createClient(serverUri, vmomiVersion, this.createHttpConfig(sslConfig)) : this._clientFactory.createClient(serverUri, vmomiVersion);
    }

    private HttpConfiguration createHttpConfig(VmomiClientConfiguration.SslConfiguration sslConfig) {
        assert (sslConfig != null);
        HttpConfigurationImpl httpConfig = new HttpConfigurationImpl();
        if (sslConfig.getThumbprintVerifier() != null) {
            httpConfig.setThumbprintVerifier(sslConfig.getThumbprintVerifier());
        }
        if (sslConfig.getTrustStore() != null) {
            httpConfig.setTrustStore(sslConfig.getTrustStore());
        }
        if (sslConfig.getTrustStorePass() != null) {
            httpConfig.getKeyStoreConfig().setTrustStorePassword(sslConfig.getTrustStorePass());
        }
        return httpConfig;
    }

    public static AdminClientFactory createAdminClientFactory(VmomiClientConfiguration config) {
        ValidateUtil.validateNotNull((Object)config, (String)VMOMI_CONFIG_ERR_MSG);
        return new VmomiClientFactory(config);
    }

    public static GroupCheckClientFactory createGroupCheckFactory(VmomiClientConfiguration config) {
        ValidateUtil.validateNotNull((Object)config, (String)VMOMI_CONFIG_ERR_MSG);
        return new VmomiClientFactory(config);
    }
}

