/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.fault.RuntimeServiceFault;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.Group;
import com.vmware.vim.sso.admin.PersonUser;
import com.vmware.vim.sso.admin.PrincipalDiscovery;
import com.vmware.vim.sso.admin.SolutionUser;
import com.vmware.vim.sso.admin.client.vmomi.impl.SdkVmodlTypeConversions;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import com.vmware.vim.sso.client.impl.ValidateUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class PrincipalDiscoveryImpl
implements PrincipalDiscovery {
    private final PrincipalDiscoveryService _vmomiDiscoveryService;

    public PrincipalDiscoveryImpl(PrincipalDiscoveryService vmomiDiscoveryService) {
        assert (vmomiDiscoveryService != null);
        this._vmomiDiscoveryService = vmomiDiscoveryService;
    }

    public PrincipalId lookup(final PrincipalId id, final boolean isGroup) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)id, (String)"Principal Id");
        return (PrincipalId)new VmomiClientCommand<PrincipalId>(){

            @Override
            public PrincipalId actionCommand() {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)PrincipalDiscoveryImpl.this._vmomiDiscoveryService.lookup(VmodlTypeConversions.toVmodl((PrincipalId)id), isGroup));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public PrincipalDiscovery.SearchResult find(final PrincipalDiscovery.SearchCriteria criteria, final int limit) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)criteria, (String)"Search criteria");
        ValidateUtil.validatePositiveNumber((long)limit, (String)"Search limit");
        return (PrincipalDiscovery.SearchResult)new VmomiClientCommand<PrincipalDiscovery.SearchResult>(){

            @Override
            public PrincipalDiscovery.SearchResult actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(PrincipalDiscoveryImpl.this._vmomiDiscoveryService.find(VmodlTypeConversions.toVmodl((PrincipalDiscovery.SearchCriteria)criteria), limit));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<Group> findDirectParentGroups(final PrincipalId principalId) throws InvalidPrincipalException, SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)principalId, (String)"Principal Id");
        return (Set)new VmomiClientCommand<Set<Group>>(){

            @Override
            public Set<Group> actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.Group[])PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findDirectParentGroups(VmodlTypeConversions.toVmodl((PrincipalId)principalId)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public Group findGroup(final PrincipalId groupId) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)groupId, (String)"Group Id");
        return (Group)new VmomiClientCommand<Group>(){

            @Override
            public Group actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.Group)PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findGroup(VmodlTypeConversions.toVmodl((PrincipalId)groupId)));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<Group> findGroups(final PrincipalDiscovery.SearchCriteria criteria, final int limit) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)criteria, (String)"Search criteria");
        ValidateUtil.validatePositiveNumber((long)limit, (String)"Search limit");
        return (Set)new VmomiClientCommand<Set<Group>>(){

            @Override
            public Set<Group> actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.Group[])PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findGroups(VmodlTypeConversions.toVmodl((PrincipalDiscovery.SearchCriteria)criteria), limit));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<Group> findGroupsInGroup(final PrincipalId groupId, final String searchString, final int limit) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)groupId, (String)"Group Id");
        ValidateUtil.validateNotNull((Object)searchString, (String)"Search string");
        ValidateUtil.validatePositiveNumber((long)limit, (String)"Search limit");
        return (Set)new VmomiClientCommand<Set<Group>>(){

            @Override
            public Set<Group> actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.Group[])PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findGroupsInGroup(VmodlTypeConversions.toVmodl((PrincipalId)groupId), searchString, limit));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public Set<PersonUser> findLockedUsers(final String searchString, final int limit) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)searchString, (String)"Search string");
        ValidateUtil.validatePositiveNumber((long)limit, (String)"Search limit");
        return (Set)new VmomiClientCommand<Set<PersonUser>>(){

            @Override
            public Set<PersonUser> actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.PersonUser[])PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findLockedUsers(searchString, limit));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<Group> findNestedParentGroups(final PrincipalId userId) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)userId, (String)"User Id");
        return (Set)new VmomiClientCommand<Set<Group>>(){

            @Override
            public Set<Group> actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.Group[])PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findNestedParentGroups(VmodlTypeConversions.toVmodl((PrincipalId)userId)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public PersonUser findPersonUser(final PrincipalId userId) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)userId, (String)"User Id");
        return (PersonUser)new VmomiClientCommand<PersonUser>(){

            @Override
            public PersonUser actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.PersonUser)PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findPersonUser(VmodlTypeConversions.toVmodl((PrincipalId)userId)));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<PersonUser> findPersonUsers(final PrincipalDiscovery.SearchCriteria criteria, final int limit) throws NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)criteria, (String)"Search criteria");
        ValidateUtil.validatePositiveNumber((long)limit, (String)"Search limit");
        return (Set)new VmomiClientCommand<Set<PersonUser>>(){

            @Override
            public Set<PersonUser> actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.PersonUser[])PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findPersonUsers(VmodlTypeConversions.toVmodl((PrincipalDiscovery.SearchCriteria)criteria), limit));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<PersonUser> findPersonUsersInGroup(final PrincipalId groupId, final String searchString, final int limit) throws NotAuthenticatedException, InvalidPrincipalException, SystemException {
        ValidateUtil.validateNotNull((Object)groupId, (String)"Group Id");
        ValidateUtil.validateNotNull((Object)searchString, (String)"Search string");
        ValidateUtil.validatePositiveNumber((long)limit, (String)"Search limit");
        return (Set)new VmomiClientCommand<Set<PersonUser>>(){

            @Override
            public Set<PersonUser> actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.PersonUser[])PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findPersonUsersInGroup(VmodlTypeConversions.toVmodl((PrincipalId)groupId), searchString, limit));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public SolutionUser findSolutionUser(final String userName) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)userName, (String)"User name");
        return (SolutionUser)new VmomiClientCommand<SolutionUser>(){

            @Override
            public SolutionUser actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findSolutionUser(userName));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public SolutionUser findSolutionUserByCertDN(final String certDN) throws NotAuthenticatedException {
        ValidateUtil.validateNotEmpty((Object)certDN, (String)"certificate DN");
        return (SolutionUser)new VmomiClientCommand<SolutionUser>(){

            @Override
            public SolutionUser actionCommand() {
                return SdkVmodlTypeConversions.fromVmodl(PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findSolutionUserByCertDN(certDN));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<SolutionUser> findSolutionUsers(final String searchString, final int limit) throws NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)searchString, (String)"Search string");
        ValidateUtil.validatePositiveNumber((long)limit, (String)"Search limit");
        return (Set)new VmomiClientCommand<Set<SolutionUser>>(){

            @Override
            public Set<SolutionUser> actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findSolutionUsers(searchString, limit));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<SolutionUser> findSolutionUsersInGroup(final String groupName, final String searchString, final int limit) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotEmpty((Object)groupName, (String)"Group name");
        ValidateUtil.validateNotNull((Object)searchString, (String)"Search string");
        ValidateUtil.validatePositiveNumber((long)limit, (String)"Search limit");
        return (Set)new VmomiClientCommand<Set<SolutionUser>>(){

            @Override
            public Set<SolutionUser> actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findSolutionUsersInGroup(groupName, searchString, limit));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public Set<PersonUser> findDisabledPersonUsers(final String searchString, final int limit) throws NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)searchString, (String)"Search string");
        ValidateUtil.validatePositiveNumber((long)limit, (String)"Search limit");
        return (Set)new VmomiClientCommand<Set<PersonUser>>(){

            @Override
            public Set<PersonUser> actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findDisabledPersonUsers(searchString, limit));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<SolutionUser> findDisabledSolutionUsers(final String searchString) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)searchString, (String)"Search string");
        return (Set)new VmomiClientCommand<Set<SolutionUser>>(){

            @Override
            public Set<SolutionUser> actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findDisabledSolutionUsers(searchString));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public PrincipalDiscovery.SearchResult findUser(final String user) throws NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)user, (String)"user");
        return (PrincipalDiscovery.SearchResult)new VmomiClientCommand<PrincipalDiscovery.SearchResult>(){

            @Override
            public PrincipalDiscovery.SearchResult actionCommand() throws ServiceFault {
                return SdkVmodlTypeConversions.fromVmodl(PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findUserAccount(user));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Group findGroup(final String group) throws NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)group, (String)"group");
        return (Group)new VmomiClientCommand<Group>(){

            @Override
            public Group actionCommand() throws ServiceFault, RuntimeServiceFault {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.Group)PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findGroupAccount(group));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public PersonUser findRegisteredExternalIDPUser(final PrincipalId userId) throws NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotNull((Object)userId, (String)"User Id");
        return (PersonUser)new VmomiClientCommand<PersonUser>(){

            @Override
            public PersonUser actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.PersonUser)PrincipalDiscoveryImpl.this._vmomiDiscoveryService.findRegisteredExternalIDPUser(VmodlTypeConversions.toVmodl((PrincipalId)userId)));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<String> getImplicitGroupNames() {
        return (Set)new VmomiClientCommand<Set<String>>(){

            @Override
            public Set<String> actionCommand() {
                HashSet<String> groups = new HashSet<String>();
                groups.addAll(Arrays.asList(PrincipalDiscoveryImpl.this._vmomiDiscoveryService.getImplicitGroupNames()));
                return Collections.unmodifiableSet(groups);
            }
        }.executeEnsuringNoDomainError();
    }
}

