/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.DomainManagementService;
import com.vmware.vim.binding.sso.admin.ExternalDomain;
import com.vmware.vim.binding.sso.admin.IdentitySourceManagementService;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.Domains;
import com.vmware.vim.sso.admin.ExternalDomain;
import com.vmware.vim.sso.admin.ExternalDomainAttributeMapping;
import com.vmware.vim.sso.admin.ExternalDomainDetails;
import com.vmware.vim.sso.admin.ExternalDomainObjectMapping;
import com.vmware.vim.sso.admin.ExternalDomainSchemaDetails;
import com.vmware.vim.sso.admin.Group;
import com.vmware.vim.sso.admin.IdentitySourceManagement;
import com.vmware.vim.sso.admin.MailContent;
import com.vmware.vim.sso.admin.PersonDetails;
import com.vmware.vim.sso.admin.PersonUser;
import com.vmware.vim.sso.admin.PrincipalDiscovery;
import com.vmware.vim.sso.admin.SolutionDetails;
import com.vmware.vim.sso.admin.SolutionUser;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import com.vmware.vim.sso.client.util.codec.Base64;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class SdkVmodlTypeConversions {
    private static final String FACTORY_TYPE = "X.509";
    private static final CertificateFactory _x509CertificateFactory;

    SdkVmodlTypeConversions() {
    }

    public static SolutionUser fromVmodl(com.vmware.vim.binding.sso.admin.SolutionUser data) {
        return data != null ? new SolutionUser(VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)data.getId()), VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)data.getAlias()), SdkVmodlTypeConversions.fromVmodl(data.getDetails()), data.isDisabled(), data.getExternal() != null ? data.getExternal() : false) : null;
    }

    public static Set<SolutionUser> fromVmodl(com.vmware.vim.binding.sso.admin.SolutionUser[] data) {
        HashSet<SolutionUser> result = new HashSet<SolutionUser>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.admin.SolutionUser user : data) {
                result.add(SdkVmodlTypeConversions.fromVmodl(user));
            }
        }
        return result;
    }

    public static PersonUser fromVmodl(com.vmware.vim.binding.sso.admin.PersonUser data) {
        return data != null ? new PersonUser(VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)data.getId()), VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)data.getAlias()), SdkVmodlTypeConversions.fromVmodl(data.getDetails()), data.isDisabled(), data.isLocked()) : null;
    }

    public static Set<PersonUser> fromVmodl(com.vmware.vim.binding.sso.admin.PersonUser[] data) {
        HashSet<PersonUser> result = new HashSet<PersonUser>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.admin.PersonUser user : data) {
                result.add(SdkVmodlTypeConversions.fromVmodl(user));
            }
        }
        return result;
    }

    public static PrincipalDiscovery.SearchResult fromVmodl(PrincipalDiscoveryService.SearchResult data) {
        return data != null ? new SearchResultImpl(VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.Group[])data.getGroups()), VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.PersonUser[])data.getPersonUsers()), SdkVmodlTypeConversions.fromVmodl(data.getSolutionUsers())) : new SearchResultImpl(new HashSet<Group>(), new HashSet<PersonUser>(), new HashSet<SolutionUser>());
    }

    public static SolutionDetails fromVmodl(com.vmware.vim.binding.sso.admin.SolutionDetails vmodlData) {
        SolutionDetails data = null;
        if (vmodlData != null) {
            X509Certificate cert = VmodlTypeConversions.certificateFromVmodl((String)vmodlData.getCertificate());
            String description = vmodlData.getDescription();
            data = description != null ? new SolutionDetails(cert, description) : new SolutionDetails(cert);
        }
        return data;
    }

    public static PersonDetails fromVmodl(com.vmware.vim.binding.sso.admin.PersonDetails vmodlData) {
        return vmodlData != null ? new PersonDetails.Builder().setFirstName(vmodlData.getFirstName()).setLastName(vmodlData.getLastName()).setDescription(vmodlData.getDescription()).setEmailAddress(vmodlData.getEmailAddress()).setUserPrincipalName(vmodlData.getUserPrincipalName()).createPersonDetails() : null;
    }

    public static Set<PrincipalId> fromVmodl(com.vmware.vim.binding.sso.PrincipalId[] data) {
        HashSet<PrincipalId> result = new HashSet<PrincipalId>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.PrincipalId principal : data) {
                result.add(VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)principal));
            }
        }
        return result;
    }

    public static CertPath fromVmodl(ConfigurationManagementService.CertificateChain vmodlData) {
        CertPath data = null;
        if (vmodlData != null) {
            try {
                ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
                for (String certsEncoded : vmodlData.getCertificates()) {
                    certs.add(VmodlTypeConversions.certificateFromVmodl((String)certsEncoded));
                }
                data = _x509CertificateFactory.generateCertPath(certs);
            }
            catch (CertificateException e) {
                throw new IllegalArgumentException("Failed to create CertPath from the given certificate list", e);
            }
        }
        return data;
    }

    public static Set<CertPath> fromVmodl(ConfigurationManagementService.CertificateChain[] data) {
        HashSet<CertPath> result = new HashSet<CertPath>();
        if (data != null) {
            for (ConfigurationManagementService.CertificateChain chain : data) {
                result.add(SdkVmodlTypeConversions.fromVmodl(chain));
            }
        }
        return result;
    }

    public static ExternalDomain fromVmodl(com.vmware.vim.binding.sso.admin.ExternalDomain data) {
        ExternalDomain result = null;
        if (data != null) {
            result = new ExternalDomain(data.getName(), data.getAlias(), ExternalDomain.Type.valueOf((String)data.getType()), SdkVmodlTypeConversions.fromVmodl(data.getDetails()), SdkVmodlTypeConversions.fromVmodl(data.getAuthenticationDetails()));
        }
        return result;
    }

    private static ExternalDomainDetails fromVmodl(com.vmware.vim.binding.sso.admin.ExternalDomainDetails data) {
        return data != null ? new ExternalDomainDetails(data.getFriendlyName(), data.getUserBaseDn(), data.getGroupBaseDn(), data.getPrimaryUrl(), data.getFailoverUrl(), data.getSearchTimeoutSeconds(), SdkVmodlTypeConversions.fromVmodl(data.getSchemaDetails()), (Set)(data.getUpnSuffixes() != null ? new HashSet<String>(Arrays.asList(data.getUpnSuffixes())) : null)) : null;
    }

    private static ExternalDomainSchemaDetails fromVmodl(com.vmware.vim.binding.sso.admin.ExternalDomainSchemaDetails data) {
        ExternalDomainSchemaDetails schemaDetails = null;
        if (data != null) {
            ExternalDomainSchemaDetails.Builder builder = new ExternalDomainSchemaDetails.Builder();
            for (com.vmware.vim.binding.sso.admin.ExternalDomainObjectMapping objectMapping : data.getObjectMappings()) {
                builder.addObjectMapping(SdkVmodlTypeConversions.fromVmodl(objectMapping));
            }
            schemaDetails = builder.buildSchemaDetails();
        }
        return schemaDetails;
    }

    private static ExternalDomainObjectMapping fromVmodl(com.vmware.vim.binding.sso.admin.ExternalDomainObjectMapping data) {
        ExternalDomainObjectMapping objectMapping = null;
        if (data != null) {
            ExternalDomainObjectMapping.Builder builder = new ExternalDomainObjectMapping.Builder(data.getObjectId());
            builder.setObjectClass(data.getObjectClass());
            for (com.vmware.vim.binding.sso.admin.ExternalDomainAttributeMapping attributeMapping : data.getAttributeMappings()) {
                builder.addAttributeMapping(SdkVmodlTypeConversions.fromVmodl(attributeMapping));
            }
            objectMapping = builder.buildObjectMapping();
        }
        return objectMapping;
    }

    private static ExternalDomainAttributeMapping fromVmodl(com.vmware.vim.binding.sso.admin.ExternalDomainAttributeMapping data) {
        ExternalDomainAttributeMapping attributeMapping = null;
        if (data != null) {
            attributeMapping = new ExternalDomainAttributeMapping(data.getAttributeId(), data.getAttributeName());
        }
        return attributeMapping;
    }

    private static ExternalDomain.AuthenticationDetails fromVmodl(ExternalDomain.AuthenticationDetails data) {
        return data != null ? new ExternalDomain.AuthenticationDetails(SdkVmodlTypeConversions.createAuthType(data.getAuthenticationType()), data.getUsername()) : null;
    }

    private static ExternalDomain.AuthenticationType createAuthType(String data) {
        ExternalDomain.AuthenticationType result = null;
        if (data == null) {
            return null;
        }
        if (data.equals(ExternalDomain.AuthenticationType.anonymous.name())) {
            result = ExternalDomain.AuthenticationType.anonymous;
        } else if (data.equals(ExternalDomain.AuthenticationType.password.name())) {
            result = ExternalDomain.AuthenticationType.password;
        } else if (data.equals(ExternalDomain.AuthenticationType.reuseSession.name())) {
            result = ExternalDomain.AuthenticationType.reuseSession;
        } else {
            throw new IllegalStateException("Unknown AuthenticatioType " + data);
        }
        return result;
    }

    public static Domains fromVmodl(com.vmware.vim.binding.sso.admin.Domains data) {
        Domains result = null;
        if (data != null) {
            String localOSDomainName = data.getLocalOSDomainName();
            Set systemDomainUpnSuffixes = Collections.emptySet();
            if (data.getSystemDomainUpnSuffixes() != null) {
                systemDomainUpnSuffixes = new HashSet<String>(Arrays.asList(data.getSystemDomainUpnSuffixes()));
            }
            result = localOSDomainName != null ? new Domains(SdkVmodlTypeConversions.fromVmodl(data.getExternalDomains()), data.getSystemDomainName(), localOSDomainName, systemDomainUpnSuffixes) : new Domains(SdkVmodlTypeConversions.fromVmodl(data.getExternalDomains()), data.getSystemDomainName(), systemDomainUpnSuffixes);
        }
        return result;
    }

    private static Set<ExternalDomain> fromVmodl(com.vmware.vim.binding.sso.admin.ExternalDomain[] data) {
        HashSet<ExternalDomain> result = new HashSet<ExternalDomain>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.admin.ExternalDomain domain : data) {
                result.add(SdkVmodlTypeConversions.fromVmodl(domain));
            }
        }
        return result;
    }

    public static Set<X509Certificate> certificateSetFromVmodl(String[] data) {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>();
        if (data != null) {
            for (String base64Cert : data) {
                result.add(VmodlTypeConversions.certificateFromVmodl((String)base64Cert));
            }
        }
        return result;
    }

    public static IdentitySourceManagementService.AuthenticationCredentials toVmodl(IdentitySourceManagement.AuthenticationCredentials data) {
        IdentitySourceManagementService.AuthenticationCredentials result = null;
        if (data != null) {
            result = new IdentitySourceManagementService.AuthenticationCredentials();
            result.setPassword(new String(data.getPassword()));
            result.setUsername(data.getUsername());
            result.setSpn(data.getSpn());
        }
        return result;
    }

    public static DomainManagementService.AuthenticationCredentails toVmodl(DomainManagement.AuthenticationCredentails data) {
        DomainManagementService.AuthenticationCredentails result = null;
        if (data != null) {
            result = new DomainManagementService.AuthenticationCredentails();
            result.setPassword(new String(data.getPassword()));
            result.setUsername(data.getUsername());
            result.setSpn(data.getSpn());
        }
        return result;
    }

    public static com.vmware.vim.binding.sso.PrincipalId[] toVmodl(Set<PrincipalId> data) {
        com.vmware.vim.binding.sso.PrincipalId[] result = new com.vmware.vim.binding.sso.PrincipalId[data.size()];
        int i = 0;
        for (PrincipalId principal : data) {
            result[i++] = VmodlTypeConversions.toVmodl((PrincipalId)principal);
        }
        return result;
    }

    public static String toVmodl(PrivateKey data) {
        return Base64.encodeBase64String((byte[])data.getEncoded());
    }

    public static ConfigurationManagementService.CertificateChain toVmodl(CertPath data) {
        ConfigurationManagementService.CertificateChain vmodlData = null;
        if (data != null) {
            vmodlData = new ConfigurationManagementService.CertificateChain();
            List<? extends Certificate> pathCerts = data.getCertificates();
            String[] certsEncoded = new String[pathCerts.size()];
            for (int i = 0; i < pathCerts.size(); ++i) {
                try {
                    certsEncoded[i] = VmodlTypeConversions.certificateToVmodl((X509Certificate)((X509Certificate)pathCerts.get(i)));
                    continue;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Only X.509 certificates are supported", e);
                }
            }
            vmodlData.setCertificates(certsEncoded);
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.MailContent toVmodl(MailContent data) {
        assert (data != null);
        return new com.vmware.vim.binding.sso.admin.MailContent(data.getFrom(), data.getTo(), data.getSubject(), data.getContent());
    }

    static {
        try {
            _x509CertificateFactory = CertificateFactory.getInstance(FACTORY_TYPE);
        }
        catch (CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class SearchResultImpl
    implements PrincipalDiscovery.SearchResult {
        private final Set<Group> _groups;
        private final Set<PersonUser> _personUsers;
        private final Set<SolutionUser> _solutionUsers;

        SearchResultImpl(Set<Group> groups, Set<PersonUser> personUsers, Set<SolutionUser> solutionUsers) {
            this._groups = Collections.unmodifiableSet(groups);
            this._personUsers = Collections.unmodifiableSet(personUsers);
            this._solutionUsers = Collections.unmodifiableSet(solutionUsers);
        }

        public Set<Group> getGroups() {
            return this._groups;
        }

        public Set<PersonUser> getPersonUsers() {
            return this._personUsers;
        }

        public Set<SolutionUser> getSolutionUsers() {
            return this._solutionUsers;
        }
    }
}

