/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install;

import com.vmware.vim.sso.admin.client.vmomi.VmomiClientConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.Validate;

public final class RegistrationProviderConfig {
    private final URI _lsAddress;
    private final ThumbprintVerifier _verifier;
    private final KeyStore _trustStore;
    private final AuthnType _authnType;
    private final String _username;
    private final char[] _password;
    private final PrivateKey _solutionPrivateKey;
    private final X509Certificate _solutionCertificate;
    private final VmomiClientConfiguration.Version _ssoVersion;
    private final SsoConnectionConfig _connectionConfig;

    private RegistrationProviderConfig(URI lsAddress, ThumbprintVerifier verifier, KeyStore trustStore, AuthnType authnType, String username, char[] password, PrivateKey solutionPrivateKey, X509Certificate solutionCert, VmomiClientConfiguration.Version version, SsoConnectionConfig connConfig) {
        this._lsAddress = lsAddress;
        this._verifier = verifier;
        this._trustStore = trustStore;
        this._authnType = authnType;
        this._username = username;
        this._password = password;
        this._solutionPrivateKey = solutionPrivateKey;
        this._solutionCertificate = solutionCert;
        this._ssoVersion = version;
        this._connectionConfig = connConfig;
    }

    public URI getLsAddress() {
        return this._lsAddress;
    }

    public ThumbprintVerifier getVerifier() {
        return this._verifier;
    }

    public KeyStore getTrustStore() {
        return this._trustStore;
    }

    public AuthnType getAuthnType() {
        return this._authnType;
    }

    public String getUsername() {
        return this._username;
    }

    public char[] getPassword() {
        return this._password;
    }

    public PrivateKey getSolutionPrivateKey() {
        return this._solutionPrivateKey;
    }

    public X509Certificate getSolutionCertificate() {
        return this._solutionCertificate;
    }

    public VmomiClientConfiguration.Version getSsoVersion() {
        return this._ssoVersion;
    }

    public SsoConnectionConfig getSsoConnectionConfig() {
        return this._connectionConfig;
    }

    public static final class Builder {
        private final URI _lsAddress;
        private ThumbprintVerifier _verifier;
        private KeyStore _trustStore;
        private AuthnType _authnType;
        private String _username;
        private char[] _password;
        private PrivateKey _solutionPrivateKey;
        private X509Certificate _solutionCertificate;
        private VmomiClientConfiguration.Version _ssoVersion;
        private SsoConnectionConfig _connectionConfig;

        public Builder(URI lsAddress) {
            Validate.notNull(lsAddress, "Parameter `lsAddress' cannot be null.");
            this._lsAddress = lsAddress;
            this._verifier = null;
            this._trustStore = null;
            this._ssoVersion = VmomiClientConfiguration.Version.Version1;
            this._connectionConfig = null;
            this.withAnonymousAuthn();
        }

        public Builder withAnonymousAuthn() {
            this._authnType = AuthnType.Anonymous;
            this._username = null;
            this._password = null;
            this._solutionPrivateKey = null;
            this._solutionCertificate = null;
            return this;
        }

        public Builder withThumbprintVerifier(ThumbprintVerifier verifier) {
            this._verifier = verifier;
            return this;
        }

        public Builder withTrustStore(KeyStore trustStore) {
            this._trustStore = trustStore;
            return this;
        }

        public Builder withUserAthn(String username, char[] password) {
            Validate.notEmpty(username, "Parameter `username` cannot be empty or null.");
            Validate.notNull(password, "Parameter `password` cannot be null.");
            if (this._authnType == AuthnType.Certificate) {
                throw new IllegalStateException("Certificate authentication already selected.");
            }
            this._authnType = AuthnType.Password;
            this._username = username;
            this._password = password;
            this._solutionPrivateKey = null;
            this._solutionCertificate = null;
            return this;
        }

        public Builder withSolutionAuthn(PrivateKey solutionPrivateKey, X509Certificate solutionCert) {
            Validate.notNull(solutionPrivateKey, "Parameter `solutionPrivateKey' cannot be null.");
            Validate.notNull(solutionCert, "Parameter `solutionCert' cannot be null.");
            if (this._authnType == AuthnType.Password) {
                throw new IllegalStateException("Password authentication already selected.");
            }
            this._authnType = AuthnType.Certificate;
            this._username = null;
            this._password = null;
            this._solutionPrivateKey = solutionPrivateKey;
            this._solutionCertificate = solutionCert;
            return this;
        }

        public Builder withVersion(VmomiClientConfiguration.Version version) {
            this._ssoVersion = version;
            return this;
        }

        public Builder withSsoConfig(SsoConnectionConfig config) {
            this._connectionConfig = config;
            return this;
        }

        public RegistrationProviderConfig create() {
            return new RegistrationProviderConfig(this._lsAddress, this._verifier, this._trustStore, this._authnType, this._username, this._password, this._solutionPrivateKey, this._solutionCertificate, this._ssoVersion, this._connectionConfig);
        }
    }

    public static final class SsoConnectionConfig {
        private final URI _stsAddress;
        private final URI _adminAddress;
        private final X509Certificate[] _ssoTrustStore;

        public SsoConnectionConfig(URI stsAddress, URI adminAddress, X509Certificate[] ssoTrustStore) {
            Validate.notNull(stsAddress, "STS address cannot be null");
            Validate.notNull(adminAddress, "Admin address cannot be null");
            Validate.notNull(ssoTrustStore, "Trust store for SSO server cannot be null");
            this._stsAddress = stsAddress;
            this._adminAddress = adminAddress;
            this._ssoTrustStore = ssoTrustStore;
        }

        public URI getStsAddress() {
            return this._stsAddress;
        }

        public URI getAdminAddress() {
            return this._adminAddress;
        }

        public X509Certificate[] getSsoTrustStore() {
            return this._ssoTrustStore;
        }
    }

    public static enum AuthnType {
        Password,
        Certificate,
        Anonymous;

    }
}

