/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install;

import com.vmware.vim.install.RegistrationProviderConfig;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.exception.ClockSynchronizationException;
import com.vmware.vim.install.exception.ConnectionException;
import com.vmware.vim.install.exception.InvalidCredentialsException;
import com.vmware.vim.install.exception.RegistrationException;
import com.vmware.vim.install.impl.RegistrationProviderImpl;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class RegistrationProviderFactory {
    public static final RegistrationServiceProvider getRegistrationProvider(URI lsAddress, String username, char[] password, ThumbprintVerifier verifier) throws ConnectionException, InvalidCredentialsException, ClockSynchronizationException, RegistrationException {
        return RegistrationProviderFactory.getRegistrationProvider(new RegistrationProviderConfig.Builder(lsAddress).withUserAthn(username, password).withThumbprintVerifier(verifier).create());
    }

    public static final RegistrationServiceProvider getRegistrationProvider(URI lsAddress, X509Certificate solutionCert, PrivateKey privateKey, ThumbprintVerifier verifier) throws ConnectionException, InvalidCredentialsException, ClockSynchronizationException, RegistrationException {
        return RegistrationProviderFactory.getRegistrationProvider(new RegistrationProviderConfig.Builder(lsAddress).withSolutionAuthn(privateKey, solutionCert).withThumbprintVerifier(verifier).create());
    }

    public static final RegistrationServiceProvider getRegistrationProvider(URI lsAddress, ThumbprintVerifier verifier) throws ConnectionException, RegistrationException {
        return RegistrationProviderFactory.getRegistrationProvider(new RegistrationProviderConfig.Builder(lsAddress).withAnonymousAuthn().withThumbprintVerifier(verifier).create());
    }

    public static final RegistrationServiceProvider getRegistrationProvider(RegistrationProviderConfig config) throws ConnectionException, InvalidCredentialsException, ClockSynchronizationException, RegistrationException {
        return new RegistrationProviderImpl(config);
    }
}

