/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli;

import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandFactory;
import com.vmware.vim.install.exception.IncompatibleVersionException;
import com.vmware.vim.vmomi.client.exception.ClientException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.VmomiProtocolException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegTool {
    private static final Log _log = LogFactory.getLog(RegTool.class);
    private static final String fileId = "$Id: //depot/vicore/vicore-2013-rel/regtool/viregtool/src/main/java/com/vmware/vim/install/cli/RegTool.java#4 $";

    public static void main(String[] args) {
        RegTool.process(args, true);
    }

    public static void process(String[] args, boolean allowNonCrudCommands) {
        ReturnCode code;
        if (_log.isDebugEnabled()) {
            _log.debug(fileId);
            StringBuilder command = new StringBuilder("Executing command: ");
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (i > 0 && ("-p".equals(args[i - 1]) || "--password".equals(args[i - 1]))) {
                    arg = "*****";
                }
                command.append(arg).append(' ');
            }
            _log.debug(command.toString());
        }
        if (args.length == 0 || args.length == 1 && args[0] == "-h") {
            code = RegTool.invalidCommand(allowNonCrudCommands);
        } else {
            Commands commandType = null;
            try {
                commandType = Commands.valueOf(args[0]);
                if (!allowNonCrudCommands && !commandType.isCrudCommand()) {
                    commandType = null;
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException e) {
                String cmd = args[0];
                RegTool.logInvalidCommand(cmd);
            }
            try {
                String[] cmdArgs = new String[args.length - 1];
                if (cmdArgs.length > 0) {
                    System.arraycopy(args, 1, cmdArgs, 0, args.length - 1);
                }
                if (commandType != null) {
                    switch (commandType) {
                        case validateLsConnection: {
                            code = RegTool.execute(CommandFactory.createValidateLsCommand(cmdArgs));
                            break;
                        }
                        case registerService: {
                            code = RegTool.execute(CommandFactory.createRegisterServiceCommand(cmdArgs));
                            break;
                        }
                        case unregisterService: {
                            code = RegTool.execute(CommandFactory.createUnregisterServiceCommand(cmdArgs));
                            break;
                        }
                        case validateSsoConnection: {
                            code = RegTool.execute(CommandFactory.createValidateSsoCommand(cmdArgs));
                            break;
                        }
                        case registerSolution: {
                            code = RegTool.execute(CommandFactory.createRegisterSolutionCommand(cmdArgs));
                            break;
                        }
                        case unregisterSolution: {
                            code = RegTool.execute(CommandFactory.createUnregisterSolutionCommand(cmdArgs));
                            break;
                        }
                        case validateUsername: {
                            code = RegTool.execute(CommandFactory.createValidateUsernameCommand(cmdArgs));
                            break;
                        }
                        case checkPrincipalExists: {
                            code = RegTool.execute(CommandFactory.createCheckPrincipalExistsCommand(cmdArgs));
                            break;
                        }
                        case assignUserRole: {
                            code = RegTool.execute(CommandFactory.createAssignUserRoleCommand(cmdArgs));
                            break;
                        }
                        case storeSsoData: {
                            code = RegTool.execute(CommandFactory.createStoreSsoDataCommand(cmdArgs));
                            break;
                        }
                        case registerDomain: {
                            code = RegTool.execute(CommandFactory.createRegisterDomainCommand(cmdArgs));
                            break;
                        }
                        case updateService: {
                            code = RegTool.execute(CommandFactory.createUpdateServiceCommand(cmdArgs));
                            break;
                        }
                        case updateSolution: {
                            code = RegTool.execute(CommandFactory.createUpdateSolutionCommand(cmdArgs));
                            break;
                        }
                        case checkDomainExists: {
                            code = RegTool.execute(CommandFactory.createCheckDomainExistsCommand(cmdArgs));
                            break;
                        }
                        case listServices: {
                            code = RegTool.execute(CommandFactory.createListServicesCommand(cmdArgs));
                            break;
                        }
                        case changePassword: {
                            code = RegTool.execute(CommandFactory.createChangePasswordCommand(cmdArgs));
                            break;
                        }
                        case checkVersion: {
                            code = RegTool.execute(CommandFactory.createCheckVersionCommand(cmdArgs));
                            break;
                        }
                        case importServices: {
                            code = RegTool.execute(CommandFactory.createImportServicesCommand(cmdArgs));
                            break;
                        }
                        default: {
                            code = RegTool.invalidCommand(allowNonCrudCommands);
                            break;
                        }
                    }
                } else {
                    code = RegTool.invalidCommand(allowNonCrudCommands);
                }
            }
            catch (Throwable e) {
                _log.error("Unhandled exception tries to escape: " + e.getMessage());
                _log.debug("", e);
                code = ReturnCode.OperationFailed;
            }
        }
        _log.info("Return code is: " + (Object)((Object)code));
        System.exit(code.getValue());
    }

    public static void logInvalidCommand(String cmd) {
        _log.error(cmd + " is not a valid command");
    }

    private static ReturnCode execute(Command command) {
        try {
            return command.execute();
        }
        catch (IncompatibleVersionException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            return ReturnCode.VersionLower;
        }
        catch (IllegalArgumentException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            return ReturnCode.InvalidInput;
        }
        catch (IllegalStateException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            return ReturnCode.InvalidEnvironment;
        }
        catch (SslException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            return ReturnCode.SslHandshakeFailed;
        }
        catch (VmomiProtocolException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            return ReturnCode.VmomiError;
        }
        catch (ClientException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            return ReturnCode.ServiceNotResponding;
        }
        catch (Throwable t) {
            _log.error(t.getMessage());
            _log.debug("", t);
            return ReturnCode.OperationFailed;
        }
    }

    private static ReturnCode invalidCommand(boolean allowAllCommands) {
        RegTool.printUsage(allowAllCommands);
        return ReturnCode.InvalidCommand;
    }

    private static void printUsage(boolean allowAllCommands) {
        _log.info("Usage: [COMMAND] [params]");
        _log.info("Supported commands: \n");
        String fill = "\n" + StringUtils.repeat(" ", 30);
        for (Commands command : Commands.values()) {
            if (!allowAllCommands && !command.isCrudCommand()) continue;
            String help = StringUtils.join((Object[])StringUtils.split(command.getValue(), "\n"), fill);
            _log.info(String.format("%-30s%-50s%n", command.name(), help));
        }
    }
}

