/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.ChangePasswordForm;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.PrincipalManagement;
import com.vmware.vim.sso.admin.client.InvalidCredentialsException;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.PasswordPolicyViolationException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ChangePasswordCommand
implements Command {
    private static final String MSG_USE_SYSTEM_DOMAIN = "Use unqualified name. This command only works with SSO system users and the system domain is always inferred.";
    private static final Log _log = LogFactory.getLog(ChangePasswordCommand.class);
    private final DomainManagement _domainMgmt;
    private final PrincipalManagement _principalMgmt;
    private final ChangePasswordForm _form;

    public ChangePasswordCommand(DomainManagement domainMgmt, PrincipalManagement principalMgmt, ChangePasswordForm form) {
        this._domainMgmt = domainMgmt;
        this._principalMgmt = principalMgmt;
        this._form = form;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode status;
        String systemUsername = this.getUnqualifiedUsername();
        try {
            _log.info("Changing password for system user: " + systemUsername);
            char[] oldPassword = this._form.getOldPassword() == null ? this.readOldPassword() : this._form.getOldPassword().toCharArray();
            char[] newPassword = this._form.getNewPassword() == null ? this.readNewPassword() : this._form.getNewPassword().toCharArray();
            this._principalMgmt.resetLocalPersonUserPassword(systemUsername, oldPassword, newPassword);
            status = ReturnCode.Success;
        }
        catch (InvalidCredentialsException e) {
            _log.error(String.format("The provided current password for user `%s' is not valid.", systemUsername));
            _log.trace("", e);
            status = ReturnCode.InvalidCredentials;
        }
        catch (InvalidPrincipalException e) {
            _log.error("There is no system user with name: " + systemUsername);
            _log.trace("", e);
            status = ReturnCode.InvalidUser;
        }
        catch (PasswordPolicyViolationException e) {
            _log.error("The new password provided does not match the currently effective password policy: " + e.getMessage());
            _log.trace("", e);
            status = ReturnCode.InvalidInput;
        }
        return status;
    }

    private String getUnqualifiedUsername() {
        String unqualifiedName;
        String username = this._form.getUsername();
        int upnIndex = username.indexOf("@");
        int netbiosIndex = username.indexOf("\\");
        if (upnIndex != -1 && netbiosIndex != -1) {
            throw new IllegalArgumentException(String.format("Username `%s' is in invalid format. %s", username, MSG_USE_SYSTEM_DOMAIN));
        }
        if (upnIndex != -1 || netbiosIndex != -1) {
            String domain;
            if (upnIndex != -1) {
                unqualifiedName = username.substring(0, upnIndex);
                domain = username.substring(upnIndex + 1);
            } else if (netbiosIndex != -1) {
                domain = username.substring(0, netbiosIndex);
                unqualifiedName = username.substring(netbiosIndex + 1);
            } else {
                throw new IllegalStateException();
            }
            if (!this._domainMgmt.getSystemDomainName().equalsIgnoreCase(domain)) {
                throw new IllegalArgumentException(String.format("User `%s' with domain `%s' is not a system user. %s", username, domain, MSG_USE_SYSTEM_DOMAIN));
            }
        } else {
            unqualifiedName = username;
        }
        return unqualifiedName;
    }

    private char[] readOldPassword() {
        return ChangePasswordCommand.readPassword("Enter the current password");
    }

    private char[] readNewPassword() {
        char[] newPass = new char[]{};
        boolean havePassword = false;
        while (!havePassword) {
            char[] newPassConfirm;
            newPass = ChangePasswordCommand.readPassword("Enter the new password");
            if (ArrayUtils.isEquals(newPass, newPassConfirm = ChangePasswordCommand.readPassword("Re-enter the new password"))) {
                havePassword = true;
                continue;
            }
            System.out.println("Passwords do not match");
        }
        return newPass;
    }

    private static char[] readPassword(String msg) {
        System.out.flush();
        System.out.print(msg + ": ");
        return System.console().readPassword();
    }
}

