/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.sso.admin.client.AdminClient;
import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckVersionCommand
implements Command {
    private static final Log _log = LogFactory.getLog(CheckVersionCommand.class);
    private final AdminClient _adminClient;
    private final BigDecimal _version;

    public CheckVersionCommand(RegistrationServiceProvider provider, BigDecimal version) {
        this._adminClient = provider.getAdminService();
        this._version = version;
        if (_log.isDebugEnabled()) {
            _log.debug(String.format("Executing command with parameter version='%s'", version));
        }
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code;
        block3: {
            code = ReturnCode.OperationFailed;
            String serverVersionStr = this._adminClient.getAboutInfo().getVersion();
            if (_log.isInfoEnabled()) {
                _log.info(String.format("Server version is '%s'", serverVersionStr));
            }
            try {
                BigDecimal serverVersion = new BigDecimal(serverVersionStr);
                code = serverVersion.compareTo(this._version) < 0 ? ReturnCode.VersionLower : ReturnCode.Success;
            }
            catch (NumberFormatException e) {
                _log.error(String.format("The server returned version string '%s' which is not a valid number.", serverVersionStr));
                if (!_log.isDebugEnabled()) break block3;
                _log.debug("", e);
            }
        }
        return code;
    }
}

