/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.CertificateType;
import com.vmware.vim.install.RegistrationProviderFactory;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CompositeCommand;
import com.vmware.vim.install.cli.commands.DownloadCertificatesCommand;
import com.vmware.vim.install.cli.util.FileCertificateUtil;
import com.vmware.vim.install.exception.ClockSynchronizationException;
import com.vmware.vim.install.exception.ConnectionException;
import com.vmware.vim.install.exception.InvalidCredentialsException;
import com.vmware.vim.install.exception.RegistrationException;
import com.vmware.vim.install.exception.SSLException;
import com.vmware.vim.install.internals.DefaultThumbprintVerifier;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CommandArgumentsParser {
    protected static final int NO_AUTH = 1;
    protected static final int CERTS = 2;
    private static final Log _log = LogFactory.getLog(CommandArgumentsParser.class);
    private static final String THUMBPRINT_INSECURE = "insecure";
    private static final String HTTP_SCHEME = "http";
    private final Options _allOptions;
    private final Commands _command;
    private final boolean _authRequired;
    private final boolean _certsRequired;

    public CommandArgumentsParser(Commands command) {
        this(command, true);
    }

    public CommandArgumentsParser(Commands command, boolean authRequired) {
        this(command, authRequired ? 0 : 1);
    }

    public CommandArgumentsParser(Commands command, int flag) {
        this._command = command;
        this._authRequired = (flag & 1) != 1;
        this._certsRequired = (flag & 2) == 2;
        this._allOptions = this.createOptions();
    }

    public final Command parseCommand(String[] cmdArgs) {
        Command command;
        PosixParser parser = new PosixParser();
        try {
            CommandLine line = parser.parse(this._allOptions, cmdArgs);
            try {
                this.parseAdditionalOptions(line);
                RegistrationServiceProvider provider = this.createServiceProvider(line);
                command = this.createCommand(provider);
                if (this._certsRequired && line.hasOption('c')) {
                    HashMap<CertificateType, String> certificateFiles = new HashMap<CertificateType, String>(1);
                    certificateFiles.put(CertificateType.LS_SSL_CHAIN, line.getOptionValue('c'));
                    DownloadCertificatesCommand downloadCertCommand = new DownloadCertificatesCommand(certificateFiles, provider);
                    command = command != null ? new CompositeCommand(command, downloadCertCommand) : downloadCertCommand;
                }
            }
            catch (ConnectionException e) {
                _log.error(e.getMessage());
                command = CommandArgumentsParser.createErrorCommand(ReturnCode.ServiceNotResponding);
            }
            catch (InvalidCredentialsException e) {
                _log.error(e.getMessage());
                _log.trace("", e);
                command = CommandArgumentsParser.createErrorCommand(ReturnCode.InvalidCredentials);
            }
            catch (ClockSynchronizationException e) {
                _log.error(e.getMessage());
                _log.trace("", e);
                command = CommandArgumentsParser.createErrorCommand(ReturnCode.ClockSynchronizationProblem);
            }
            catch (IllegalArgumentException e) {
                _log.error(e.getMessage());
                _log.trace("", e);
                command = CommandArgumentsParser.createErrorCommand(ReturnCode.InvalidInput);
            }
            catch (IllegalStateException e) {
                _log.error(e.getMessage());
                _log.trace("", e);
                command = CommandArgumentsParser.createErrorCommand(ReturnCode.InvalidEnvironment);
            }
            catch (SSLException e) {
                command = CommandArgumentsParser.createErrorCommand(ReturnCode.SslHandshakeFailed);
            }
            catch (RegistrationException e) {
                command = CommandArgumentsParser.createErrorCommand(ReturnCode.ServiceNotResponding);
            }
            catch (SystemException e) {
                _log.error(e.getMessage());
                _log.trace("", e);
                command = CommandArgumentsParser.createErrorCommand(ReturnCode.ServiceNotResponding);
            }
        }
        catch (MissingOptionException e) {
            List options = e.getMissingOptions();
            StringBuilder sb = new StringBuilder("Missing required options: [");
            for (Object option : options) {
                if (option instanceof OptionGroup) {
                    OptionGroup og = (OptionGroup)option;
                    sb.append('[');
                    for (Object op : og.getOptions()) {
                        sb.append(((Option)op).getOpt()).append("|");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append(']');
                } else {
                    sb.append(option.toString());
                }
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(']');
            _log.error(sb.toString());
            command = CommandArgumentsParser.createErrorCommand(this.invalidInput());
        }
        catch (ParseException e) {
            _log.error(e.getMessage());
            command = CommandArgumentsParser.createErrorCommand(this.invalidInput());
        }
        return command;
    }

    protected abstract Command createCommand(RegistrationServiceProvider var1);

    protected void parseAdditionalOptions(CommandLine line) {
    }

    protected RegistrationServiceProvider createServiceProvider(CommandLine line) throws ConnectionException, InvalidCredentialsException, RegistrationException {
        String username = line.getOptionValue('u');
        String pass = line.getOptionValue('p');
        URI lsUri = CommandArgumentsParser.createAddress(line.getOptionValue('d'));
        String trustedThumb = line.hasOption(THUMBPRINT_INSECURE) ? THUMBPRINT_INSECURE : line.getOptionValue('t');
        DefaultThumbprintVerifier ver = null;
        if (trustedThumb != null && !trustedThumb.isEmpty()) {
            ver = new DefaultThumbprintVerifier(trustedThumb);
        }
        RegistrationServiceProvider provider = null;
        if (!this._authRequired) {
            provider = RegistrationProviderFactory.getRegistrationProvider(lsUri, ver);
        } else if (username != null && pass != null) {
            provider = RegistrationProviderFactory.getRegistrationProvider(lsUri, username, pass.toCharArray(), (ThumbprintVerifier)ver);
        } else {
            String solutionCertFile = line.getOptionValue("sc");
            String solutionKeyFile = line.getOptionValue("sk");
            if (solutionCertFile == null || solutionCertFile.isEmpty() || solutionKeyFile == null || solutionKeyFile.isEmpty()) {
                throw new IllegalArgumentException("Missing authentication information");
            }
            X509Certificate solutionCert = FileCertificateUtil.loadCertificate(solutionCertFile);
            PrivateKey solutionKey = FileCertificateUtil.loadPrivateKey(solutionKeyFile);
            provider = RegistrationProviderFactory.getRegistrationProvider(lsUri, solutionCert, solutionKey, (ThumbprintVerifier)ver);
        }
        return provider;
    }

    protected Options createOptions() {
        return this.createCommonOptions();
    }

    protected final Options createCommonOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Prints this help message");
        Option urlOption = new Option("d", "ls-url", true, "Address of Lookup Service server");
        urlOption.setRequired(true);
        options.addOption(urlOption);
        options.addOption("t", "thumbprint", true, "Thumbprint against which to verify the LS server");
        options.addOption(null, THUMBPRINT_INSECURE, false, "(SSL) This option explicitly allows the tool to perform insecure SSL connections by disabling all certificate validation.");
        if (this._authRequired) {
            Option usernameOption = new Option("u", "username", true, "User with administrative privileges. NOT REQUIRED if solution certificate and private key are provided");
            Option passwordOption = new Option("p", "password", true, "Password for the user with administrative privileges. REQUIRED if username is provided");
            Option solCertOption = new Option("sc", "solutionCert", true, "Certificate of the solution user to be authenticated. REQUIRED if solution private key is provided");
            Option solPK = new Option("sk", "solutionPrivateKey", true, "Private key of the solution user to be authenticated. NOT REQUIRED if username and password are provided");
            OptionGroup usernameGroup = new OptionGroup();
            usernameGroup.setRequired(this._authRequired);
            usernameGroup.addOption(usernameOption);
            usernameGroup.addOption(solCertOption);
            options.addOptionGroup(usernameGroup);
            OptionGroup passGroup = new OptionGroup();
            passGroup.setRequired(this._authRequired);
            passGroup.addOption(passwordOption);
            passGroup.addOption(solPK);
            options.addOptionGroup(passGroup);
        }
        if (this._certsRequired) {
            options.addOption("c", "cert", true, "Folder where the Lookup Service SSL certificate chain will be stored");
            options.addOption("o", "overwrite", false, "Specifies whether to delete all files in the folder, if such are present");
        }
        return options;
    }

    private ReturnCode invalidInput() {
        StringWriter writer = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(new PrintWriter(writer), 80, this._command.name() + " [OPTIONS]", null, this._allOptions, 5, 5, null);
        _log.info(writer.toString());
        return ReturnCode.InvalidInput;
    }

    protected static Command createErrorCommand(ReturnCode code) {
        return new ErrorCommand(code);
    }

    private static URI createAddress(String lsAddress) {
        URI lsAddressUri = null;
        try {
            lsAddressUri = new URI(lsAddress);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid address", e);
        }
        if (lsAddressUri.getScheme().equalsIgnoreCase(HTTP_SCHEME)) {
            throw new IllegalArgumentException("Only HTTPS connections supported. " + lsAddressUri.toString() + " is not a supported URL");
        }
        return lsAddressUri;
    }

    private static final class ErrorCommand
    implements Command {
        private final ReturnCode _errorCode;

        ErrorCommand(ReturnCode errorCode) {
            this._errorCode = errorCode;
        }

        @Override
        public ReturnCode execute() {
            return this._errorCode;
        }
    }
}

