/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.commands.AssignUserRoleCommand;
import com.vmware.vim.install.cli.commands.ChangePasswordCommandParser;
import com.vmware.vim.install.cli.commands.CheckDomainExistsCommandParser;
import com.vmware.vim.install.cli.commands.CheckPrincipalExistsCommand;
import com.vmware.vim.install.cli.commands.CheckVersionCommandParser;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandArgumentsParser;
import com.vmware.vim.install.cli.commands.CompositeCommand;
import com.vmware.vim.install.cli.commands.ImportServicesCommandParser;
import com.vmware.vim.install.cli.commands.ListServicesCommand;
import com.vmware.vim.install.cli.commands.RegisterDomainCommandParser;
import com.vmware.vim.install.cli.commands.RegisterServiceCommandParser;
import com.vmware.vim.install.cli.commands.RegisterSolutionCommandParser;
import com.vmware.vim.install.cli.commands.StoreSsoDataCommand;
import com.vmware.vim.install.cli.commands.UnregisterServiceCommand;
import com.vmware.vim.install.cli.commands.UnregisterSolutionCommand;
import com.vmware.vim.install.cli.commands.UpdateServiceCommandParser;
import com.vmware.vim.install.cli.commands.UpdateSolutionCommandParser;
import com.vmware.vim.install.cli.commands.ValidateLsCommand;
import com.vmware.vim.install.cli.commands.ValidateSsoCommand;
import com.vmware.vim.install.cli.commands.ValidateUsernameCommand;
import com.vmware.vim.install.cli.commands.util.ParserUtil;
import com.vmware.vim.install.cli.util.FileCertificateUtil;
import com.vmware.vim.sso.admin.RoleManagement;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandFactory {
    public static Command createValidateLsCommand(String[] cmdArgs) {
        return new CommandArgumentsParser(Commands.validateLsConnection, 2){

            @Override
            protected Command createCommand(RegistrationServiceProvider serviceProvider) {
                return new ValidateLsCommand(serviceProvider);
            }
        }.parseCommand(cmdArgs);
    }

    public static Command createRegisterServiceCommand(String[] cmdArgs) {
        return new RegisterServiceCommandParser().parseCommand(cmdArgs);
    }

    public static Command createUnregisterServiceCommand(String[] cmdArgs) {
        return new CommandArgumentsParser(Commands.unregisterService){
            private String[] _serviceIds;

            @Override
            protected void parseAdditionalOptions(CommandLine line) {
                String siFile = line.getOptionValue("si");
                this._serviceIds = ParserUtil.extractServiceIdsFromFile(siFile).toArray(new String[0]);
            }

            @Override
            protected Options createOptions() {
                Options options = super.createOptions();
                Option option = new Option("si", "serviceId-file", true, "File, containing the serviceId of the service to be unregistered");
                option.setRequired(true);
                options.addOption(option);
                return options;
            }

            @Override
            protected Command createCommand(RegistrationServiceProvider serviceProvider) {
                Command[] commands = new Command[this._serviceIds.length];
                for (int i = 0; i < this._serviceIds.length; ++i) {
                    commands[i] = new UnregisterServiceCommand(serviceProvider.getLookupService(), this._serviceIds[i]);
                }
                return new CompositeCommand(commands);
            }
        }.parseCommand(cmdArgs);
    }

    public static Command createValidateSsoCommand(String[] cmdArgs) {
        return new CommandArgumentsParser(Commands.validateSsoConnection, 2){

            @Override
            protected Command createCommand(RegistrationServiceProvider serviceProvider) {
                return new ValidateSsoCommand(serviceProvider.getAdminService().getPrincipalManagement());
            }
        }.parseCommand(cmdArgs);
    }

    public static Command createRegisterSolutionCommand(String[] cmdArgs) {
        return new RegisterSolutionCommandParser().parseCommand(cmdArgs);
    }

    public static Command createUnregisterSolutionCommand(String[] cmdArgs) {
        return new CommandArgumentsParser(Commands.unregisterSolution){
            private String _solutionUser;

            @Override
            protected void parseAdditionalOptions(CommandLine line) {
                this._solutionUser = line.getOptionValue("su");
            }

            @Override
            protected Options createOptions() {
                Options options = super.createOptions();
                Option suOption = new Option("su", "solution-username", true, "Username of the solution to be unregistered");
                suOption.setRequired(true);
                options.addOption(suOption);
                return options;
            }

            @Override
            protected Command createCommand(RegistrationServiceProvider serviceProvider) {
                return new UnregisterSolutionCommand(serviceProvider, this._solutionUser);
            }
        }.parseCommand(cmdArgs);
    }

    public static Command createValidateUsernameCommand(String[] cmdArgs) {
        return new CommandArgumentsParser(Commands.validateUsername){
            private static final String SOLUTION_REG_CERT_OPT = "solutionRegistrationCert";
            private final Log _log = LogFactory.getLog(this.getClass());
            private String _solutionUser;
            private String _subjectDN;

            @Override
            protected void parseAdditionalOptions(CommandLine line) {
                this._solutionUser = line.getOptionValue("su");
                this._subjectDN = line.getOptionValue("dn");
                if (this._subjectDN == null || this._subjectDN.isEmpty()) {
                    String solutionCert = line.getOptionValue(SOLUTION_REG_CERT_OPT);
                    this._log.debug("Loading certificate from file " + solutionCert);
                    X509Certificate cert = FileCertificateUtil.loadCertificate(solutionCert);
                    this._subjectDN = cert.getSubjectX500Principal().getName();
                }
                this._log.debug("Successfully parsed command-line options");
            }

            @Override
            protected Options createOptions() {
                Options options = super.createOptions();
                Option suOption = new Option("su", "solution-username", true, "Username of the solution to be checked. REQUIRED");
                suOption.setRequired(true);
                options.addOption(suOption);
                Option dnOption = new Option("dn", "subject-dn", true, "Subject DN of the solution certificate to be checked. REQUIRED, unless solutionRegistrationCert is provided.");
                Option certOption = new Option("sr", SOLUTION_REG_CERT_OPT, true, "The solution certificate to check. It's Subject DN will be verified against SSO. REQUIRED, unless subject DN is provided");
                OptionGroup certDn = new OptionGroup();
                certDn.addOption(dnOption);
                certDn.addOption(certOption);
                certDn.setRequired(true);
                options.addOptionGroup(certDn);
                return options;
            }

            @Override
            protected Command createCommand(RegistrationServiceProvider serviceProvider) {
                return new ValidateUsernameCommand(serviceProvider.getAdminService().getDomainManagement(), serviceProvider.getAdminService().getPrincipalDiscovery(), this._solutionUser, this._subjectDN);
            }
        }.parseCommand(cmdArgs);
    }

    public static Command createAssignUserRoleCommand(String[] cmdArgs) {
        return new CommandArgumentsParser(Commands.assignUserRole){
            private static final String READ_ROLE = "read";
            private static final String ADMIN_ROLE = "admin";
            private String _userRole;
            private String _username;

            @Override
            protected void parseAdditionalOptions(CommandLine line) {
                this._username = line.getOptionValue("su");
                this._userRole = line.getOptionValue("r");
                if (READ_ROLE.equals(this._userRole)) {
                    this._userRole = RoleManagement.Role.RegularUser.name();
                } else if (ADMIN_ROLE.equals(this._userRole)) {
                    this._userRole = RoleManagement.Role.Administrator.name();
                } else {
                    throw new IllegalArgumentException("Incorrect admin role");
                }
            }

            @Override
            protected Options createOptions() {
                Options options = super.createOptions();
                Option suOption = new Option("su", "local-user", true, "Local user to assign a role to. REQUIRED");
                suOption.setRequired(true);
                options.addOption(suOption);
                String roleDesc = "Role to assign to user. REQUIRED.\nCan be one of: read, admin";
                Option roleOption = new Option("r", "role", true, roleDesc);
                roleOption.setRequired(true);
                options.addOption(roleOption);
                return options;
            }

            @Override
            protected Command createCommand(RegistrationServiceProvider serviceProvider) {
                return new AssignUserRoleCommand(serviceProvider.getAdminService().getDomainManagement(), serviceProvider.getAdminService().getRoleManagement(), this._userRole, this._username);
            }
        }.parseCommand(cmdArgs);
    }

    public static Command createCheckPrincipalExistsCommand(String[] cmdArgs) {
        return new CommandArgumentsParser(Commands.checkPrincipalExists){
            private String _principal;
            private boolean _checkIsGroup;

            @Override
            protected void parseAdditionalOptions(CommandLine line) {
                this._principal = line.getOptionValue('P');
                this._checkIsGroup = line.hasOption('g');
            }

            @Override
            protected Options createOptions() {
                Options options = super.createOptions();
                Option principal = new Option("P", "principal", true, "The principal to check for existence");
                principal.setRequired(true);
                options.addOption(principal);
                options.addOption("g", "isGroup", false, "Check whether the provided principal is group. If the option is not provided then only person users are searched");
                return options;
            }

            @Override
            protected Command createCommand(RegistrationServiceProvider serviceProvider) {
                return new CheckPrincipalExistsCommand(serviceProvider.getAdminService().getDomainManagement(), serviceProvider.getAdminService().getPrincipalDiscovery(), this._principal, this._checkIsGroup);
            }
        }.parseCommand(cmdArgs);
    }

    public static Command createStoreSsoDataCommand(String[] cmdArgs) {
        return new CommandArgumentsParser(Commands.storeSsoData, false){
            private String _folder;

            @Override
            protected void parseAdditionalOptions(CommandLine line) {
                this._folder = line.getOptionValue('f');
            }

            @Override
            protected Options createOptions() {
                Options options = super.createOptions();
                Option option = new Option("f", "folder", true, "The directory in which ssoLocations file and sso certificates will be stored");
                option.setRequired(true);
                options.addOption(option);
                return options;
            }

            @Override
            protected Command createCommand(RegistrationServiceProvider serviceProvider) {
                return new StoreSsoDataCommand(serviceProvider, this._folder);
            }
        }.parseCommand(cmdArgs);
    }

    public static Command createUpdateServiceCommand(String[] cmdArgs) {
        return new UpdateServiceCommandParser().parseCommand(cmdArgs);
    }

    public static Command createUpdateSolutionCommand(String[] cmdArgs) {
        return new UpdateSolutionCommandParser().parseCommand(cmdArgs);
    }

    public static Command createRegisterDomainCommand(String[] cmdArgs) {
        return new RegisterDomainCommandParser().parseCommand(cmdArgs);
    }

    public static Command createCheckDomainExistsCommand(String[] cmdArgs) {
        return new CheckDomainExistsCommandParser().parseCommand(cmdArgs);
    }

    public static Command createListServicesCommand(String[] cmdArgs) {
        return new ListServicesCommand(cmdArgs);
    }

    public static Command createChangePasswordCommand(String[] cmdArgs) {
        return new ChangePasswordCommandParser().parseCommand(cmdArgs);
    }

    public static Command createCheckVersionCommand(String[] cmdArgs) {
        return new CheckVersionCommandParser().parseCommand(cmdArgs);
    }

    public static Command createImportServicesCommand(String[] cmdArgs) {
        return new ImportServicesCommandParser().parseCommand(cmdArgs);
    }
}

