/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.CertificateType;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.util.FileCertificateUtil;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadCertificatesCommand
implements Command {
    private static final Log _log = LogFactory.getLog(DownloadCertificatesCommand.class);
    private final Map<CertificateType, String> _certificateFiles;
    private final RegistrationServiceProvider _serviceProvider;

    public DownloadCertificatesCommand(Map<CertificateType, String> certificates, RegistrationServiceProvider serviceProvider) {
        this._certificateFiles = Collections.unmodifiableMap(certificates);
        this._serviceProvider = serviceProvider;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code = ReturnCode.Success;
        Map<CertificateType, X509Certificate[]> certificates = this._serviceProvider.downloadCertificates();
        if (this._certificateFiles != null) {
            try {
                for (CertificateType type : this._certificateFiles.keySet()) {
                    X509Certificate[] certs = certificates.get((Object)type);
                    String filename = this._certificateFiles.get((Object)type);
                    File file = new File(filename);
                    if (file.isDirectory()) {
                        _log.trace("Provided location is a folder: " + file.getAbsolutePath());
                        String filenameFormat = file.getAbsolutePath() + File.separator + "%s_" + type.name() + ".crt";
                        for (int i = certs.length - 1; i > -1; --i) {
                            String index = i == certs.length - 1 ? "ROOT" : String.valueOf(certs.length - i - 1);
                            FileCertificateUtil.storeCertificate(String.format(filenameFormat, index), certs[i], true);
                        }
                        continue;
                    }
                    _log.warn("Provided location is a file but multiple certificates should be stored. Using the parent folder instead");
                    File parent = file.getParentFile();
                    if (parent == null) {
                        _log.error("Cannot get the parent folder of the provided file. Exiting");
                        code = ReturnCode.CertificateStoringFailed;
                        continue;
                    }
                    if (!file.exists()) {
                        _log.trace("The folder doesn't exist. Create...");
                        file.mkdirs();
                    }
                    String filenameFormat = file.getAbsolutePath() + File.separator + type.name() + "%s.cert";
                    for (int i = 0; i < certs.length; ++i) {
                        FileCertificateUtil.storeCertificate(String.format(filenameFormat, i), certs[i], true);
                    }
                }
                _log.info("Certificates saved successfully");
            }
            catch (Exception e) {
                _log.warn(e.getMessage());
                _log.debug(e);
                code = ReturnCode.CertificateStoringFailed;
            }
        }
        return code;
    }
}

