/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.impl.Constants;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportServicesCommand
implements Command {
    private final Log _log = LogFactory.getLog(ImportServicesCommand.class);
    private final LookupService _lookupService;
    private final List<ServiceRegistrationForm> _serviceInfoList;

    ImportServicesCommand(LookupService lookupService, List<ServiceRegistrationForm> serviceInfoList) {
        this._lookupService = lookupService;
        this._serviceInfoList = serviceInfoList;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code = ReturnCode.OperationFailed;
        if (this._serviceInfoList != null && !this._serviceInfoList.isEmpty()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug(String.format("Importing %d services", this._serviceInfoList.size()));
            }
            try {
                String viSite = this._lookupService.getViSite();
                for (ServiceRegistrationForm form : this._serviceInfoList) {
                    this.registerServiceIfNeeded(viSite, form);
                }
                code = ReturnCode.Success;
            }
            catch (InvalidArgument e) {
                this._log.error(e.getMessage(), e);
                code = ReturnCode.InvalidInput;
            }
            catch (SecurityError e) {
                this._log.error(e.getMessage(), e);
                code = ReturnCode.NotPrivileged;
            }
            catch (ServiceFault e) {
                this._log.error(e.getMessage(), e);
                code = ReturnCode.RegistrationFailed;
            }
        } else {
            code = ReturnCode.Success;
        }
        return code;
    }

    private void registerServiceIfNeeded(String viSite, ServiceRegistrationForm form) throws ServiceFault, InvalidArgument, SecurityError, IllegalStateException {
        assert (viSite != null);
        assert (form != null);
        URI serviceType = form.getType();
        this._log.info(String.format("Importing service of type %s", serviceType));
        if (this.isSsoService(serviceType)) {
            SearchCriteria criteria = new SearchCriteria();
            criteria.setViSite(viSite);
            criteria.setServiceType(serviceType);
            Service[] services = this._lookupService.find(criteria);
            if (services.length != 1) {
                throw new IllegalStateException(String.format("You should have exactly one service of type [%s], but instead you have %d", serviceType, services.length));
            }
            this._log.info("SSO service, so skipping");
        } else {
            Service service = this._lookupService.registerService(form);
            this._log.info(String.format("Service with name '%s' was registered with ID: '%s'", service.getServiceName(), service.getServiceId()));
        }
    }

    private boolean isSsoService(URI serviceType) {
        assert (serviceType != null);
        return serviceType.equals(Constants.SSO_ADMIN_TYPE) || serviceType.equals(Constants.SSO_GC_TYPE) || serviceType.equals(Constants.SSO_STS_TYPE);
    }
}

