/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandArgumentsParser;
import com.vmware.vim.install.cli.commands.ImportServicesCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportServicesCommandParser
extends CommandArgumentsParser {
    private static final Log _log = LogFactory.getLog(ImportServicesCommandParser.class);
    protected List<ServiceRegistrationForm> _serviceInfoList = new ArrayList<ServiceRegistrationForm>();

    public ImportServicesCommandParser() {
        super(Commands.importServices);
    }

    @Override
    protected Command createCommand(RegistrationServiceProvider serviceProvider) {
        return new ImportServicesCommand(serviceProvider.getLookupService(), this._serviceInfoList);
    }

    @Override
    protected void parseAdditionalOptions(CommandLine line) {
        String propertiesLocation = line.getOptionValue("ip");
        File propFile = new File(propertiesLocation);
        ImportServicesCommandParser.throwIfDirectory(propFile);
        if (!propFile.exists()) {
            _log.warn("No properties files found");
            return;
        }
        try (FileInputStream propStream = new FileInputStream(propFile);){
            Properties props = new Properties();
            props.load(propStream);
            String serviceIdsPropVal = props.getProperty("ServiceIDs");
            String[] serviceIds = StringUtils.split(serviceIdsPropVal, ',');
            if (serviceIds != null && serviceIds.length > 0) {
                for (String serviceId : serviceIds) {
                    this._serviceInfoList.add(this.parseServiceRegistration(serviceId, props));
                }
            } else {
                _log.info("The supplied import-properties contains no service registration information to import.");
            }
        }
        catch (IOException e) {
            _log.error(String.format("Failed to open property file %s : %s", propFile.getAbsolutePath(), e.getMessage()), e);
        }
    }

    private ServiceRegistrationForm parseServiceRegistration(String serviceId, Properties props) {
        String svcPrefix = String.format("ServiceRegistration.%s", serviceId);
        String svcTypePropName = String.format("%s.type", svcPrefix);
        String svcVerPropName = String.format("%s.version", svcPrefix);
        String svcOwnerIdPropName = String.format("%s.ownerID", svcPrefix);
        String svcDescPropName = String.format("%s.description", svcPrefix);
        String svcNamePropName = String.format("%s.serviceName", svcPrefix);
        String svcProductIdPropName = String.format("%s.productID", svcPrefix);
        String endpointsPropName = String.format("%s.Endpoints", svcPrefix);
        String svcVersion = props.getProperty(svcVerPropName);
        String svcOwnerId = props.getProperty(svcOwnerIdPropName);
        String svcDesc = props.getProperty(svcDescPropName);
        String svcName = props.getProperty(svcNamePropName);
        String svcProductId = props.getProperty(svcProductIdPropName);
        String svcType = props.getProperty(svcTypePropName);
        String endpointsPropVal = props.getProperty(endpointsPropName);
        ArrayList<ServiceEndpoint> endpointList = new ArrayList<ServiceEndpoint>();
        if (endpointsPropVal != null) {
            String[] endpoints = StringUtils.split(StringUtils.strip(endpointsPropVal, "[]"), ',');
            if (endpoints != null && endpoints.length > 0) {
                for (String endpoint : endpoints) {
                    endpointList.add(this.parseServiceEndpoint(svcPrefix, endpoint, props));
                }
            } else {
                _log.info(String.format("No endpoins found for service `%s'.", serviceId));
            }
        }
        URI svcTypeURI = null;
        try {
            svcTypeURI = new URI(svcType);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("An invalid endpoint URL [%s] was specified", svcType), e);
        }
        ServiceRegistrationForm form = new ServiceRegistrationForm();
        form.setOwnerId(svcOwnerId);
        form.setDescription(svcDesc);
        form.setServiceName(svcName);
        form.setOwnerId(svcOwnerId);
        form.setVersion(svcVersion);
        form.setProductId(svcProductId);
        form.setType(svcTypeURI);
        if (endpointList.size() > 0) {
            form.setEndpoints(endpointList.toArray(new ServiceEndpoint[endpointList.size()]));
        }
        return form;
    }

    private ServiceEndpoint parseServiceEndpoint(String svcPrefix, String endpoint, Properties props) {
        String formattedUrl = endpoint.trim();
        String endpointPrefix = String.format("%s.Endpoint.%s", svcPrefix, formattedUrl);
        String endpointCertPropName = String.format("%s.sslCertificate", endpointPrefix);
        String endpointprotocolPropName = String.format("%s.protocol", endpointPrefix);
        String certBytes = props.getProperty(endpointCertPropName);
        String protocol = props.getProperty(endpointprotocolPropName);
        URI endpointUrl = null;
        try {
            endpointUrl = new URI(formattedUrl);
            _log.debug("endpointUrl is created: " + endpointUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("An invalid endpoint URL [%s] was specified", endpoint), e);
        }
        ServiceEndpoint endpointVal = new ServiceEndpoint();
        endpointVal.setUrl(endpointUrl);
        endpointVal.setProtocol(protocol);
        endpointVal.setSslTrustAnchor(certBytes);
        return endpointVal;
    }

    @Override
    protected Options createOptions() {
        Options options = super.createOptions();
        Option propOption = new Option("ip", "import-properties", true, "The file, containing the update information. All properties should be provided");
        propOption.setRequired(true);
        options.addOption(propOption);
        return options;
    }

    private static final void throwIfDirectory(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is a directory. Please provide a filename");
        }
    }
}

