/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.RegisterDomainForm;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.ExternalDomain;
import com.vmware.vim.sso.admin.ExternalDomainDetails;
import com.vmware.vim.sso.admin.exception.DirectoryServiceConnectionException;
import com.vmware.vim.sso.admin.exception.DuplicateDomainNameException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegisterDomainCommand
implements Command {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final DomainManagement _domainManagement;
    private final RegisterDomainForm _registrationForm;

    public RegisterDomainCommand(DomainManagement domainManagement, RegisterDomainForm registrationForm) {
        this._domainManagement = domainManagement;
        this._registrationForm = registrationForm;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode status;
        DomainManagement.AuthenticationCredentails authnCredentials;
        ExternalDomainDetails details = new ExternalDomainDetails(this._registrationForm.getName(), this._registrationForm.getBaseDn(), this._registrationForm.getBaseDn(), this._registrationForm.getPrimaryUrl(), this._registrationForm.getFailoverUrl(), 0);
        switch (this._registrationForm.getAuthnType()) {
            case password: {
                if (StringUtils.isEmpty(this._registrationForm.getUser()) || StringUtils.isEmpty(this._registrationForm.getPassword())) {
                    throw new IllegalArgumentException("Authentication username and password must be specified for authentication type `password'");
                }
                authnCredentials = new DomainManagement.AuthenticationCredentails(this._registrationForm.getUser(), this._registrationForm.getPassword().toCharArray());
                break;
            }
            default: {
                authnCredentials = null;
            }
        }
        ExternalDomain.Type domainType = this._registrationForm.getDomainType();
        if ((domainType == ExternalDomain.Type.ActiveDirectory || domainType == ExternalDomain.Type.OpenLdap) && this._registrationForm.getBaseDn() == null) {
            throw new IllegalArgumentException("No `baseDn' specified of domain of type ActiveDirectory or OpenLdap");
        }
        try {
            this._domainManagement.addExternalDomain(domainType, this._registrationForm.getName(), this._registrationForm.getAlias(), details, this._registrationForm.getAuthnType(), authnCredentials);
            status = ReturnCode.Success;
        }
        catch (NoPermissionException e) {
            this._log.error(e.getMessage(), e);
            status = ReturnCode.NotPrivileged;
        }
        catch (DuplicateDomainNameException e) {
            this._log.error(e.getMessage(), e);
            status = ReturnCode.AlreadyRegistered;
        }
        catch (NotAuthenticatedException e) {
            this._log.error(e.getMessage(), e);
            status = ReturnCode.InvalidCredentials;
        }
        catch (DirectoryServiceConnectionException e) {
            this._log.error(e.getMessage(), e);
            status = ReturnCode.ServiceNotResponding;
        }
        return status;
    }
}

