/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.SolutionRegistrationForm;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.PrincipalManagement;
import com.vmware.vim.sso.admin.exception.DuplicateSolutionCertificateException;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegisterSolutionCommand
implements Command {
    private static final Log _log = LogFactory.getLog(RegisterSolutionCommand.class);
    private final PrincipalManagement _principalManagement;
    private final SolutionRegistrationForm _solutionRegistration;

    public RegisterSolutionCommand(PrincipalManagement principalManagement, SolutionRegistrationForm solution) {
        this._principalManagement = principalManagement;
        this._solutionRegistration = solution;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code;
        try {
            PrincipalId solutionUserId = this._principalManagement.createLocalSolutionUser(this._solutionRegistration.getUsername(), this._solutionRegistration.getSolutionDetails());
            code = ReturnCode.Success;
            _log.info(String.format("Solution user with id: %s successfully registered", solutionUserId.toString()));
        }
        catch (InvalidPrincipalException e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.AlreadyRegistered;
        }
        catch (DuplicateSolutionCertificateException e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.AlreadyRegistered;
        }
        catch (NotAuthenticatedException e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.NotPrivileged;
        }
        catch (NoPermissionException e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.NotPrivileged;
        }
        catch (SystemException e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.ServiceNotResponding;
        }
        return code;
    }
}

