/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.commands.AssignUserRoleCommand;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandArgumentsParser;
import com.vmware.vim.install.cli.commands.CompositeCommand;
import com.vmware.vim.install.cli.commands.RegisterSolutionCommand;
import com.vmware.vim.install.cli.commands.SolutionRegistrationForm;
import com.vmware.vim.install.cli.commands.util.ParserUtil;
import com.vmware.vim.sso.admin.RoleManagement;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RegisterSolutionCommandParser
extends CommandArgumentsParser {
    private static final Log _log = LogFactory.getLog(RegisterSolutionCommandParser.class);
    private SolutionRegistrationForm _solutionInfo;
    private String _role = null;

    public RegisterSolutionCommandParser() {
        super(Commands.registerSolution, 2);
    }

    @Override
    protected void parseAdditionalOptions(CommandLine line) {
        String propertiesLocation = line.getOptionValue("ip");
        try {
            this._solutionInfo = ParserUtil.extractSolutionRegistrationForm(propertiesLocation);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        String role = line.getOptionValue('r');
        if ("read".equals(role)) {
            role = RoleManagement.Role.RegularUser.name();
        } else if ("admin".equals(role)) {
            role = RoleManagement.Role.Administrator.name();
        } else if (role == null || role.isEmpty()) {
            role = null;
        } else {
            throw new IllegalArgumentException("Incorrect admin role");
        }
        this._role = role;
    }

    @Override
    protected Options createOptions() {
        Options options = super.createOptions();
        Option propOption = new Option("ip", "install-props", true, "Location of the file, containing the registration information");
        propOption.setRequired(true);
        options.addOption(propOption);
        options.addOption("r", "role", true, "Role to be assigned to the newly created user. One of \"read\" or \"admin\"");
        return options;
    }

    @Override
    protected Command createCommand(RegistrationServiceProvider serviceProvider) {
        Command cmd = new RegisterSolutionCommand(serviceProvider.getAdminService().getPrincipalManagement(), this._solutionInfo);
        if (this._role != null) {
            cmd = new CompositeCommand(cmd, new AssignUserRoleCommand(serviceProvider.getAdminService().getDomainManagement(), serviceProvider.getAdminService().getRoleManagement(), this._role, this._solutionInfo.getUsername()));
        }
        return cmd;
    }
}

