/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.sso.admin.SolutionDetails;
import java.security.cert.X509Certificate;

public final class SolutionRegistrationForm {
    private static final String NOT_NULL_FORMAT = "Argument %s cannot be null";
    private final String _solutionUsername;
    private final SolutionDetails _solutionDetails;

    public SolutionRegistrationForm(String userName, X509Certificate solutionCertificate, String description) {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException(String.format(NOT_NULL_FORMAT, "userName"));
        }
        if (solutionCertificate == null) {
            throw new IllegalArgumentException(String.format(NOT_NULL_FORMAT, "solutionCertificate"));
        }
        this._solutionUsername = userName;
        this._solutionDetails = description == null ? new SolutionDetails(solutionCertificate) : new SolutionDetails(solutionCertificate, description);
    }

    public String getUsername() {
        return this._solutionUsername;
    }

    public SolutionDetails getSolutionDetails() {
        return this._solutionDetails;
    }
}

