/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.util.EndpointFinderUtil;
import com.vmware.vim.install.cli.util.FileCertificateUtil;
import com.vmware.vim.install.exception.RegistrationException;
import com.vmware.vim.sso.admin.util.CertificateUtil;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreSsoDataCommand
implements Command {
    private static final Log _log = LogFactory.getLog(StoreSsoDataCommand.class);
    private final String _folder;
    private final RegistrationServiceProvider _serviceProvider;

    public StoreSsoDataCommand(RegistrationServiceProvider serviceProvider, String folder) {
        this._folder = folder;
        this._serviceProvider = serviceProvider;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code;
        try {
            Map<String, ServiceEndpoint> ssoEndpoints = new EndpointFinderUtil(this._serviceProvider.getLookupService()).findSsoEndpoints();
            this.storeLocations(ssoEndpoints);
            for (Map.Entry<String, ServiceEndpoint> endpoint : ssoEndpoints.entrySet()) {
                FileCertificateUtil.storeCertificate(this._folder + File.separator + endpoint.getKey() + ".crt", CertificateUtil.decodeCertificate(endpoint.getValue().getSslTrustAnchor()), true);
            }
            _log.info("Successfully saved SSO locations and certificates");
            code = ReturnCode.Success;
        }
        catch (InvalidArgument e) {
            _log.error("This error indicates a problem in tool implementation. Original message: " + e.getMessage());
            _log.debug("", e);
            code = ReturnCode.OperationFailed;
        }
        catch (SecurityError e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.NotPrivileged;
        }
        catch (ServiceFault e) {
            _log.error("Service is not responding: " + e.getMessage());
            _log.debug("", e);
            code = ReturnCode.ServiceNotResponding;
        }
        catch (IllegalArgumentException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.InvalidInput;
        }
        catch (SecurityException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.CertificateStoringFailed;
        }
        return code;
    }

    private void storeLocations(Map<String, ServiceEndpoint> ssoEndpoints) {
        File file = new File(this._folder);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            throw new RegistrationException("This should be a folder");
        }
        File locFile = new File(file.getAbsolutePath() + File.separator + "ssoLocations.txt");
        try (PrintWriter writer = null;){
            writer = new PrintWriter(locFile);
            for (Map.Entry<String, ServiceEndpoint> endpoint : ssoEndpoints.entrySet()) {
                writer.println(String.format("%s=%s", endpoint.getKey(), endpoint.getValue().getUrl().toString()));
            }
        }
    }
}

