/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.lookup.fault.UnsupportedSiteFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.RegisterServiceCommand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UpdateServiceCommand
implements Command {
    private final Log _log = LogFactory.getLog(RegisterServiceCommand.class);
    private final LookupService _lookupService;
    private final Service _service;

    UpdateServiceCommand(LookupService lookupService, Service service) {
        this._lookupService = lookupService;
        this._service = service;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code = null;
        try {
            this._lookupService.updateService(this._service);
            this._log.info(String.format("Service with name '%s' and ID '%s' was updated.", this._service.getServiceName(), this._service.getServiceId()));
            code = ReturnCode.Success;
        }
        catch (InvalidArgument e) {
            this._log.error(e.getMessage(), e);
            code = ReturnCode.InvalidInput;
        }
        catch (SecurityError e) {
            this._log.error(e.getMessage(), e);
            code = ReturnCode.NotPrivileged;
        }
        catch (EntryNotFoundFault e) {
            this._log.error(e.getMessage());
            this._log.debug(e);
            code = ReturnCode.UpdateFailed;
        }
        catch (UnsupportedSiteFault e) {
            this._log.error(e.getMessage());
            this._log.debug(e);
            code = ReturnCode.UpdateFailed;
        }
        catch (ServiceFault e) {
            this._log.error(e.getMessage(), e);
            code = ReturnCode.RegistrationFailed;
        }
        return code;
    }
}

