/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandArgumentsParser;
import com.vmware.vim.install.cli.commands.UpdateServiceCommand;
import com.vmware.vim.install.cli.commands.util.ParserUtil;
import java.io.File;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateServiceCommandParser
extends CommandArgumentsParser {
    private static final Log _log = LogFactory.getLog(UpdateServiceCommandParser.class);
    protected ServiceRegistrationForm _serviceInfo;
    protected String _serviceId;

    public UpdateServiceCommandParser() {
        super(Commands.updateService);
    }

    @Override
    protected void parseAdditionalOptions(CommandLine line) {
        String propertiesLocation = line.getOptionValue("ip");
        String siFileStr = line.getOptionValue("si");
        List<String> ids = ParserUtil.extractServiceIdsFromFile(siFileStr);
        if (ids.size() != 1) {
            throw new IllegalArgumentException(String.format("ServiceId file contains %s serviceId entries, 1 is expected", ids.size()));
        }
        this._serviceId = ids.get(0);
        File propFile = new File(propertiesLocation);
        UpdateServiceCommandParser.throwIfDirectory(propFile);
        if (!propFile.exists()) {
            _log.warn("No properties files found");
            return;
        }
        try {
            this._serviceInfo = ParserUtil.extractServiceFormFromFile(propFile);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    protected Command createCommand(RegistrationServiceProvider serviceProvider) {
        Service service;
        try {
            service = UpdateServiceCommandParser.createServiceFromForm(this._serviceId, this._serviceInfo, serviceProvider.getLookupService().getViSite());
        }
        catch (ServiceFault e) {
            return UpdateServiceCommandParser.createErrorCommand(ReturnCode.ServiceNotResponding);
        }
        return new UpdateServiceCommand(serviceProvider.getLookupService(), service);
    }

    @Override
    protected Options createOptions() {
        Options options = super.createOptions();
        Option propOption = new Option("ip", "installation-properties", true, "The file, containing the update information. All properties should be provided,");
        propOption.setRequired(true);
        options.addOption(propOption);
        Option fileOption = new Option("si", "serviceId-file", true, "The file where the serviceId will be stored");
        fileOption.setRequired(true);
        options.addOption(fileOption);
        return options;
    }

    private static Service createServiceFromForm(String serviceId, ServiceRegistrationForm form, String viSite) throws ServiceFault {
        return new Service(serviceId, form.getVersion(), form.getType(), form.getOwnerId(), form.getServiceName(), form.getDescription(), form.getEndpoints(), viSite, form.getProductId());
    }

    private static final void throwIfDirectory(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is a directory. Please provide a filename");
        }
    }
}

