/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.sso.admin.PrincipalDiscovery;
import com.vmware.vim.sso.admin.PrincipalManagement;
import com.vmware.vim.sso.admin.PrincipalSelfManagement;
import com.vmware.vim.sso.admin.SolutionDetails;
import com.vmware.vim.sso.admin.SolutionUser;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UpdateSolutionCommand
implements Command {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final PrincipalDiscovery _principalDiscovery;
    private final PrincipalManagement _principalMgmt;
    private final PrincipalSelfManagement _principalSelfMgmt;
    private final String _solutionName;
    private final X509Certificate _oldCertificate;
    private final X509Certificate _newCertificate;
    private final String _newDescription;

    public UpdateSolutionCommand(PrincipalDiscovery principalDiscovery, PrincipalManagement principalMgmt, PrincipalSelfManagement principalSelfMgmt, String solutionName, X509Certificate oldCertificate, X509Certificate newCertificate, String newDescription) {
        this._principalDiscovery = principalDiscovery;
        this._principalMgmt = principalMgmt;
        this._principalSelfMgmt = principalSelfMgmt;
        assert (solutionName != null || oldCertificate != null);
        assert (newCertificate != null || newDescription != null);
        this._solutionName = solutionName;
        this._oldCertificate = oldCertificate;
        this._newCertificate = newCertificate;
        this._newDescription = newDescription;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode status;
        try {
            SolutionDetails details = this.calculateEffectiveUpdatedDetails();
            if (this._solutionName != null) {
                this._log.debug("Explicit solution name provided; updating solution user details on administrator's behalf.");
                this._principalMgmt.updateLocalSolutionUserDetails(this._solutionName, details);
            } else {
                this._log.debug("No explicit solution name provided; using solution user self-update.");
                this._principalSelfMgmt.updateSolutionUserDetails(details);
            }
            status = ReturnCode.Success;
        }
        catch (InvalidPrincipalException e) {
            this._log.debug("Error updating solution details: invalid principal.", e);
            status = ReturnCode.InvalidInput;
        }
        catch (NotAuthenticatedException e) {
            this._log.debug("Error updating solution details: not authenticated.", e);
            status = ReturnCode.InvalidCredentials;
        }
        catch (NoPermissionException e) {
            this._log.debug("Error updating solution details: no permissions", e);
            status = ReturnCode.NotPrivileged;
        }
        return status;
    }

    private SolutionDetails calculateEffectiveUpdatedDetails() throws NotAuthenticatedException, NoPermissionException {
        SolutionDetails effectiveDetails;
        if (this._newCertificate != null && this._newDescription != null) {
            effectiveDetails = new SolutionDetails(this._newCertificate, this._newDescription);
        } else {
            String notFoundMsg;
            SolutionUser existingSolution;
            try {
                if (this._solutionName != null) {
                    existingSolution = this._principalDiscovery.findSolutionUser(this._solutionName);
                    notFoundMsg = String.format("Solution user does not exist: %s", this._solutionName);
                } else {
                    String subjectDn = this._oldCertificate.getSubjectX500Principal().getName();
                    existingSolution = this._principalDiscovery.findSolutionUserByCertDN(subjectDn);
                    notFoundMsg = String.format("Solution user with the supplied certificate Subject DN does not exist: %s", subjectDn);
                }
            }
            catch (NoPermissionException e) {
                throw new IllegalArgumentException("Both replacement certificate and replacement description must be provided if the authenticating user does not have read permissions over the SSO service.", e);
            }
            if (existingSolution == null) {
                throw new IllegalArgumentException(notFoundMsg);
            }
            X509Certificate effectiveCert = this._newCertificate != null ? this._newCertificate : existingSolution.getDetails().getCertificate();
            String effectiveDesc = this._newDescription != null ? this._newDescription : existingSolution.getDetails().getDescription();
            effectiveDetails = new SolutionDetails(effectiveCert, effectiveDesc);
        }
        return effectiveDetails;
    }
}

