/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidateLsCommand
implements Command {
    private static final Log _log = LogFactory.getLog(ValidateLsCommand.class);
    private final RegistrationServiceProvider _serviceProvider;

    public ValidateLsCommand(RegistrationServiceProvider serviceProvider) {
        this._serviceProvider = serviceProvider;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code = ReturnCode.OperationFailed;
        String serviceId = null;
        try {
            Service service = this._serviceProvider.getLookupService().registerService(ValidateLsCommand.createDummyService());
            _log.info("Successfully created dummy service, we have sufficient privileges");
            serviceId = service.getServiceId();
        }
        catch (SecurityError e) {
            _log.error(e.getMessage());
            _log.trace("", e);
            code = ReturnCode.NotPrivileged;
        }
        catch (ServiceFault e) {
            _log.error(e.getMessage());
            _log.trace("", e);
            code = ReturnCode.ServiceNotResponding;
        }
        catch (URISyntaxException e) {
            _log.error(e);
            code = ReturnCode.OperationFailed;
        }
        catch (InvalidArgument e) {
            _log.error(e);
            code = ReturnCode.OperationFailed;
        }
        if (serviceId != null) {
            try {
                this._serviceProvider.getLookupService().unregisterService(serviceId);
                _log.info("Successfully deleted dummy service, we have sufficient privileges");
            }
            catch (Exception e) {
                _log.warn(String.format("The dummy service with service id '%s' didn't get unregistered. Cause: %s", serviceId, e.getCause()));
                _log.trace("", e);
            }
            code = ReturnCode.Success;
        }
        return code;
    }

    private static final ServiceRegistrationForm createDummyService() throws URISyntaxException {
        return new ServiceRegistrationForm("test", new URI("urn:test:dummy"), null, "test service", "This is a dummy test service to check permissions on LookupService. If you see it, the validations script failed to delete it.", new ServiceEndpoint[]{new ServiceEndpoint(null, new URI("test:address"), ServiceEndpoint.EndpointProtocol.unknown.toString())}, null, null);
    }
}

