/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.PersonUser;
import com.vmware.vim.sso.admin.PrincipalDiscovery;
import com.vmware.vim.sso.admin.SolutionUser;
import com.vmware.vim.sso.admin.exception.InternalError;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidateUsernameCommand
implements Command {
    private static final Log _log = LogFactory.getLog(ValidateUsernameCommand.class);
    private final DomainManagement _domainManagement;
    private final PrincipalDiscovery _principalDiscovery;
    private final String _solutionUsername;
    private final String _subjectDN;

    public ValidateUsernameCommand(DomainManagement domainManagement, PrincipalDiscovery principalDiscovery, String solutionUser, String subjectDN) {
        this._domainManagement = domainManagement;
        this._principalDiscovery = principalDiscovery;
        this._solutionUsername = solutionUser;
        this._subjectDN = subjectDN;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code = ReturnCode.OperationFailed;
        try {
            if (this.isUserFound()) {
                _log.info(String.format("A local user with name %s is already registered in SSO", this._solutionUsername));
                code = ReturnCode.AlreadyRegistered;
            } else {
                _log.debug("No local user found with name: " + this._solutionUsername);
                SolutionUser solUser = this._principalDiscovery.findSolutionUserByCertDN(this._subjectDN);
                if (solUser != null) {
                    _log.info(String.format("A solution user with subject DN '%s' is already registered in SSO", this._subjectDN));
                    code = ReturnCode.SubjectDnNotUnique;
                } else {
                    _log.info(String.format("No local user with name '%s' or subject DN '%s' is registered", this._solutionUsername, this._subjectDN));
                    code = ReturnCode.Success;
                }
            }
        }
        catch (NotAuthenticatedException e) {
            _log.error("This exception should never happen. Log a bug: " + e.getMessage());
            _log.debug(e);
            code = ReturnCode.OperationFailed;
        }
        catch (NoPermissionException e) {
            _log.error("The authenticated user has no permissions to execute the action: " + e.getMessage());
            _log.debug(e);
            code = ReturnCode.NotPrivileged;
        }
        catch (InternalError e) {
            code = ReturnCode.ServiceNotResponding;
        }
        return code;
    }

    private PersonUser findLocalPersonUser() throws NoPermissionException, NotAuthenticatedException {
        String sysDomainName = this._domainManagement.getSystemDomainName();
        PrincipalId userId = new PrincipalId(this._solutionUsername, sysDomainName);
        return this._principalDiscovery.findPersonUser(userId);
    }

    private boolean isUserFound() throws NoPermissionException, NotAuthenticatedException {
        boolean found = false;
        SolutionUser solUser = this._principalDiscovery.findSolutionUser(this._solutionUsername);
        if (solUser == null) {
            _log.debug("No solution user found with name: " + this._solutionUsername);
            PersonUser user = this.findLocalPersonUser();
            found = user != null;
        } else {
            found = true;
        }
        return found;
    }
}

