/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.util;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.install.impl.Constants;
import com.vmware.vim.sso.admin.util.CertificateUtil;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class EndpointFinderUtil {
    private final LookupService _lookupService;

    public EndpointFinderUtil(LookupService lookupService) {
        this._lookupService = lookupService;
    }

    public Map<String, ServiceEndpoint> findSsoEndpoints() throws InvalidArgument, SecurityError, ServiceFault {
        HashMap<String, ServiceEndpoint> ssoEndpoints = new HashMap<String, ServiceEndpoint>(3);
        ssoEndpoints.put("sts", this.findSingleServiceEndpoint(Constants.SSO_STS_TYPE, ServiceEndpoint.EndpointProtocol.wsTrust));
        ssoEndpoints.put("admin", this.findSingleServiceEndpoint(Constants.SSO_ADMIN_TYPE, ServiceEndpoint.EndpointProtocol.vmomi));
        ssoEndpoints.put("groupcheck", this.findSingleServiceEndpoint(Constants.SSO_GC_TYPE, ServiceEndpoint.EndpointProtocol.vmomi));
        return Collections.unmodifiableMap(ssoEndpoints);
    }

    public Map<String, X509Certificate> findSsoEndpointTrustAnchors() throws InvalidArgument, SecurityError, ServiceFault {
        Map<String, ServiceEndpoint> ssoEndpoints = this.findSsoEndpoints();
        HashMap<String, X509Certificate> trustAnchors = new HashMap<String, X509Certificate>();
        for (String key : ssoEndpoints.keySet()) {
            ServiceEndpoint endpoint = ssoEndpoints.get(key);
            X509Certificate trustAnchor = endpoint != null && !StringUtils.isEmpty(endpoint.getSslTrustAnchor()) ? CertificateUtil.decodeCertificate(endpoint.getSslTrustAnchor()) : null;
            trustAnchors.put(key, trustAnchor);
        }
        return Collections.unmodifiableMap(trustAnchors);
    }

    private ServiceEndpoint findSingleServiceEndpoint(URI serviceType, ServiceEndpoint.EndpointProtocol protocol) throws InvalidArgument, SecurityError, ServiceFault {
        Service service;
        Service[] services = this._lookupService.find(new SearchCriteria(serviceType, this._lookupService.getViSite(), protocol.name()));
        ServiceEndpoint serviceEndpoint = null;
        if (services != null && services.length > 0 && (service = services[0]).getEndpoints() != null && service.getEndpoints().length > 0) {
            serviceEndpoint = service.getEndpoints()[0];
        }
        return serviceEndpoint;
    }
}

