/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.util;

import com.vmware.vim.install.internals.CommonPaths;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LsFinderUtil {
    private static final String MSG_LS_ON_LOCAL_MACHINE = "Using Lookup Service: %s (on the current machine).";
    private static final Log _log = LogFactory.getLog(LsFinderUtil.class);

    public static URI autoFindLsUrl() {
        _log.debug("Trying to automatically find Lookup Service address.");
        URI lsUrl = LsFinderUtil.findLsFromViAccess();
        if (lsUrl == null) {
            lsUrl = LsFinderUtil.findLsFromHostname();
        }
        if (lsUrl == null) {
            lsUrl = LsFinderUtil.findLsFromPublicIP();
        }
        return lsUrl;
    }

    public static URI checkHttps(URI uri) throws URISyntaxException {
        if (!"https".equalsIgnoreCase(uri.getScheme())) {
            throw new URISyntaxException(uri.toString(), "Not a `https://' address");
        }
        return uri;
    }

    private static URI findLsFromViAccess() {
        URI lsUrl;
        File lsUrlFile = CommonPaths.getLsUrlFile();
        if (lsUrlFile.exists()) {
            _log.debug("System-wide lookup service address file exists, will read LS address from there.");
            try {
                FileReader lsUrlReader = new FileReader(lsUrlFile);
                lsUrl = LsFinderUtil.checkHttps(new URI(IOUtils.toString(lsUrlReader).trim()));
                _log.info(String.format("Using Lookup Service: %s  (from system-wide lookup service location file %s)", lsUrl.toString(), lsUrlFile.getAbsolutePath()));
            }
            catch (IOException e) {
                _log.warn(String.format("Warning: I/O error reading system-wide LS location file (%s)", lsUrlFile.getAbsolutePath()));
                _log.debug(e.getMessage(), e);
                lsUrl = null;
            }
            catch (URISyntaxException e) {
                _log.warn(String.format("Warning: system-wide LS location file (%s) contains invalid URI (%s)", lsUrlFile.getAbsolutePath(), e.getReason()));
                _log.debug(e.getMessage(), e);
                lsUrl = null;
            }
        } else {
            lsUrl = null;
        }
        return lsUrl;
    }

    private static URI findLsFromHostname() {
        try {
            URI lsUrl;
            InetAddress localhost = InetAddress.getByName(InetAddress.getLocalHost().getCanonicalHostName());
            URI uRI = lsUrl = LsFinderUtil.isPublicAddress(localhost) ? LsFinderUtil.defaultLsAtAddress(localhost) : null;
            if (lsUrl != null) {
                _log.info(String.format(MSG_LS_ON_LOCAL_MACHINE, lsUrl.toString()));
            }
            return lsUrl;
        }
        catch (UnknownHostException e) {
            _log.debug("Cannot get machine hostname or name is not resolvable. Not using it as LS address.", e);
            return null;
        }
    }

    private static URI findLsFromPublicIP() {
        URI lsUrl = LsFinderUtil.defaultLsAtAddress(LsFinderUtil.getFirstPublicAddress());
        if (lsUrl != null) {
            _log.info(String.format(MSG_LS_ON_LOCAL_MACHINE, lsUrl.toString()));
        }
        return lsUrl;
    }

    private static InetAddress getFirstPublicAddress() {
        InetAddress foundAddr = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements() && foundAddr == null) {
                foundAddr = LsFinderUtil.getFirstPublicAddressForIface(interfaces.nextElement());
            }
        }
        catch (SocketException e) {
            _log.debug("Cannot retrieve list of machine's addresses. Not using them to find the LS address.", e);
            foundAddr = null;
        }
        return foundAddr;
    }

    private static InetAddress getFirstPublicAddressForIface(NetworkInterface iface) {
        InetAddress foundAddr = null;
        Enumeration<InetAddress> addresses = iface.getInetAddresses();
        while (addresses.hasMoreElements() && foundAddr == null) {
            InetAddress addr = addresses.nextElement();
            if (!LsFinderUtil.isPublicAddress(addr)) continue;
            foundAddr = addr;
        }
        return foundAddr;
    }

    private static URI defaultLsAtAddress(InetAddress addr) {
        try {
            return new URI("https", null, addr.getHostAddress(), 7444, "/lookupservice/sdk", null, null);
        }
        catch (URISyntaxException e) {
            _log.debug(String.format("Unexpected failure constructing LS address from inet address %s: %s", addr.getHostAddress(), e.getReason()), e);
            return null;
        }
    }

    private static boolean isPublicAddress(InetAddress addr) {
        return !addr.isLinkLocalAddress() && !addr.isMulticastAddress() && !addr.isLoopbackAddress();
    }
}

