/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.impl;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.fault.InvalidRequest;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.install.RegistrationProviderConfig;
import com.vmware.vim.install.cli.util.EndpointFinderUtil;
import com.vmware.vim.install.exception.ClockSynchronizationException;
import com.vmware.vim.install.exception.ConnectionException;
import com.vmware.vim.install.exception.IncompatibleVersionException;
import com.vmware.vim.install.exception.InvalidCredentialsException;
import com.vmware.vim.install.exception.RegistrationException;
import com.vmware.vim.install.exception.SSLException;
import com.vmware.vim.install.impl.CertificateGetter;
import com.vmware.vim.install.impl.Constants;
import com.vmware.vim.install.impl.NullThumbprintVerifier;
import com.vmware.vim.sso.admin.ServerConfigurator;
import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.admin.client.AdminClientFactory;
import com.vmware.vim.sso.admin.client.ClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientFactory;
import com.vmware.vim.sso.admin.exception.CertificateValidationException;
import com.vmware.vim.sso.admin.exception.InternalError;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.util.CertificateUtil;
import com.vmware.vim.sso.client.DefaultSecurityTokenServiceFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.RequestExpiredException;
import com.vmware.vim.sso.client.exception.SsoException;
import com.vmware.vim.sso.client.exception.SsoRuntimeException;
import com.vmware.vim.sso.client.exception.TimeSynchronizationException;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ClientException;
import com.vmware.vim.vmomi.core.exception.InternalException;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AdminServiceAccess {
    private static final String INVALID_CREDENTIALS = "Provided credentials are not valid";
    private static final String UNEXPECTED_SERVER_ERROR = "An unexpected server error has occurred";
    private static final Log _log = LogFactory.getLog(AdminServiceAccess.class);
    private final URI _adminAddress;
    private final X509Certificate[] _trustStore;
    private final AuthnConfig _authnConfig;
    private final X509Certificate[] _stsTrustedRootCertificates;
    private final SamlToken _token;
    private final AdminClient _adminClient;
    private X509Certificate[] _sslCertificates = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdminServiceAccess(URI stsAddress, URI adminAddress, X509Certificate[] trustStore, AuthnConfig authnConfig, VmomiClientConfiguration.Version version) {
        this._adminAddress = adminAddress;
        this._trustStore = trustStore;
        this._authnConfig = authnConfig;
        _log.debug("Creating client for SSO Admin on address: " + adminAddress.toString());
        KeyStore ssoKs = CertificateGetter.createKeyStore(this._trustStore);
        AdminClient anonClient = null;
        try {
            anonClient = this.createSsoClient(adminAddress, ssoKs, null, version);
        }
        catch (InternalError e) {
            if (e.getCause() instanceof InvalidRequest) {
                throw new IncompatibleVersionException(e.getMessage(), e);
            }
            throw e;
        }
        try {
            ServerConfigurator serverConfigurator = anonClient.getServerConfigurator();
            _log.trace("Created configuration management service");
            this._stsTrustedRootCertificates = this.getRootCertificates(serverConfigurator);
        }
        finally {
            anonClient.dispose();
        }
        _log.trace("Got STS trusted root certificates");
        if (this._authnConfig.getAuthnType() != RegistrationProviderConfig.AuthnType.Anonymous) {
            this._token = this.acquireSamlToken(stsAddress, this._stsTrustedRootCertificates);
            _log.trace(String.format("Got token for user '%s@%s'", this._token.getSubject().getName(), this._token.getSubject().getDomain()));
            _log.trace("Added authentication context to lookup service");
        } else {
            this._token = null;
            _log.info("Anonymous execution");
        }
        this._adminClient = this.createSsoClient(adminAddress, ssoKs, this._token, version);
    }

    public static AdminServiceAccess createDiscover(LookupService lookupService, RegistrationProviderConfig config) {
        Map<String, ServiceEndpoint> endpoints;
        try {
            endpoints = new EndpointFinderUtil(lookupService).findSsoEndpoints();
        }
        catch (SecurityError e) {
            _log.error(INVALID_CREDENTIALS, e);
            throw new InvalidCredentialsException(INVALID_CREDENTIALS, e);
        }
        catch (ServiceFault e) {
            _log.error(UNEXPECTED_SERVER_ERROR, e);
            throw new RegistrationException(UNEXPECTED_SERVER_ERROR, e);
        }
        catch (UnexpectedStatusCodeException e) {
            _log.error(e.getMessage());
            _log.debug(e);
            throw new ConnectionException(e.getMessage(), e);
        }
        catch (InternalException e) {
            _log.error("Service unreachable");
            _log.debug("", e);
            throw new RegistrationException("Service unreachable", e);
        }
        ServiceEndpoint stsPt = endpoints.get("sts");
        ServiceEndpoint adminPt = endpoints.get("admin");
        AdminServiceAccess.checkSvcIsPresnet(stsPt, Constants.SSO_STS_TYPE);
        AdminServiceAccess.checkSvcIsPresnet(adminPt, Constants.SSO_ADMIN_TYPE);
        X509Certificate[] trustStore = new X509Certificate[]{CertificateUtil.decodeCertificate(stsPt.sslTrustAnchor), CertificateUtil.decodeCertificate(adminPt.sslTrustAnchor)};
        return new AdminServiceAccess(stsPt.getUrl(), adminPt.getUrl(), trustStore, AuthnConfig.fromProviderConfig(config), config.getSsoVersion());
    }

    public static AdminServiceAccess createDirect(RegistrationProviderConfig config) {
        return new AdminServiceAccess(config.getSsoConnectionConfig().getStsAddress(), config.getSsoConnectionConfig().getAdminAddress(), config.getSsoConnectionConfig().getSsoTrustStore(), AuthnConfig.fromProviderConfig(config), config.getSsoVersion());
    }

    public AdminClient getAdminService() {
        return this._adminClient;
    }

    public SamlToken getAuthnToken() {
        return this._token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate[] getSslCertificates() {
        if (this._sslCertificates == null) {
            AdminServiceAccess adminServiceAccess = this;
            synchronized (adminServiceAccess) {
                if (this._sslCertificates == null) {
                    this._sslCertificates = CertificateGetter.getSslCertificates(this._adminAddress);
                }
            }
        }
        return this._sslCertificates;
    }

    public X509Certificate[] getStsTrustedCertificates() {
        return this._stsTrustedRootCertificates;
    }

    private final SamlToken acquireSamlToken(URI stsLocation, X509Certificate[] rootCerts) throws InvalidCredentialsException, ConnectionException, ClockSynchronizationException {
        SecurityTokenServiceConfig config;
        SecurityTokenServiceConfig.HolderOfKeyConfig hokConf = this._authnConfig.getAuthnType() == RegistrationProviderConfig.AuthnType.Certificate ? new SecurityTokenServiceConfig.HolderOfKeyConfig(this._authnConfig.getSolutionPrivateKey(), this._authnConfig.getSolutionCertificate(), null) : null;
        try {
            config = new SecurityTokenServiceConfig(new SecurityTokenServiceConfig.ConnectionConfig(stsLocation.toURL(), this._trustStore, null), rootCerts, null, hokConf);
        }
        catch (MalformedURLException e) {
            throw new RegistrationException("The location of the STS stored in LS is not a valid URL", e);
        }
        SecurityTokenService service = DefaultSecurityTokenServiceFactory.getSecurityTokenService(config);
        try {
            TokenSpec tokenSpec = new TokenSpec.Builder(50L).createTokenSpec();
            return hokConf == null ? service.acquireToken(this._authnConfig.getUsername(), String.valueOf(this._authnConfig.getPassword()), tokenSpec) : service.acquireTokenByCertificate(tokenSpec);
        }
        catch (SsoException e) {
            _log.debug(e.getMessage());
            _log.trace("", e);
            throw new InvalidCredentialsException("Cannot authenticate user", e);
        }
        catch (RequestExpiredException e) {
            _log.debug(e.getMessage());
            _log.trace("", e);
            throw new ConnectionException(e.getMessage(), e);
        }
        catch (TimeSynchronizationException e) {
            _log.debug(e.getMessage());
            _log.trace("", e);
            throw new ClockSynchronizationException(e.getMessage(), e);
        }
        catch (SsoRuntimeException e) {
            _log.debug(e.getMessage());
            _log.trace("", e);
            throw new ConnectionException(e.getMessage(), e);
        }
    }

    private final X509Certificate[] getRootCertificates(ServerConfigurator sc) throws RegistrationException, InvalidCredentialsException {
        try {
            return sc.getTrustedCertificates().toArray(new X509Certificate[0]);
        }
        catch (SystemException e) {
            _log.error(UNEXPECTED_SERVER_ERROR, e);
            throw new RegistrationException(UNEXPECTED_SERVER_ERROR, e);
        }
    }

    private final AdminClient createSsoClient(URI ssoAdminLocation, KeyStore ssoKs, SamlToken token, VmomiClientConfiguration.Version version) throws ConnectionException, InvalidCredentialsException, RegistrationException {
        VmomiClientConfiguration config = new VmomiClientConfiguration.Builder(ssoAdminLocation, version).setSslConfiguration(new VmomiClientConfiguration.SslConfiguration(new NullThumbprintVerifier(), ssoKs, null)).createConfig();
        AdminClientFactory factory = VmomiClientFactory.createAdminClientFactory(config);
        try {
            AdminClient client;
            if (token == null) {
                client = factory.createAdminClient();
            } else {
                ClientConfiguration.AuthenticationData authnData = this._authnConfig.getAuthnType() == RegistrationProviderConfig.AuthnType.Certificate ? new ClientConfiguration.AuthenticationData(token, this._authnConfig.getSolutionPrivateKey()) : new ClientConfiguration.AuthenticationData(token);
                client = factory.createAdminClient(new ClientConfiguration(authnData));
            }
            return client;
        }
        catch (CertificateValidationException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            throw new SSLException(e.getMessage(), e);
        }
        catch (com.vmware.vim.sso.admin.client.InvalidCredentialsException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            throw new InvalidCredentialsException(e);
        }
        catch (SystemException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            throw new RegistrationException(e);
        }
        catch (ClientException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            throw new RegistrationException(e.getMessage(), e);
        }
    }

    private static void checkSvcIsPresnet(ServiceEndpoint endpoint, URI ssoStsType) {
        if (endpoint == null) {
            String message = "No entries for service of type " + ssoStsType.toString() + " found in LookupService";
            _log.error(message);
            throw new RegistrationException(message);
        }
    }

    public static final class AuthnConfig {
        private final RegistrationProviderConfig.AuthnType _authnType;
        private final String _username;
        private final char[] _password;
        private final PrivateKey _solutionPrivateKey;
        private final X509Certificate _solutionCertificate;

        private AuthnConfig(RegistrationProviderConfig.AuthnType authnType, String username, char[] password, PrivateKey solnKey, X509Certificate solnCertificate) {
            this._authnType = authnType;
            this._username = username;
            this._password = password;
            this._solutionPrivateKey = solnKey;
            this._solutionCertificate = solnCertificate;
        }

        public static AuthnConfig anonymous() {
            return new AuthnConfig(RegistrationProviderConfig.AuthnType.Anonymous, null, null, null, null);
        }

        public static AuthnConfig passwordAuthn(String username, char[] password) {
            return new AuthnConfig(RegistrationProviderConfig.AuthnType.Password, username, password, null, null);
        }

        public static AuthnConfig solutionAuthn(PrivateKey solnKey, X509Certificate solnCertificate) {
            return new AuthnConfig(RegistrationProviderConfig.AuthnType.Certificate, null, null, solnKey, solnCertificate);
        }

        public static AuthnConfig fromProviderConfig(RegistrationProviderConfig config) {
            switch (config.getAuthnType()) {
                case Anonymous: {
                    return AuthnConfig.anonymous();
                }
                case Password: {
                    return AuthnConfig.passwordAuthn(config.getUsername(), config.getPassword());
                }
                case Certificate: {
                    return AuthnConfig.solutionAuthn(config.getSolutionPrivateKey(), config.getSolutionCertificate());
                }
            }
            throw new IllegalStateException();
        }

        public RegistrationProviderConfig.AuthnType getAuthnType() {
            return this._authnType;
        }

        public String getUsername() {
            return this._username;
        }

        public char[] getPassword() {
            return this._password;
        }

        public PrivateKey getSolutionPrivateKey() {
            return this._solutionPrivateKey;
        }

        public X509Certificate getSolutionCertificate() {
            return this._solutionCertificate;
        }
    }
}

