/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.impl;

import com.vmware.vim.install.exception.ConnectionException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CertificateGetter {
    private static final int CONNECTION_TIMEOUT_MS = 60000;
    private static final String KEYSTORE_TYPE = "JKS";
    private static final Log log = LogFactory.getLog(CertificateGetter.class);

    public static final X509Certificate[] getSslCertificates(URI endpoint) throws ConnectionException {
        URL address;
        try {
            address = endpoint.toURL();
        }
        catch (MalformedURLException e) {
            log.error("Invalid URL", e);
            throw new ConnectionException(e);
        }
        if (log.isInfoEnabled()) {
            log.info("Getting SSL certificates for " + address.toString());
        }
        Socket socket = null;
        try {
            NullTrustManager trm = new NullTrustManager();
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{trm}, null);
            SSLSocketFactory factory = sc.getSocketFactory();
            int port = address.getPort();
            port = port == -1 ? 443 : port;
            socket = (SSLSocket)factory.createSocket();
            InetSocketAddress inetAddress = new InetSocketAddress(address.getHost(), port);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Establishing socket connection to %s. Timeout is %d", inetAddress.toString(), 60000));
            }
            socket.connect(inetAddress, 60000);
            socket.setSoTimeout(60000);
            ((SSLSocket)socket).startHandshake();
            Certificate[] certs = ((SSLSocket)socket).getSession().getPeerCertificates();
            X509Certificate[] certificates = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                if (log.isTraceEnabled()) {
                    log.trace(certs[i]);
                }
                certificates[i] = (X509Certificate)certs[i];
            }
            X509Certificate[] x509CertificateArray = certificates;
            return x509CertificateArray;
        }
        catch (NoSuchAlgorithmException e) {
            String message = "Internal error: Cannot load SSL context";
            log.error(message, e);
            throw new IllegalStateException(message, e);
        }
        catch (KeyManagementException e) {
            String message = "Cannot initialize SSL context";
            log.error(message, e);
            throw new IllegalStateException(message, e);
        }
        catch (SocketTimeoutException e) {
            String message = "Cannot connect to server - connection has timed out";
            log.error(message);
            log.debug("", e);
            throw new ConnectionException(message, e);
        }
        catch (IOException e) {
            String message = "Unable to connect to server";
            log.error(message);
            log.debug("", e);
            throw new ConnectionException(message, e);
        }
        finally {
            block19: {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        if (!log.isTraceEnabled()) break block19;
                        log.trace(e.getMessage(), e);
                    }
                }
            }
        }
    }

    public static final KeyStore createKeyStore(X509Certificate[] certificates) {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
            ks.load(null);
            int i = 0;
            for (X509Certificate cert : certificates) {
                ks.setCertificateEntry(++i + cert.getSubjectDN().getName(), cert);
            }
            return ks;
        }
        catch (KeyStoreException e) {
            log.error("Invalid keystore type: JKS", e);
            throw new IllegalStateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("May be a wrong JRE is installed: " + e.getMessage(), e);
            throw new IllegalStateException("Cannot load keystore, might be a wrong JRE", e);
        }
        catch (CertificateException e) {
            log.error("This might be a bug: " + e.getMessage(), e);
            throw new IllegalStateException("Cannot load keystore", e);
        }
        catch (IOException e) {
            log.error("This might be a bug or wrong JRE: " + e.getMessage(), e);
            throw new IllegalStateException("Cannot load keystore", e);
        }
    }

    private static final class NullTrustManager
    implements X509TrustManager {
        private NullTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

