/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.impl;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.ServiceContent;
import com.vmware.vim.binding.lookup.ServiceInstance;
import com.vmware.vim.binding.lookup.version.version1;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.install.exception.ConnectionException;
import com.vmware.vim.install.exception.RegistrationException;
import com.vmware.vim.install.exception.SSLException;
import com.vmware.vim.install.impl.CertificateGetter;
import com.vmware.vim.install.impl.NullThumbprintVerifier;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ClientException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LookupServiceAccess {
    private static final String LS_SERVICEINSTANCE_NAME = "ServiceInstance";
    private final Log _log = LogFactory.getLog(this.getClass());
    private final URI _lsAddress;
    private final LookupService _lookupService;

    public LookupServiceAccess(URI lsAddress, KeyStore trustStore, ThumbprintVerifier verifier) {
        this._lsAddress = lsAddress;
        this._log.debug("Creating VMODL client for LookupService");
        KeyStore lsKs = trustStore == null ? CertificateGetter.createKeyStore(this.downloadSslCertificates()) : trustStore;
        Client lsClient = this.createClient(lsAddress, version1.class, verifier, lsKs);
        this._lookupService = this.createLookupService(lsClient);
    }

    public LookupService getLookupService() {
        return this._lookupService;
    }

    public X509Certificate[] downloadSslCertificates() {
        return CertificateGetter.getSslCertificates(this._lsAddress);
    }

    private final Client createClient(URI serverAddress, Class<?> versionClazz, ThumbprintVerifier verifier, KeyStore keystore) {
        HttpConfiguration config = HttpConfiguration.Factory.newInstance();
        if (verifier != null) {
            config.setThumbprintVerifier(verifier);
        } else {
            config.setTrustStore(keystore);
            config.setThumbprintVerifier(new NullThumbprintVerifier());
        }
        HttpClientConfiguration clientConfig = HttpClientConfiguration.Factory.newInstance();
        clientConfig.setHttpConfiguration(config);
        return Client.Factory.createClient(serverAddress, versionClazz, clientConfig);
    }

    private final LookupService createLookupService(Client lsClient) throws RegistrationException {
        try {
            ServiceInstance si = lsClient.createStub(ServiceInstance.class, LookupServiceAccess.createServiceInstanceMoRef());
            ServiceContent serviceContent = si.retrieveServiceContent();
            return lsClient.createStub(LookupService.class, serviceContent.getLookupService());
        }
        catch (UnexpectedStatusCodeException e) {
            this._log.error(e.getMessage());
            this._log.debug(e);
            throw new ConnectionException(e.getMessage(), e);
        }
        catch (SslException e) {
            this._log.error(e.getMessage());
            this._log.debug("", e);
            throw new SSLException(e.getMessage(), e);
        }
        catch (ClientException e) {
            this._log.error("Service unreachable");
            this._log.debug("", e);
            throw new RegistrationException("Service unreachable", e);
        }
    }

    private static final ManagedObjectReference createServiceInstanceMoRef() {
        VmodlType type = VmodlTypeMap.Factory.getTypeMap().getVmodlType(ServiceInstance.class);
        ManagedObjectReference siMoRef = new ManagedObjectReference();
        siMoRef.setType(type.getWsdlName());
        siMoRef.setValue(LS_SERVICEINSTANCE_NAME);
        return siMoRef;
    }

    static {
        VmodlContext.initContext(new String[]{"com.vmware.vim.binding.lookup"});
    }
}

