/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.internals;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DefaultThumbprintVerifier
implements ThumbprintVerifier {
    private static final Log _log = LogFactory.getLog(DefaultThumbprintVerifier.class);
    private static final Set<String> TAG_ALLOW_INSECURE = new HashSet<String>();
    private final String _expectedThumbprint;

    public DefaultThumbprintVerifier(String expectedThumbprint) {
        TAG_ALLOW_INSECURE.add("insecure");
        TAG_ALLOW_INSECURE.add("trust");
        this._expectedThumbprint = expectedThumbprint == null ? "" : expectedThumbprint.trim();
    }

    @Override
    public ThumbprintVerifier.Result verify(String thumbprint) {
        ThumbprintVerifier.Result verifyResult;
        if (this._expectedThumbprint.isEmpty()) {
            _log.debug("No trusted thumbprint provided, defaulting to default validation.");
            verifyResult = ThumbprintVerifier.Result.UNKNOWN;
        } else {
            verifyResult = this._expectedThumbprint.equalsIgnoreCase(thumbprint) || TAG_ALLOW_INSECURE.contains(this._expectedThumbprint) ? ThumbprintVerifier.Result.MATCH : ThumbprintVerifier.Result.MISMATCH;
        }
        return verifyResult;
    }

    @Override
    public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertions) throws SSLException {
    }
}

