/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.internals;

import com.vmware.vim.install.impl.CertificateGetter;
import com.vmware.vim.install.internals.CommonPaths;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class SystemWideTrustStore {
    private static final FilenameFilter PEM_FILTER;
    private static final Log _log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public static KeyStore get() {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Internal error: cannot create CertificateFactory(X.509, BC).", e);
        }
        _log.debug("Loading the system-wide trust store.");
        HashSet<X509Certificate> trustedCertificates = new HashSet<X509Certificate>();
        File[] certFiles = CommonPaths.getSystemTrustStoreDir().listFiles(PEM_FILTER);
        for (File certFile : certFiles = certFiles == null ? new File[]{} : certFiles) {
            FileInputStream certStr = null;
            try {
                certStr = new FileInputStream(certFile);
                for (Certificate readCert : cf.generateCertificates(certStr)) {
                    trustedCertificates.add((X509Certificate)readCert);
                }
            }
            catch (CertificateException e) {
                _log.info(String.format("Error loading certificates from file %s: %s . File ignored.", certFile.getAbsolutePath(), e.getMessage()));
                _log.debug("", e);
                IOUtils.closeQuietly(certStr);
                continue;
            }
            catch (FileNotFoundException e2) {
                _log.info(String.format("Cannot open certificate file %s for reading: %s", certFile.getAbsolutePath(), e2.getMessage()));
                _log.debug("", e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(certStr);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(certStr);
                continue;
            }
            IOUtils.closeQuietly(certStr);
        }
        _log.debug(String.format("System trust store loaded successfully; total: %d trusted certificates.", trustedCertificates.size()));
        return CertificateGetter.createKeyStore(trustedCertificates.toArray(new X509Certificate[trustedCertificates.size()]));
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        PEM_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name2) {
                return name2.endsWith(".pem");
            }
        };
        _log = LogFactory.getLog(SystemWideTrustStore.class);
    }
}

