/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.CertificateManager;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.sso.admin.CertificateManagement;
import com.vmware.vim.sso.admin.client.vmomi.impl.SdkVmodlTypeConversions;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import java.security.cert.X509Certificate;
import java.util.Set;

final class CertificateManagementImpl
implements CertificateManagement {
    private final CertificateManager _service;

    public CertificateManagementImpl(CertificateManager service) {
        assert (service != null);
        this._service = service;
    }

    public boolean addCertificate(final X509Certificate certificate) throws NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotNull((Object)certificate, (String)"Certificate");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws NotAuthenticated {
                return CertificateManagementImpl.this._service.addCertificate(VmodlTypeConversions.certificateToVmodl((X509Certificate)certificate));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<X509Certificate> getAllCertificates() throws NotAuthenticatedException, NoPermissionException {
        return (Set)new VmomiClientCommand<Set<X509Certificate>>(){

            @Override
            public Set<X509Certificate> actionCommand() throws NotAuthenticated {
                return SdkVmodlTypeConversions.certificateSetFromVmodl(CertificateManagementImpl.this._service.getAllCertificates());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public X509Certificate findCertificate(final String fingerprint) throws NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)fingerprint, (String)"Certificate fingerprint");
        return (X509Certificate)new VmomiClientCommand<X509Certificate>(){

            @Override
            public X509Certificate actionCommand() throws NotAuthenticated {
                return VmodlTypeConversions.certificateFromVmodl((String)CertificateManagementImpl.this._service.findCertificate(fingerprint));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public boolean deleteCertificate(final String fingerprint) throws NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)fingerprint, (String)"Certificate fingerprint");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws NotAuthenticated {
                return CertificateManagementImpl.this._service.deleteCertificate(fingerprint);
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }
}

